/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.components;

import de.codecrafter47.taboverlay.config.dsl.ComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedPropertyBase;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.expression.template.ConstantExpressionTemplate;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.template.component.ConditionalComponentTemplate;

public class ConditionalComponentConfiguration
extends MarkedPropertyBase
implements ComponentConfiguration {
    private MarkedStringProperty condition;
    private ComponentConfiguration trueReplacement;
    private ComponentConfiguration falseReplacement;

    public ComponentConfiguration getTrue() {
        return this.trueReplacement;
    }

    public void setTrue(ComponentConfiguration trueReplacement) {
        this.trueReplacement = trueReplacement;
    }

    public ComponentConfiguration getFalse() {
        return this.falseReplacement;
    }

    public void setFalse(ComponentConfiguration falseReplacement) {
        this.falseReplacement = falseReplacement;
    }

    @Override
    public ComponentTemplate toTemplate(TemplateCreationContext tcc) {
        ExpressionTemplate expressionTemplate;
        block3: {
            expressionTemplate = ConstantExpressionTemplate.of(true);
            if (ConfigValidationUtil.checkNotNull(tcc, "!conditional component", "condition", this.condition, this.getStartMark())) {
                try {
                    expressionTemplate = tcc.getExpressionEngine().compile(tcc, this.condition.getValue(), this.condition.getStartMark());
                }
                catch (Throwable th) {
                    if (tcc.getErrorHandler().hasErrors()) break block3;
                    tcc.getErrorHandler().addError("Failed to configure conditional component. Failed to parse condition: " + th.getMessage(), this.condition.getStartMark());
                }
            }
        }
        return ConditionalComponentTemplate.builder().condition(expressionTemplate).trueReplacement(this.trueReplacement != null ? this.trueReplacement.toTemplate(tcc) : tcc.emptyComponent()).falseReplacement(this.falseReplacement != null ? this.falseReplacement.toTemplate(tcc) : tcc.emptyComponent()).build();
    }

    public MarkedStringProperty getCondition() {
        return this.condition;
    }

    public ComponentConfiguration getTrueReplacement() {
        return this.trueReplacement;
    }

    public ComponentConfiguration getFalseReplacement() {
        return this.falseReplacement;
    }

    public void setCondition(MarkedStringProperty condition) {
        this.condition = condition;
    }

    public void setTrueReplacement(ComponentConfiguration trueReplacement) {
        this.trueReplacement = trueReplacement;
    }

    public void setFalseReplacement(ComponentConfiguration falseReplacement) {
        this.falseReplacement = falseReplacement;
    }
}

