/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.components;

import de.codecrafter47.taboverlay.config.dsl.ComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.IconTemplateConfiguration;
import de.codecrafter47.taboverlay.config.dsl.PingTemplateConfiguration;
import de.codecrafter47.taboverlay.config.dsl.TextTemplateConfiguration;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedPropertyBase;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.component.BasicComponentTemplate;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.libs.snakeyaml.error.Mark;
import java.util.Optional;

public class BasicComponentConfiguration
extends MarkedPropertyBase
implements ComponentConfiguration {
    private TextTemplateConfiguration text = null;
    private TextTemplateConfiguration left = null;
    private TextTemplateConfiguration center = null;
    private TextTemplateConfiguration right = null;
    private IconTemplateConfiguration icon = IconTemplateConfiguration.DEFAULT;
    private PingTemplateConfiguration ping = PingTemplateConfiguration.DEFAULT;
    private Alignment alignment = Alignment.LEFT;
    private LongTextBehaviour longText = null;
    private transient boolean needToFixMark = false;

    public BasicComponentConfiguration(String text) {
        if (text != null) {
            this.text = new TextTemplateConfiguration(text);
        }
        this.needToFixMark = true;
    }

    @Override
    public void setStartMark(Mark startMark) {
        super.setStartMark(startMark);
        if (this.needToFixMark) {
            this.text.setStartMark(startMark);
        }
    }

    @Override
    public ComponentTemplate toTemplate(TemplateCreationContext tcc) {
        TextTemplate centerTemplate;
        TextTemplate leftTemplate;
        if (this.alignment == null) {
            this.alignment = Alignment.LEFT;
        }
        if (this.text != null && this.alignment == Alignment.LEFT && this.left != null) {
            tcc.getErrorHandler().addWarning("Cannot use `text: \"...\", alignment: LEFT` and `left: \"...\"` at the same time", this.getStartMark());
        }
        if (this.text != null && this.alignment == Alignment.CENTER && this.center != null) {
            tcc.getErrorHandler().addWarning("Cannot use `text: \"...\", alignment: LEFT` and `left: \"...\"` at the same time", this.getStartMark());
        }
        if (this.text != null && this.alignment == Alignment.RIGHT && this.right != null) {
            tcc.getErrorHandler().addWarning("Cannot use `text: \"...\", alignment: LEFT` and `left: \"...\"` at the same time", this.getStartMark());
        }
        TextTemplate textTemplate = this.left != null ? this.left.toTemplate(tcc) : (leftTemplate = this.alignment == Alignment.LEFT && this.text != null ? this.text.toTemplate(tcc) : null);
        TextTemplate textTemplate2 = this.center != null ? this.center.toTemplate(tcc) : (centerTemplate = this.alignment == Alignment.CENTER && this.text != null ? this.text.toTemplate(tcc) : null);
        TextTemplate rightTemplate = this.right != null ? this.right.toTemplate(tcc) : (this.alignment == Alignment.RIGHT && this.text != null ? this.text.toTemplate(tcc) : null);
        return BasicComponentTemplate.builder().icon(this.icon != null ? this.icon.toTemplate(tcc) : tcc.getDefaultIcon()).leftText(leftTemplate).centerText(centerTemplate).rightText(rightTemplate).ping(this.ping != null ? this.ping.toTemplate(tcc) : tcc.getDefaultPing()).longText(Optional.ofNullable(this.longText).orElse(tcc.getDefaultLongTextBehaviour().orElse(LongTextBehaviour.DISPLAY_ALL))).build();
    }

    public TextTemplateConfiguration getText() {
        return this.text;
    }

    public TextTemplateConfiguration getLeft() {
        return this.left;
    }

    public TextTemplateConfiguration getCenter() {
        return this.center;
    }

    public TextTemplateConfiguration getRight() {
        return this.right;
    }

    public IconTemplateConfiguration getIcon() {
        return this.icon;
    }

    public PingTemplateConfiguration getPing() {
        return this.ping;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public LongTextBehaviour getLongText() {
        return this.longText;
    }

    public boolean isNeedToFixMark() {
        return this.needToFixMark;
    }

    public void setText(TextTemplateConfiguration text) {
        this.text = text;
    }

    public void setLeft(TextTemplateConfiguration left) {
        this.left = left;
    }

    public void setCenter(TextTemplateConfiguration center) {
        this.center = center;
    }

    public void setRight(TextTemplateConfiguration right) {
        this.right = right;
    }

    public void setIcon(IconTemplateConfiguration icon) {
        this.icon = icon;
    }

    public void setPing(PingTemplateConfiguration ping) {
        this.ping = ping;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public void setLongText(LongTextBehaviour longText) {
        this.longText = longText;
    }

    public void setNeedToFixMark(boolean needToFixMark) {
        this.needToFixMark = needToFixMark;
    }

    public BasicComponentConfiguration() {
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum LongTextBehaviour {
        DISPLAY_ALL,
        CROP,
        CROP_2DOTS,
        CROP_3DOTS;

    }
}

