/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl.components;

import de.codecrafter47.taboverlay.config.dsl.ComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedFloatProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedListProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedPropertyBase;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.component.AnimatedComponentTemplate;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import java.util.ArrayList;

public class AnimatedComponentConfiguration
extends MarkedPropertyBase
implements ComponentConfiguration {
    private MarkedListProperty<ComponentConfiguration> components;
    private boolean randomize = false;
    private MarkedFloatProperty interval;

    @Override
    public ComponentTemplate toTemplate(TemplateCreationContext tcc) {
        if ((ConfigValidationUtil.checkNotNull(tcc, "!animated component", "components", this.components, this.getStartMark()) && ConfigValidationUtil.checkNotEmpty(tcc, "!animated component", "components", this.components, this.components.getStartMark())) & ConfigValidationUtil.checkNotNull(tcc, "!animated component", "interval", this.interval, this.getStartMark()) && ConfigValidationUtil.checkRange(tcc, "!animated component", "interval", this.interval.getValue(), 0.05f, 9999.0f, this.interval.getStartMark())) {
            ArrayList<ComponentTemplate> componentTemplates = new ArrayList<ComponentTemplate>(this.components.size());
            for (ComponentConfiguration component : this.components) {
                if (component == null) {
                    componentTemplates.add(tcc.emptySlot());
                    continue;
                }
                componentTemplates.add(component.toTemplate(tcc));
            }
            if (!((ComponentTemplate)componentTemplates.get(0)).getLayoutInfo().isConstantSize()) {
                tcc.getErrorHandler().addError("Animated components can only contain components of constant size.", ((ComponentConfiguration)this.components.get(0)).getStartMark());
            }
            int size = ((ComponentTemplate)componentTemplates.get(0)).getLayoutInfo().getMinSize();
            boolean blockAligned = ((ComponentTemplate)componentTemplates.get(0)).getLayoutInfo().isBlockAligned();
            for (int i = 1; i < componentTemplates.size(); ++i) {
                if (!((ComponentTemplate)componentTemplates.get(i)).getLayoutInfo().isConstantSize()) {
                    tcc.getErrorHandler().addError("Animated components can only contain components of constant size.", (this.components.get(i) != null ? (MarkedProperty)this.components.get(i) : this.components).getStartMark());
                }
                if (((ComponentTemplate)componentTemplates.get(i)).getLayoutInfo().getMinSize() != size) {
                    tcc.getErrorHandler().addError("Animated components can only contain components of the same size.", (this.components.get(i) != null ? (MarkedProperty)this.components.get(i) : this.components).getStartMark());
                }
                if (((ComponentTemplate)componentTemplates.get(i)).getLayoutInfo().isBlockAligned() == blockAligned) continue;
                tcc.getErrorHandler().addError("Animated components can only contain components with the same alignment requirement.", (this.components.get(i) != null ? (MarkedProperty)this.components.get(i) : this.components).getStartMark());
            }
            return AnimatedComponentTemplate.builder().components(componentTemplates).interval(this.interval.getValue()).randomize(this.randomize).build();
        }
        return tcc.emptyComponent();
    }

    public MarkedListProperty<ComponentConfiguration> getComponents() {
        return this.components;
    }

    public boolean isRandomize() {
        return this.randomize;
    }

    public MarkedFloatProperty getInterval() {
        return this.interval;
    }

    public void setComponents(MarkedListProperty<ComponentConfiguration> components) {
        this.components = components;
    }

    public void setRandomize(boolean randomize) {
        this.randomize = randomize;
    }

    public void setInterval(MarkedFloatProperty interval) {
        this.interval = interval;
    }
}

