/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl;

import de.codecrafter47.taboverlay.config.dsl.AbstractTabOverlayTemplateConfiguration;
import de.codecrafter47.taboverlay.config.dsl.ComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.IconTemplateConfiguration;
import de.codecrafter47.taboverlay.config.dsl.PingTemplateConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedIntegerProperty;
import de.codecrafter47.taboverlay.config.template.RectangularTabOverlayTemplate;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;

public class RectangularTabOverlayTemplateConfiguration
extends AbstractTabOverlayTemplateConfiguration<RectangularTabOverlayTemplate> {
    private MarkedIntegerProperty size = null;
    private MarkedIntegerProperty columns = null;
    private IconTemplateConfiguration defaultIcon;
    private PingTemplateConfiguration defaultPing = PingTemplateConfiguration.ZERO;
    private ComponentConfiguration components;

    @Override
    protected RectangularTabOverlayTemplate createTemplate() {
        return new RectangularTabOverlayTemplate();
    }

    @Override
    protected void populateTemplate(RectangularTabOverlayTemplate template, TemplateCreationContext tcc) {
        super.populateTemplate(template, tcc);
        TemplateCreationContext child = tcc.clone();
        if (this.size == null && this.columns == null) {
            tcc.getErrorHandler().addError("Failed to configure RECTANGULAR tab list. Either the size or the columns property must be set.", null);
        } else if (this.size != null && this.columns != null) {
            tcc.getErrorHandler().addError("Failed to configure RECTANGULAR tab list. The size and columns options are mutually exclusive. Only set one of them.", null);
        } else if (this.size != null && this.size.getValue() < 0) {
            tcc.getErrorHandler().addError("Failed to configure RECTANGULAR tab list. Size is negative.", this.size.getStartMark());
        } else if (this.size != null && !ConfigValidationUtil.isRectangular(this.size.getValue())) {
            tcc.getErrorHandler().addError("Failed to configure RECTANGULAR tab list. size is not rectangular.", this.size.getStartMark());
        } else if (this.columns != null && this.columns.getValue() < 1) {
            tcc.getErrorHandler().addError("Failed to configure RECTANGULAR tab list. Columns is not positive.", this.size.getStartMark());
        } else {
            child.setColumns(this.columns != null ? this.columns.getValue() : (this.size.getValue() + 19) / 20);
            template.setSize(this.size != null ? this.size.getValue() : -1);
            template.setColumns(this.columns != null ? this.columns.getValue() : -1);
        }
        if (this.size != null && this.size.getValue() > 80) {
            tcc.getErrorHandler().addWarning("size must not be greater than 80.", this.size.getStartMark());
        }
        if (this.columns != null && this.columns.getValue() > 4) {
            tcc.getErrorHandler().addWarning("columns must not be greater than 4.", this.columns.getStartMark());
        }
        if (ConfigValidationUtil.checkNotNull(tcc, "RECTANGULAR tab overlay", "defaultIcon", this.defaultIcon, null)) {
            child.setDefaultIcon(this.defaultIcon.toTemplate(tcc));
        }
        if (ConfigValidationUtil.checkNotNull(tcc, "RECTANGULAR tab overlay", "defaultPing", this.defaultPing, null)) {
            child.setDefaultPing(this.defaultPing.toTemplate(tcc));
        }
        if (ConfigValidationUtil.checkNotNull(tcc, "RECTANGULAR tab overlay", "components", this.components, null)) {
            ComponentTemplate contentRoot = this.components.toTemplate(child);
            template.setContentRoot(contentRoot);
            int contentMinSize = contentRoot.getLayoutInfo().getMinSize();
            if (this.size != null && this.size.getValue() < contentMinSize) {
                tcc.getErrorHandler().addWarning("size set to " + this.size.getValue() + ", but to display everything at least " + contentMinSize + " slots would be required.", this.size.getStartMark());
            }
            if (this.columns != null && this.columns.getValue() * 20 < contentMinSize) {
                tcc.getErrorHandler().addWarning("columns set to " + this.columns.getValue() + " which implies a maximum size of " + this.columns.getValue() * 20 + ", but to display everything at least " + contentMinSize + " slots would be required.", this.columns.getStartMark());
            }
        }
    }

    public MarkedIntegerProperty getSize() {
        return this.size;
    }

    public MarkedIntegerProperty getColumns() {
        return this.columns;
    }

    public IconTemplateConfiguration getDefaultIcon() {
        return this.defaultIcon;
    }

    public PingTemplateConfiguration getDefaultPing() {
        return this.defaultPing;
    }

    public ComponentConfiguration getComponents() {
        return this.components;
    }

    public void setSize(MarkedIntegerProperty size) {
        this.size = size;
    }

    public void setColumns(MarkedIntegerProperty columns) {
        this.columns = columns;
    }

    public void setDefaultIcon(IconTemplateConfiguration defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    public void setDefaultPing(PingTemplateConfiguration defaultPing) {
        this.defaultPing = defaultPing;
    }

    public void setComponents(ComponentConfiguration components) {
        this.components = components;
    }
}

