/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl;

import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedPropertyBase;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.template.PlayerSetTemplate;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.libs.snakeyaml.error.Mark;
import java.util.Optional;

public class PlayerSetConfiguration
extends MarkedPropertyBase {
    private MarkedStringProperty filter;
    private Visibility hiddenPlayers = null;
    private transient boolean fixMark;

    public PlayerSetConfiguration(String expression) {
        this.filter = new MarkedStringProperty(expression);
        this.fixMark = true;
    }

    @Override
    public void setStartMark(Mark startMark) {
        super.setStartMark(startMark);
        if (this.fixMark) {
            this.filter.setStartMark(startMark);
        }
    }

    public PlayerSetTemplate toTemplate(TemplateCreationContext tcc) {
        TemplateCreationContext childContext = tcc.clone();
        childContext.setPlayerAvailable(true);
        ExpressionTemplate predicate = tcc.getExpressionEngine().compile(childContext, this.filter.getValue(), this.filter.getStartMark());
        return PlayerSetTemplate.builder().predicate(predicate).hiddenPlayersVisibility(Optional.ofNullable(this.hiddenPlayers).orElse(tcc.getDefaultHiddenPlayerVisibility())).build();
    }

    public MarkedStringProperty getFilter() {
        return this.filter;
    }

    public Visibility getHiddenPlayers() {
        return this.hiddenPlayers;
    }

    public boolean isFixMark() {
        return this.fixMark;
    }

    public void setFilter(MarkedStringProperty filter) {
        this.filter = filter;
    }

    public void setHiddenPlayers(Visibility hiddenPlayers) {
        this.hiddenPlayers = hiddenPlayers;
    }

    public void setFixMark(boolean fixMark) {
        this.fixMark = fixMark;
    }

    public PlayerSetConfiguration() {
    }

    public static enum Visibility {
        VISIBLE,
        VISIBLE_TO_ADMINS,
        INVISIBLE;

    }
}

