/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.config.SortingRulePreprocessor;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedPropertyBase;
import de.codecrafter47.taboverlay.config.misc.Unchecked;
import de.codecrafter47.taboverlay.config.placeholder.DataHolderPlaceholderDataProviderSupplier;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderException;
import de.codecrafter47.taboverlay.config.placeholder.UnknownPlaceholderException;
import de.codecrafter47.taboverlay.config.template.PlayerOrderTemplate;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class PlayerOrderConfiguration
extends MarkedPropertyBase {
    public static final PlayerOrderConfiguration DEFAULT = new PlayerOrderConfiguration("name as text asc");
    private static final Set<TypeToken<?>> NUMERIC_TYPES = ImmutableSet.of(TypeToken.INTEGER, TypeToken.FLOAT, TypeToken.DOUBLE, TypeToken.BOOLEAN);
    private static final Set<TypeToken<?>> STRING_TYPES = ImmutableSet.of(TypeToken.STRING);
    private static final Map<String, PlayerOrderTemplate.Direction> DIRECTION_ID_MAP = ImmutableMap.builder().put((Object)"ascending", (Object)PlayerOrderTemplate.Direction.ASCENDING).put((Object)"asc", (Object)PlayerOrderTemplate.Direction.ASCENDING).put((Object)"descending", (Object)PlayerOrderTemplate.Direction.DESCENDING).put((Object)"desc", (Object)PlayerOrderTemplate.Direction.DESCENDING).put((Object)"viewer-first", (Object)PlayerOrderTemplate.Direction.VIEWER_FIRST).put((Object)"custom-order", (Object)PlayerOrderTemplate.Direction.CUSTOM).put((Object)"custom", (Object)PlayerOrderTemplate.Direction.CUSTOM).build();
    private static final Map<String, PlayerOrderTemplate.Type> TYPE_ID_MAP = ImmutableMap.builder().put((Object)"number", (Object)PlayerOrderTemplate.Type.NUMBER).put((Object)"text", (Object)PlayerOrderTemplate.Type.TEXT).put((Object)"string", (Object)PlayerOrderTemplate.Type.TEXT).build();
    private final String order;

    public PlayerOrderTemplate toTemplate(TemplateCreationContext tcc) {
        SortingRulePreprocessor preprocessor = tcc.getSortingRulePreprocessor();
        ArrayList<PlayerOrderTemplate.Entry> chain = new ArrayList<PlayerOrderTemplate.Entry>();
        if (this.order != null) {
            String[] elements;
            for (String element : elements = this.order.split(",")) {
                DataHolderPlaceholderDataProviderSupplier dataHolderPlaceholder;
                ArrayList<PlaceholderArg> args;
                block27: {
                    String[] tokens;
                    if (preprocessor != null) {
                        element = preprocessor.process(element, tcc.getErrorHandler(), this.getStartMark());
                    }
                    if ((tokens = element.trim().split(" ")).length == 0) {
                        tcc.getErrorHandler().addWarning("Player Order contains empty entry. Too many `,`'s?", this.getStartMark());
                        continue;
                    }
                    args = new ArrayList<PlaceholderArg>();
                    for (String token : tokens) {
                        args.add(new PlaceholderArg.Text(token));
                    }
                    try {
                        if (args.size() >= 2 && ((PlaceholderArg)args.get(0)).getText().equals("server") && ("as".equals(((PlaceholderArg)args.get(1)).getText()) || DIRECTION_ID_MAP.containsKey(((PlaceholderArg)args.get(1)).getText()))) {
                            PlaceholderArg arg = (PlaceholderArg)args.remove(0);
                            try {
                                PlaceholderBuilder<Void, Void> builderPlayer = tcc.getPlayerPlaceholderResolver().resolve(PlaceholderBuilder.create().transformContext(Context::getPlayer), new ArrayList<PlaceholderArg>(Collections.singletonList(arg)), tcc);
                                Object dataProviderFactory = Unchecked.cast(builderPlayer.getDataProviderFactory());
                                dataHolderPlaceholder = (DataHolderPlaceholderDataProviderSupplier)Unchecked.cast(dataProviderFactory);
                                break block27;
                            }
                            catch (PlaceholderException | UnknownPlaceholderException ex) {
                                throw new AssertionError();
                            }
                        }
                        PlaceholderBuilder<Void, Void> builderPlayer = tcc.getPlayerPlaceholderResolver().resolve(PlaceholderBuilder.create().transformContext(Context::getPlayer), args, tcc);
                        Object dataProviderFactory = Unchecked.cast(builderPlayer.getDataProviderFactory());
                        if (dataProviderFactory instanceof DataHolderPlaceholderDataProviderSupplier) {
                            dataHolderPlaceholder = (DataHolderPlaceholderDataProviderSupplier)Unchecked.cast(dataProviderFactory);
                            break block27;
                        }
                        tcc.getErrorHandler().addWarning("Unsuitable placeholder in playerOrder option: `" + Joiner.on((char)' ').join(Arrays.asList(tokens).subList(0, tokens.length - args.size())) + "`. This placeholder cannot be used for sorting.", this.getStartMark());
                    }
                    catch (UnknownPlaceholderException e) {
                        tcc.getErrorHandler().addWarning("Unknown placeholder in playerOrder option: `" + Joiner.on((char)' ').join(Arrays.asList(tokens)) + "`", this.getStartMark());
                    }
                    catch (PlaceholderException e) {
                        String message = "Error in placeholder in playerOrder option: `" + Joiner.on((char)' ').join(Arrays.asList(tokens)) + "`:\n" + e.getMessage();
                        if (e.getCause() != null) {
                            message = message + "\nCaused by: " + e.getCause().getMessage();
                        }
                        tcc.getErrorHandler().addWarning(message, this.getStartMark());
                    }
                    continue;
                }
                PlayerOrderTemplate.Direction direction = null;
                PlayerOrderTemplate.Type type = null;
                ArrayList<String> customOrder = null;
                for (int i = 0; i < args.size(); ++i) {
                    PlaceholderArg arg = (PlaceholderArg)args.get(i);
                    String token = arg.getText();
                    if (DIRECTION_ID_MAP.containsKey(token)) {
                        if (direction != null) {
                            tcc.getErrorHandler().addWarning("In playerOrder: Ignoring option `" + token + "` for `" + element + "` because direction has already been set.", this.getStartMark());
                            continue;
                        }
                        direction = DIRECTION_ID_MAP.get(token);
                        if (direction != PlayerOrderTemplate.Direction.CUSTOM) continue;
                        customOrder = new ArrayList<String>();
                        while (i + 1 < args.size() && !"as".equals(((PlaceholderArg)args.get(i + 1)).getText()) && !DIRECTION_ID_MAP.containsKey(((PlaceholderArg)args.get(i + 1)).getText())) {
                            customOrder.add(((PlaceholderArg)args.get(++i)).getText());
                        }
                        continue;
                    }
                    if (token.equals("as")) {
                        if (++i == args.size()) {
                            tcc.getErrorHandler().addWarning("In playerOrder: In `" + element + "` the `as` needs to be followed by `text` or `number`.", this.getStartMark());
                            continue;
                        }
                        arg = (PlaceholderArg)args.get(i);
                        token = arg.getText();
                        if (!TYPE_ID_MAP.containsKey(token)) {
                            tcc.getErrorHandler().addWarning("In playerOrder: After `" + element + "` encountered unknown type: `as " + token + "`. Try using `as text` or `as number` instead.", this.getStartMark());
                            continue;
                        }
                        if (type != null) {
                            tcc.getErrorHandler().addWarning("In playerOrder: Ignoring option `as " + token + "` for `" + element + "` because type has already been set.", this.getStartMark());
                            continue;
                        }
                        type = TYPE_ID_MAP.get(token);
                        continue;
                    }
                    tcc.getErrorHandler().addWarning("In playerOrder: Ignoring option `" + token + "` for `" + element + "`. Unknown option.", this.getStartMark());
                }
                if (type == null) {
                    TypeToken placeholderType = dataHolderPlaceholder.getType();
                    if (STRING_TYPES.contains(placeholderType)) {
                        type = PlayerOrderTemplate.Type.TEXT;
                    }
                    if (NUMERIC_TYPES.contains(placeholderType)) {
                        type = PlayerOrderTemplate.Type.NUMBER;
                    }
                }
                if (type == null) {
                    tcc.getErrorHandler().addWarning("In playerOrder: Missing type for `" + element + "`. Try `" + element + " as text` or `" + element + " as number` instead.", this.getStartMark());
                    continue;
                }
                if (direction == null && type == PlayerOrderTemplate.Type.TEXT) {
                    direction = PlayerOrderTemplate.Direction.ASCENDING;
                }
                if (direction == null) {
                    tcc.getErrorHandler().addWarning("In playerOrder: Missing direction for `" + element + "`. Try `" + element + " asc` or `" + element + " desc` instead.", this.getStartMark());
                    continue;
                }
                chain.add(new PlayerOrderTemplate.Entry(dataHolderPlaceholder, direction, type, customOrder));
            }
        }
        return new PlayerOrderTemplate(Collections.unmodifiableList(chain));
    }

    public PlayerOrderConfiguration(String order) {
        this.order = order;
    }
}

