/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl;

import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedPropertyBase;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.placeholder.PlayerPlaceholderResolver;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.ping.ConstantPingTemplate;
import de.codecrafter47.taboverlay.config.template.ping.ExpressionPingTemplate;
import de.codecrafter47.taboverlay.config.template.ping.PingTemplate;
import de.codecrafter47.taboverlay.config.template.ping.PlayerPingTemplate;

public class PingTemplateConfiguration
extends MarkedPropertyBase {
    public static final PingTemplateConfiguration DEFAULT = new PingTemplateConfiguration(TemplateCreationContext::getDefaultPing);
    public static final PingTemplateConfiguration ZERO = new PingTemplateConfiguration(tcc -> PingTemplate.ZERO);
    private final TemplateConstructor templateConstructor;

    private PingTemplateConfiguration(TemplateConstructor templateConstructor) {
        this.templateConstructor = templateConstructor;
    }

    public PingTemplateConfiguration(String value) {
        this.templateConstructor = tcc -> this.create(value, tcc);
    }

    private PingTemplate create(String value, TemplateCreationContext tcc) {
        if (value.equals("${player ping}")) {
            if (!tcc.isPlayerAvailable()) {
                tcc.getErrorHandler().addWarning("${player ping} cannot be used here", this.getStartMark());
                return tcc.getDefaultPing();
            }
            return new PlayerPingTemplate(PlayerPlaceholderResolver.BindPoint.PLAYER, tcc.getPlayerPingDataKey());
        }
        if (value.equals("${viewer ping}")) {
            if (!tcc.isViewerAvailable()) {
                tcc.getErrorHandler().addWarning("${viewer ping} cannot be used here", this.getStartMark());
                return tcc.getDefaultPing();
            }
            return new PlayerPingTemplate(PlayerPlaceholderResolver.BindPoint.VIEWER, tcc.getPlayerPingDataKey());
        }
        try {
            int ping = Integer.parseInt(value);
            return new ConstantPingTemplate(ping);
        }
        catch (NumberFormatException e) {
            ExpressionTemplate expression = tcc.getExpressionEngine().compile(tcc, value, this.getStartMark());
            return new ExpressionPingTemplate(expression);
        }
    }

    public PingTemplate toTemplate(TemplateCreationContext tcc) {
        return this.templateConstructor.apply(tcc);
    }

    @FunctionalInterface
    private static interface TemplateConstructor {
        public PingTemplate apply(TemplateCreationContext var1);
    }
}

