/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl;

import de.codecrafter47.taboverlay.config.dsl.AbstractTabOverlayTemplateConfiguration;
import de.codecrafter47.taboverlay.config.dsl.ComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.PlayerOrderConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.placeholder.PlayerPlaceholderResolver;
import de.codecrafter47.taboverlay.config.template.DynamicSizeTabOverlayTemplate;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.icon.PlayerIconTemplate;
import de.codecrafter47.taboverlay.config.template.ping.PlayerPingTemplate;

public class DynamicSizeTabOverlayTemplateConfiguration
extends AbstractTabOverlayTemplateConfiguration<DynamicSizeTabOverlayTemplate> {
    private PlayerOrderConfiguration playerOrder = PlayerOrderConfiguration.DEFAULT;
    private MarkedStringProperty playerSet;
    private ComponentConfiguration playerComponent;

    @Override
    protected DynamicSizeTabOverlayTemplate createTemplate() {
        return new DynamicSizeTabOverlayTemplate();
    }

    @Override
    protected void populateTemplate(DynamicSizeTabOverlayTemplate template, TemplateCreationContext tcc) {
        super.populateTemplate(template, tcc);
        if (ConfigValidationUtil.checkNotNull(tcc, "DYNAMIC_SIZE tab overlay", "playerSet", this.playerSet, null)) {
            if (!tcc.getPlayerSets().containsKey(this.playerSet.getValue())) {
                tcc.getErrorHandler().addError("No player set definition available for player set \"" + this.playerSet.getValue() + "\"", this.playerSet.getStartMark());
            } else {
                template.setPlayerSet(tcc.getPlayerSets().get(this.playerSet.getValue()));
            }
        }
        if (ConfigValidationUtil.checkNotNull(tcc, "DYNAMIC_SIZE tab overlay", "playerOrder", this.playerOrder, null)) {
            template.setPlayerOrder(this.playerOrder.toTemplate(tcc));
        }
        if (ConfigValidationUtil.checkNotNull(tcc, "DYNAMIC_SIZE tab overlay", "playerComponent", this.playerComponent, null)) {
            TemplateCreationContext childContext = tcc.clone();
            childContext.setDefaultIcon(new PlayerIconTemplate(PlayerPlaceholderResolver.BindPoint.PLAYER, tcc.getPlayerIconDataKey()));
            childContext.setDefaultPing(new PlayerPingTemplate(PlayerPlaceholderResolver.BindPoint.PLAYER, tcc.getPlayerPingDataKey()));
            childContext.setPlayerAvailable(true);
            template.setPlayerComponent(this.playerComponent.toTemplate(childContext));
        }
        template.setMorePlayersComponent(tcc.emptyComponent());
    }

    public PlayerOrderConfiguration getPlayerOrder() {
        return this.playerOrder;
    }

    public MarkedStringProperty getPlayerSet() {
        return this.playerSet;
    }

    public ComponentConfiguration getPlayerComponent() {
        return this.playerComponent;
    }

    public void setPlayerOrder(PlayerOrderConfiguration playerOrder) {
        this.playerOrder = playerOrder;
    }

    public void setPlayerSet(MarkedStringProperty playerSet) {
        this.playerSet = playerSet;
    }

    public void setPlayerComponent(ComponentConfiguration playerComponent) {
        this.playerComponent = playerComponent;
    }
}

