/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.dsl;

import com.google.common.collect.ImmutableList;
import de.codecrafter47.taboverlay.config.ErrorHandler;
import de.codecrafter47.taboverlay.config.dsl.PlayerSetConfiguration;
import de.codecrafter47.taboverlay.config.dsl.TextTemplateConfiguration;
import de.codecrafter47.taboverlay.config.dsl.TextTemplateConfigurationList;
import de.codecrafter47.taboverlay.config.dsl.components.BasicComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedFloatProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedIntegerProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedPropertyBase;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.placeholder.CustomPlaceholderResolver;
import de.codecrafter47.taboverlay.config.template.AbstractTabOverlayTemplate;
import de.codecrafter47.taboverlay.config.template.PlayerSetTemplate;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractTabOverlayTemplateConfiguration<T extends AbstractTabOverlayTemplate>
extends MarkedPropertyBase {
    private transient Path path;
    private transient ErrorHandler errorHandler;
    private MarkedStringProperty showTo = new MarkedStringProperty("all");
    private MarkedIntegerProperty priority = new MarkedIntegerProperty(0);
    private boolean showHeaderFooter = false;
    private TextTemplateConfigurationList<TextTemplateConfiguration> header;
    private MarkedFloatProperty headerAnimationUpdateInterval = new MarkedFloatProperty(1.0f);
    private TextTemplateConfigurationList<TextTemplateConfiguration> footer;
    private MarkedFloatProperty footerAnimationUpdateInterval = new MarkedFloatProperty(1.0f);
    private PlayerSetConfiguration.Visibility hiddenPlayers = PlayerSetConfiguration.Visibility.VISIBLE_TO_ADMINS;
    private Map<MarkedStringProperty, CustomPlaceholderConfiguration> customPlaceholders = new HashMap<MarkedStringProperty, CustomPlaceholderConfiguration>();
    private Map<MarkedStringProperty, PlayerSetConfiguration> playerSets = new HashMap<MarkedStringProperty, PlayerSetConfiguration>();
    private BasicComponentConfiguration.LongTextBehaviour longText = BasicComponentConfiguration.LongTextBehaviour.DISPLAY_ALL;

    public T toTemplate(TemplateCreationContext tcc) {
        T template = this.createTemplate();
        this.populateTemplate(template, tcc);
        return template;
    }

    protected abstract T createTemplate();

    protected void populateTemplate(T template, TemplateCreationContext tcc) {
        if (ConfigValidationUtil.checkNotNull(tcc, "tab overlay", "hiddenPlayers", (Object)this.hiddenPlayers, null)) {
            tcc.setDefaultHiddenPlayerVisibility(this.hiddenPlayers);
        }
        HashMap<String, PlayerSetTemplate> playerSetTemplates = new HashMap<String, PlayerSetTemplate>();
        if (this.playerSets != null) {
            for (Map.Entry<MarkedStringProperty, PlayerSetConfiguration> entry : this.playerSets.entrySet()) {
                if (entry.getKey() != null && entry.getKey().getValue() != null && entry.getValue() != null) {
                    playerSetTemplates.put(entry.getKey().getValue(), entry.getValue().toTemplate(tcc));
                    continue;
                }
                if (entry.getKey() == null) {
                    tcc.getErrorHandler().addWarning("Player set with missing name", entry.getValue() != null ? entry.getValue().getStartMark() : null);
                    continue;
                }
                if (entry.getKey().getValue() == null) {
                    tcc.getErrorHandler().addWarning("Player set with missing name", entry.getKey().getStartMark());
                    continue;
                }
                if (entry.getValue() != null) continue;
                tcc.getErrorHandler().addWarning("Incomplete player set definition", entry.getKey().getStartMark());
            }
        }
        ((AbstractTabOverlayTemplate)template).setPlayerSets(playerSetTemplates);
        tcc.setPlayerSets(playerSetTemplates);
        if (this.customPlaceholders != null) {
            for (Map.Entry<MarkedStringProperty, MarkedPropertyBase> entry : this.customPlaceholders.entrySet()) {
                if (entry.getKey() != null && entry.getKey().getValue() != null && entry.getValue() != null) {
                    tcc.getCustomPlaceholders().put(entry.getKey().getValue(), (CustomPlaceholderConfiguration)entry.getValue());
                    continue;
                }
                if (entry.getKey() == null) {
                    tcc.getErrorHandler().addWarning("Custom placeholder definition with missing name", entry.getValue() != null ? ((CustomPlaceholderConfiguration)entry.getValue()).getStartMark() : null);
                    continue;
                }
                if (entry.getKey().getValue() == null) {
                    tcc.getErrorHandler().addWarning("Custom placeholder definition with missing name", entry.getKey().getStartMark());
                    continue;
                }
                if (entry.getValue() != null) continue;
                tcc.getErrorHandler().addWarning("Incomplete custom placeholder definition", entry.getKey().getStartMark());
            }
            tcc.addPlaceholderResolver(new CustomPlaceholderResolver(tcc.getCustomPlaceholders()));
        }
        if (ConfigValidationUtil.checkNotNull(tcc, "tab overlay", "showTo", this.showTo, null)) {
            try {
                ((AbstractTabOverlayTemplate)template).setViewerPredicate(tcc.getExpressionEngine().compile(tcc, this.showTo.getValue(), this.showTo.getStartMark()));
            }
            catch (Throwable th) {
                tcc.getErrorHandler().addError("Invalid Expression. " + th.toString(), this.showTo.getStartMark());
            }
        }
        if (ConfigValidationUtil.checkNotNull(tcc, "tab overlay", "priority", this.priority, null)) {
            if (this.priority.getValue() > 10000) {
                tcc.getErrorHandler().addError("Priority must not be larger than 10000.", this.priority.getStartMark());
            }
            if (this.priority.getValue() < -10000) {
                tcc.getErrorHandler().addError("Priority must not be smaller than -10000.", this.priority.getStartMark());
            }
            ((AbstractTabOverlayTemplate)template).setPriority(this.priority.getValue());
        }
        if (this.showHeaderFooter) {
            TextTemplateConfiguration t;
            if (this.header == null || this.header.isEmpty()) {
                ((AbstractTabOverlayTemplate)template).setHeader(Collections.singletonList(TextTemplate.EMPTY));
            } else if (this.header.size() == 1) {
                t = (TextTemplateConfiguration)this.header.get(0);
                ((AbstractTabOverlayTemplate)template).setHeader(Collections.singletonList(null != t ? t.toTemplate(tcc) : TextTemplate.EMPTY));
            } else {
                ImmutableList.Builder headerTemplates = ImmutableList.builder();
                for (TextTemplateConfiguration textConfiguration : this.header) {
                    if (textConfiguration != null) {
                        headerTemplates.add((Object)textConfiguration.toTemplate(tcc));
                        continue;
                    }
                    headerTemplates.add((Object)TextTemplate.EMPTY);
                }
                ((AbstractTabOverlayTemplate)template).setHeader((List<TextTemplate>)headerTemplates.build());
                if (ConfigValidationUtil.checkNotNull(tcc, "tab overlay", "headerAnimationUpdateInterval", this.headerAnimationUpdateInterval, null) && ConfigValidationUtil.checkRange(tcc, "tab overlay", "headerAnimationUpdateInterval", this.headerAnimationUpdateInterval.getValue(), 0.01f, 9999.0f, this.headerAnimationUpdateInterval.getStartMark())) {
                    ((AbstractTabOverlayTemplate)template).setHeaderAnimationUpdateInterval(this.headerAnimationUpdateInterval.getValue());
                }
            }
            if (this.footer == null || this.footer.isEmpty()) {
                ((AbstractTabOverlayTemplate)template).setFooter(Collections.singletonList(TextTemplate.EMPTY));
            } else if (this.footer.size() == 1) {
                t = (TextTemplateConfiguration)this.footer.get(0);
                ((AbstractTabOverlayTemplate)template).setFooter(Collections.singletonList(null != t ? t.toTemplate(tcc) : TextTemplate.EMPTY));
            } else {
                ImmutableList.Builder footerTemplates = ImmutableList.builder();
                for (TextTemplateConfiguration textConfiguration : this.footer) {
                    if (textConfiguration != null) {
                        footerTemplates.add((Object)textConfiguration.toTemplate(tcc));
                        continue;
                    }
                    footerTemplates.add((Object)TextTemplate.EMPTY);
                }
                ((AbstractTabOverlayTemplate)template).setFooter((List<TextTemplate>)footerTemplates.build());
                if (ConfigValidationUtil.checkNotNull(tcc, "tab overlay", "footerAnimationUpdateInterval", this.footerAnimationUpdateInterval, null) && ConfigValidationUtil.checkRange(tcc, "tab overlay", "footerAnimationUpdateInterval", this.footerAnimationUpdateInterval.getValue(), 0.01f, 9999.0f, this.footerAnimationUpdateInterval.getStartMark())) {
                    ((AbstractTabOverlayTemplate)template).setFooterAnimationUpdateInterval(this.footerAnimationUpdateInterval.getValue());
                }
            }
        }
        tcc.setDefaultLongTextBehaviour(this.longText);
    }

    public Path getPath() {
        return this.path;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public MarkedStringProperty getShowTo() {
        return this.showTo;
    }

    public MarkedIntegerProperty getPriority() {
        return this.priority;
    }

    public boolean isShowHeaderFooter() {
        return this.showHeaderFooter;
    }

    public TextTemplateConfigurationList<TextTemplateConfiguration> getHeader() {
        return this.header;
    }

    public MarkedFloatProperty getHeaderAnimationUpdateInterval() {
        return this.headerAnimationUpdateInterval;
    }

    public TextTemplateConfigurationList<TextTemplateConfiguration> getFooter() {
        return this.footer;
    }

    public MarkedFloatProperty getFooterAnimationUpdateInterval() {
        return this.footerAnimationUpdateInterval;
    }

    public PlayerSetConfiguration.Visibility getHiddenPlayers() {
        return this.hiddenPlayers;
    }

    public Map<MarkedStringProperty, CustomPlaceholderConfiguration> getCustomPlaceholders() {
        return this.customPlaceholders;
    }

    public Map<MarkedStringProperty, PlayerSetConfiguration> getPlayerSets() {
        return this.playerSets;
    }

    public BasicComponentConfiguration.LongTextBehaviour getLongText() {
        return this.longText;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setShowTo(MarkedStringProperty showTo) {
        this.showTo = showTo;
    }

    public void setPriority(MarkedIntegerProperty priority) {
        this.priority = priority;
    }

    public void setShowHeaderFooter(boolean showHeaderFooter) {
        this.showHeaderFooter = showHeaderFooter;
    }

    public void setHeader(TextTemplateConfigurationList<TextTemplateConfiguration> header) {
        this.header = header;
    }

    public void setHeaderAnimationUpdateInterval(MarkedFloatProperty headerAnimationUpdateInterval) {
        this.headerAnimationUpdateInterval = headerAnimationUpdateInterval;
    }

    public void setFooter(TextTemplateConfigurationList<TextTemplateConfiguration> footer) {
        this.footer = footer;
    }

    public void setFooterAnimationUpdateInterval(MarkedFloatProperty footerAnimationUpdateInterval) {
        this.footerAnimationUpdateInterval = footerAnimationUpdateInterval;
    }

    public void setHiddenPlayers(PlayerSetConfiguration.Visibility hiddenPlayers) {
        this.hiddenPlayers = hiddenPlayers;
    }

    public void setCustomPlaceholders(Map<MarkedStringProperty, CustomPlaceholderConfiguration> customPlaceholders) {
        this.customPlaceholders = customPlaceholders;
    }

    public void setPlayerSets(Map<MarkedStringProperty, PlayerSetConfiguration> playerSets) {
        this.playerSets = playerSets;
    }

    public void setLongText(BasicComponentConfiguration.LongTextBehaviour longText) {
        this.longText = longText;
    }
}

