/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.context;

import de.codecrafter47.taboverlay.config.context.ContextKey;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.player.PlayerSetFactory;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

public final class Context
implements Cloneable {
    private Object[] customObjects;
    private Player viewer;
    private Player player;
    private ScheduledExecutorService tabEventQueue;
    private PlayerSetFactory playerSetFactory;

    public static Context from(Player viewer, ScheduledExecutorService eventQueue) {
        Context context = new Context();
        context.setViewer(viewer);
        context.setTabEventQueue(eventQueue);
        return context;
    }

    @Nullable
    public <T> T getCustomObject(ContextKey<T> key) {
        if (this.customObjects != null) {
            for (int i = 0; i < this.customObjects.length; i += 2) {
                if (!key.equals(this.customObjects[i])) continue;
                return (T)this.customObjects[i + 1];
            }
        }
        return null;
    }

    public <T> void setCustomObject(ContextKey<T> key, T value) {
        if (this.customObjects == null) {
            this.customObjects = new Object[]{key, value};
        } else {
            for (int i = 0; i < this.customObjects.length; i += 2) {
                if (!key.equals(this.customObjects[i])) continue;
                this.customObjects = (Object[])this.customObjects.clone();
                this.customObjects[i + 1] = value;
                return;
            }
            Object[] old = this.customObjects;
            this.customObjects = new Object[old.length + 2];
            System.arraycopy(old, 0, this.customObjects, 0, old.length);
            this.customObjects[old.length] = key;
            this.customObjects[old.length + 1] = value;
        }
    }

    public Context clone() {
        return (Context)super.clone();
    }

    Context() {
    }

    public Player getViewer() {
        return this.viewer;
    }

    public void setViewer(Player viewer) {
        this.viewer = viewer;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public ScheduledExecutorService getTabEventQueue() {
        return this.tabEventQueue;
    }

    public void setTabEventQueue(ScheduledExecutorService tabEventQueue) {
        this.tabEventQueue = tabEventQueue;
    }

    public PlayerSetFactory getPlayerSetFactory() {
        return this.playerSetFactory;
    }

    public void setPlayerSetFactory(PlayerSetFactory playerSetFactory) {
        this.playerSetFactory = playerSetFactory;
    }
}

