/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.area;

import com.google.common.base.Preconditions;
import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.config.area.RectangularArea;
import java.util.UUID;

public class RectangularAreaWithOffset
implements RectangularArea {
    private final RectangularArea delegate;
    private final int offsetColumns;
    private final int offsetRows;
    private final int sizeColumns;
    private final int sizeRows;
    private final int size;

    public RectangularAreaWithOffset(RectangularArea delegate, int offsetColumns, int offsetRows, int sizeColumns, int sizeRows) {
        this.delegate = delegate;
        this.offsetColumns = offsetColumns;
        this.offsetRows = offsetRows;
        this.sizeColumns = sizeColumns;
        this.sizeRows = sizeRows;
        this.size = sizeColumns * sizeRows;
    }

    @Override
    public void setSlot(int column, int row, UUID uuid, Icon icon, String text, int ping) {
        if (column >= this.sizeColumns || row >= this.sizeRows) {
            throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=" + this.getColumns() + ", rows=" + this.getRows() + ").");
        }
        this.delegate.setSlot(column + this.offsetColumns, row + this.offsetRows, uuid, icon, text, ping);
    }

    @Override
    public void setUuid(int column, int row, UUID uuid) {
        if (column >= this.sizeColumns || row >= this.sizeRows) {
            throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=" + this.getColumns() + ", rows=" + this.getRows() + ").");
        }
        this.delegate.setUuid(column + this.offsetColumns, row + this.offsetRows, uuid);
    }

    @Override
    public void setIcon(int column, int row, Icon icon) {
        if (column >= this.sizeColumns || row >= this.sizeRows) {
            throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=" + this.getColumns() + ", rows=" + this.getRows() + ").");
        }
        this.delegate.setIcon(column + this.offsetColumns, row + this.offsetRows, icon);
    }

    @Override
    public void setText(int column, int row, String text) {
        if (column >= this.sizeColumns || row >= this.sizeRows) {
            throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=" + this.getColumns() + ", rows=" + this.getRows() + ").");
        }
        this.delegate.setText(column + this.offsetColumns, row + this.offsetRows, text);
    }

    @Override
    public void setPing(int column, int row, int ping) {
        if (column >= this.sizeColumns || row >= this.sizeRows) {
            throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=" + this.getColumns() + ", rows=" + this.getRows() + ").");
        }
        this.delegate.setPing(column + this.offsetColumns, row + this.offsetRows, ping);
    }

    @Override
    public int getRows() {
        return this.sizeRows;
    }

    @Override
    public int getColumns() {
        return this.sizeColumns;
    }

    @Override
    public RectangularArea createRectangularChild(int column, int row, int columns, int rows) {
        Preconditions.checkArgument((column <= this.sizeColumns ? 1 : 0) != 0, (Object)"column <= sizeColumns");
        Preconditions.checkArgument((row <= this.sizeRows ? 1 : 0) != 0, (Object)"row <= sizeRows");
        Preconditions.checkArgument((column + columns <= this.sizeColumns ? 1 : 0) != 0, (Object)"column + columns <= sizeColumns");
        Preconditions.checkArgument((row + rows <= this.sizeRows ? 1 : 0) != 0, (Object)"row + rows <= sizeRows");
        return new RectangularAreaWithOffset(this.delegate, this.offsetColumns + column, this.offsetRows + row, columns, rows);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getSlotWidth() {
        return this.delegate.getSlotWidth();
    }
}

