/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.area;

import com.google.common.base.Preconditions;
import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.config.area.Area;
import de.codecrafter47.taboverlay.config.area.RectangularAreaWithOffset;
import de.codecrafter47.taboverlay.handler.RectangularTabOverlay;
import de.codecrafter47.taboverlay.handler.SimpleTabOverlay;
import java.util.UUID;

public interface RectangularArea
extends Area {
    @Override
    default public void setSlot(int index, UUID uuid, Icon icon, String text, int ping) {
        this.setSlot(index % this.getColumns(), index / this.getColumns(), uuid, icon, text, ping);
    }

    @Override
    default public void setSlot(int index, Icon icon, String text, int ping) {
        this.setSlot(index % this.getColumns(), index / this.getColumns(), icon, text, ping);
    }

    @Override
    default public void setUuid(int index, UUID uuid) {
        this.setUuid(index % this.getColumns(), index / this.getColumns(), uuid);
    }

    @Override
    default public void setIcon(int index, Icon icon) {
        this.setIcon(index % this.getColumns(), index / this.getColumns(), icon);
    }

    @Override
    default public void setText(int index, String text) {
        this.setText(index % this.getColumns(), index / this.getColumns(), text);
    }

    @Override
    default public void setPing(int index, int ping) {
        this.setPing(index % this.getColumns(), index / this.getColumns(), ping);
    }

    default public void setSlot(int column, int row, Icon icon, String text, int ping) {
        this.setSlot(column, row, null, icon, text, ping);
    }

    public void setSlot(int var1, int var2, UUID var3, Icon var4, String var5, int var6);

    public void setUuid(int var1, int var2, UUID var3);

    public void setIcon(int var1, int var2, Icon var3);

    public void setText(int var1, int var2, String var3);

    public void setPing(int var1, int var2, int var3);

    public int getRows();

    public int getColumns();

    default public RectangularArea createRectangularChild(int column, int row, int columns, int rows) {
        Preconditions.checkArgument((column < this.getColumns() ? 1 : 0) != 0, (Object)"column <= getColumns()");
        Preconditions.checkArgument((row < this.getRows() ? 1 : 0) != 0, (Object)"row <= getRows()");
        Preconditions.checkArgument((column + columns <= this.getColumns() ? 1 : 0) != 0, (Object)"column + columns <= getColumns()");
        Preconditions.checkArgument((row + rows <= this.getRows() ? 1 : 0) != 0, (Object)"row + rows <= getRows()");
        return new RectangularAreaWithOffset(this, column, row, columns, rows);
    }

    @Override
    default public RectangularArea asRectangularArea() {
        return this;
    }

    public static RectangularArea of(final RectangularTabOverlay tabOverlay) {
        final int columns = tabOverlay.getSize().getColumns();
        final int rows = tabOverlay.getSize().getRows();
        final int size = columns * rows;
        int slotWidth = 80;
        switch (columns) {
            case 1: {
                slotWidth = 360;
                break;
            }
            case 2: {
                slotWidth = 180;
                break;
            }
            case 3: {
                slotWidth = 110;
            }
        }
        final int finalSlotWidth = slotWidth;
        return new RectangularArea(){

            @Override
            public void setSlot(int column, int row, UUID uuid, Icon icon, String text, int ping) {
                tabOverlay.setSlot(column, row, uuid, icon, text, ping);
            }

            @Override
            public void setUuid(int column, int row, UUID uuid) {
                tabOverlay.setUuid(column, row, uuid);
            }

            @Override
            public void setIcon(int column, int row, Icon icon) {
                tabOverlay.setIcon(column, row, icon);
            }

            @Override
            public void setText(int column, int row, String text) {
                tabOverlay.setText(column, row, text);
            }

            @Override
            public void setPing(int column, int row, int ping) {
                tabOverlay.setPing(column, row, ping);
            }

            @Override
            public int getRows() {
                return rows;
            }

            @Override
            public int getColumns() {
                return columns;
            }

            @Override
            public int getSize() {
                return size;
            }

            @Override
            public int getSlotWidth() {
                return finalSlotWidth;
            }
        };
    }

    public static Area of(final SimpleTabOverlay tabOverlay) {
        int size = tabOverlay.getSize();
        int slotWidth = 80;
        if (size <= 20) {
            slotWidth = 360;
        } else if (size <= 40) {
            slotWidth = 180;
        } else if (size <= 60) {
            slotWidth = 110;
        }
        final int finalSlotWidth = slotWidth;
        return new RectangularArea(){

            @Override
            public void setSlot(int index, UUID uuid, Icon icon, String text, int ping) {
                tabOverlay.setSlot(index, uuid, icon, text, ping);
            }

            @Override
            public void setSlot(int index, Icon icon, String text, int ping) {
                tabOverlay.setSlot(index, icon, text, ping);
            }

            @Override
            public void setUuid(int index, UUID uuid) {
                tabOverlay.setUuid(index, uuid);
            }

            @Override
            public void setIcon(int index, Icon icon) {
                tabOverlay.setIcon(index, icon);
            }

            @Override
            public void setText(int index, String text) {
                tabOverlay.setText(index, text);
            }

            @Override
            public void setPing(int index, int ping) {
                tabOverlay.setPing(index, ping);
            }

            @Override
            public void setSlot(int column, int row, UUID uuid, Icon icon, String text, int ping) {
                if (column != 0) {
                    throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=1, rows=" + this.getRows() + ").");
                }
                tabOverlay.setSlot(row, uuid, icon, text, ping);
            }

            @Override
            public void setSlot(int column, int row, Icon icon, String text, int ping) {
                if (column != 0) {
                    throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=1, rows=" + this.getRows() + ").");
                }
                tabOverlay.setSlot(row, icon, text, ping);
            }

            @Override
            public void setUuid(int column, int row, UUID uuid) {
                if (column != 0) {
                    throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=1, rows=" + this.getRows() + ").");
                }
                tabOverlay.setUuid(row, uuid);
            }

            @Override
            public void setIcon(int column, int row, Icon icon) {
                if (column != 0) {
                    throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=1, rows=" + this.getRows() + ").");
                }
                tabOverlay.setIcon(row, icon);
            }

            @Override
            public void setText(int column, int row, String text) {
                if (column != 0) {
                    throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=1, rows=" + this.getRows() + ").");
                }
                tabOverlay.setText(row, text);
            }

            @Override
            public void setPing(int column, int row, int ping) {
                if (column != 0) {
                    throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=1, rows=" + this.getRows() + ").");
                }
                tabOverlay.setPing(row, ping);
            }

            @Override
            public int getRows() {
                return tabOverlay.getSize();
            }

            @Override
            public int getColumns() {
                return 1;
            }

            @Override
            public int getSize() {
                return tabOverlay.getSize();
            }

            @Override
            public int getSlotWidth() {
                return finalSlotWidth;
            }

            @Override
            public RectangularArea asRectangularArea() {
                return this;
            }
        };
    }
}

