/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config.area;

import com.google.common.base.Preconditions;
import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.config.area.Area;
import de.codecrafter47.taboverlay.config.area.RectangularArea;
import java.util.UUID;

public class AreaWithOffset
implements Area {
    private final Area delegate;
    private final int offset;
    private final int size;
    private RectangularArea rectangularArea;

    public AreaWithOffset(Area delegate, int offset, int size) {
        this.delegate = delegate;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public void setSlot(int index, UUID uuid, Icon icon, String text, int ping) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds(size=" + this.size + ").");
        }
        this.delegate.setSlot(index + this.offset, uuid, icon, text, ping);
    }

    @Override
    public void setUuid(int index, UUID uuid) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds(size=" + this.size + ").");
        }
        this.delegate.setUuid(index + this.offset, uuid);
    }

    @Override
    public void setIcon(int index, Icon icon) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds(size=" + this.size + ").");
        }
        this.delegate.setIcon(index + this.offset, icon);
    }

    @Override
    public void setText(int index, String text) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds(size=" + this.size + ").");
        }
        this.delegate.setText(index + this.offset, text);
    }

    @Override
    public void setPing(int index, int ping) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds(size=" + this.size + ").");
        }
        this.delegate.setPing(index + this.offset, ping);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getSlotWidth() {
        return this.delegate.getSlotWidth();
    }

    @Override
    public Area createChild(int firstIndex, int size) {
        Preconditions.checkArgument((firstIndex <= this.size ? 1 : 0) != 0, (Object)"firstIndex <= this.size");
        Preconditions.checkArgument((firstIndex + size <= this.size ? 1 : 0) != 0, (Object)"firstIndex + size <= this.size");
        return new AreaWithOffset(this.delegate, this.offset + firstIndex, size);
    }

    @Override
    public RectangularArea asRectangularArea() {
        if (this.rectangularArea == null) {
            this.rectangularArea = new RectangularView();
        }
        return this.rectangularArea;
    }

    private class RectangularView
    implements RectangularArea {
        private RectangularView() {
        }

        @Override
        public void setSlot(int index, UUID uuid, Icon icon, String text, int ping) {
            AreaWithOffset.this.setSlot(index, uuid, icon, text, ping);
        }

        @Override
        public void setSlot(int index, Icon icon, String text, int ping) {
            AreaWithOffset.this.setSlot(index, icon, text, ping);
        }

        @Override
        public void setUuid(int index, UUID uuid) {
            AreaWithOffset.this.setUuid(index, uuid);
        }

        @Override
        public void setIcon(int index, Icon icon) {
            AreaWithOffset.this.setIcon(index, icon);
        }

        @Override
        public void setText(int index, String text) {
            AreaWithOffset.this.setText(index, text);
        }

        @Override
        public void setPing(int index, int ping) {
            AreaWithOffset.this.setPing(index, ping);
        }

        @Override
        public void setSlot(int column, int row, UUID uuid, Icon icon, String text, int ping) {
            if (column != 0) {
                throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=1, rows=" + this.getRows() + ").");
            }
            AreaWithOffset.this.setSlot(row, uuid, icon, text, ping);
        }

        @Override
        public void setUuid(int column, int row, UUID uuid) {
            if (column != 0) {
                throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=1, rows=" + this.getRows() + ").");
            }
            AreaWithOffset.this.setUuid(row, uuid);
        }

        @Override
        public void setIcon(int column, int row, Icon icon) {
            if (column != 0) {
                throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=1, rows=" + this.getRows() + ").");
            }
            AreaWithOffset.this.setIcon(row, icon);
        }

        @Override
        public void setText(int column, int row, String text) {
            if (column != 0) {
                throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=1, rows=" + this.getRows() + ").");
            }
            AreaWithOffset.this.setText(row, text);
        }

        @Override
        public void setPing(int column, int row, int ping) {
            if (column != 0) {
                throw new IndexOutOfBoundsException("Index c=" + column + "r=" + row + " out of bounds(columns=1, rows=" + this.getRows() + ").");
            }
            AreaWithOffset.this.setPing(row, ping);
        }

        @Override
        public int getRows() {
            return AreaWithOffset.this.size;
        }

        @Override
        public int getColumns() {
            return 1;
        }

        @Override
        public int getSize() {
            return AreaWithOffset.this.size;
        }

        @Override
        public int getSlotWidth() {
            return AreaWithOffset.this.getSlotWidth();
        }

        @Override
        public Area createChild(int firstIndex, int size) {
            return AreaWithOffset.this.createChild(firstIndex, size);
        }
    }
}

