/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config;

import de.codecrafter47.taboverlay.libs.snakeyaml.error.Mark;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public class ErrorHandler {
    private static ErrorHandler current = null;
    private final List<Entry> entries = new ArrayList<Entry>();
    private final List<Context> contextStack = new ArrayList<Context>();
    private boolean accepting = true;

    public static void set(ErrorHandler errorHandler) {
        current = errorHandler;
    }

    public static ErrorHandler get() {
        if (current == null) {
            current = new ErrorHandler();
        }
        return current;
    }

    public void addError(@Nonnull @NonNull String message, @Nullable Mark position) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (!this.accepting) {
            return;
        }
        this.entries.add(new Entry(Severity.ERROR, message, position, (List<Context>)(this.contextStack.isEmpty() ? null : new ArrayList<Context>(this.contextStack))));
    }

    public void addWarning(@Nonnull @NonNull String message, @Nullable Mark position) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (!this.accepting) {
            return;
        }
        this.entries.add(new Entry(Severity.WARNING, message, position, (List<Context>)(this.contextStack.isEmpty() ? null : new ArrayList<Context>(this.contextStack))));
    }

    public boolean hasErrors() {
        return this.entries.stream().anyMatch(entry -> entry.getSeverity() == Severity.ERROR);
    }

    public void stopAccepting() {
        this.accepting = false;
    }

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void enterContext(String message, Mark mark) {
        if (this.accepting) {
            this.contextStack.add(0, new Context(message, mark));
        }
    }

    public void leaveContext() {
        if (this.accepting && !this.contextStack.isEmpty()) {
            this.contextStack.remove(0);
        }
    }

    public ErrorHandler copy() {
        ErrorHandler copy = new ErrorHandler();
        copy.accepting = this.accepting;
        copy.entries.addAll(this.entries);
        copy.contextStack.addAll(this.contextStack);
        return copy;
    }

    public String formatErrors(String fileName) {
        StringBuilder message = new StringBuilder();
        int errCnt = 0;
        int warnCnt = 0;
        for (Entry error : this.getEntries()) {
            List<Context> context;
            message.append("\n");
            if (error.getSeverity() == Severity.WARNING) {
                message.append("WARNING: ").append(error.getMessage());
                ++warnCnt;
            } else if (error.getSeverity() == Severity.ERROR) {
                message.append("ERROR: ").append(error.getMessage());
                ++errCnt;
            } else {
                throw new AssertionError((Object)"Unknown error severity");
            }
            Mark position = error.getPosition();
            if (position != null) {
                message.append("\n").append(position.toString());
            }
            if ((context = error.getContext()) == null) continue;
            for (Context contextElement : context) {
                message.append("\n ").append(contextElement.getMessage());
                position = contextElement.getPosition();
                if (position == null) continue;
                message.append("\n").append(position.toString());
            }
        }
        String msg = errCnt == 0 ? "There have been " + warnCnt + " warnings while loading " + fileName + message + "\n" : "Failed to load " + fileName + ".\n" + errCnt + " errors and " + warnCnt + " warnings" + message + "\n";
        return msg;
    }

    public static final class Entry {
        @Nonnull
        @NonNull
        private final Severity severity;
        @Nonnull
        @NonNull
        private final String message;
        @Nullable
        private final Mark position;
        @Nullable
        private final List<Context> context;

        public Entry(@Nonnull @NonNull Severity severity, @Nonnull @NonNull String message, @Nullable Mark position, @Nullable List<Context> context) {
            if (severity == null) {
                throw new NullPointerException("severity is marked non-null but is null");
            }
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.severity = severity;
            this.message = message;
            this.position = position;
            this.context = context;
        }

        @Nonnull
        @NonNull
        public Severity getSeverity() {
            return this.severity;
        }

        @Nonnull
        @NonNull
        public String getMessage() {
            return this.message;
        }

        @Nullable
        public Mark getPosition() {
            return this.position;
        }

        @Nullable
        public List<Context> getContext() {
            return this.context;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            Severity this$severity = this.getSeverity();
            Severity other$severity = other.getSeverity();
            if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Mark this$position = this.getPosition();
            Mark other$position = other.getPosition();
            if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
                return false;
            }
            List<Context> this$context = this.getContext();
            List<Context> other$context = other.getContext();
            return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Severity $severity = this.getSeverity();
            result = result * 59 + ($severity == null ? 43 : ((Object)((Object)$severity)).hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Mark $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : $position.hashCode());
            List<Context> $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
            return result;
        }

        public String toString() {
            return "ErrorHandler.Entry(severity=" + (Object)((Object)this.getSeverity()) + ", message=" + this.getMessage() + ", position=" + this.getPosition() + ", context=" + this.getContext() + ")";
        }
    }

    public static enum Severity {
        WARNING,
        ERROR;

    }

    public static final class Context {
        @Nonnull
        @NonNull
        private final String message;
        @Nullable
        private final Mark position;

        public Context(@Nonnull @NonNull String message, @Nullable Mark position) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            this.position = position;
        }

        @Nonnull
        @NonNull
        public String getMessage() {
            return this.message;
        }

        @Nullable
        public Mark getPosition() {
            return this.position;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Mark this$position = this.getPosition();
            Mark other$position = other.getPosition();
            return !(this$position == null ? other$position != null : !this$position.equals(other$position));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Mark $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : $position.hashCode());
            return result;
        }

        public String toString() {
            return "ErrorHandler.Context(message=" + this.getMessage() + ", position=" + this.getPosition() + ")";
        }
    }
}

