/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config;

import de.codecrafter47.taboverlay.AbstractPlayerTabOverlayProvider;
import de.codecrafter47.taboverlay.TabView;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.ExpressionUpdateListener;
import de.codecrafter47.taboverlay.config.expression.ToBooleanExpression;
import de.codecrafter47.taboverlay.config.player.GlobalPlayerSetFactory;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.player.PlayerProvider;
import de.codecrafter47.taboverlay.config.player.PlayerSetFactory;
import de.codecrafter47.taboverlay.config.template.AbstractTabOverlayTemplate;
import de.codecrafter47.taboverlay.config.view.ActiveElement;
import de.codecrafter47.taboverlay.config.view.TabOverlayView;
import de.codecrafter47.taboverlay.handler.TabOverlayHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class ConfigTabOverlayProvider
extends AbstractPlayerTabOverlayProvider {
    private final AbstractTabOverlayTemplate template;
    private final ActivationHandler activationHandler;
    private final Logger logger;
    private final Context context;
    private TabOverlayView tabOverlayView;

    ConfigTabOverlayProvider(@Nonnull @NonNull TabView tabView, @Nonnull @NonNull AbstractTabOverlayTemplate template, @Nonnull @NonNull Player viewer, @Nonnull @NonNull ScheduledExecutorService eventQueue, @Nonnull @NonNull PlayerProvider playerProvider, @Nonnull @NonNull GlobalPlayerSetFactory globalPlayerSetFactory, @Nonnull @NonNull Logger logger) {
        super(tabView, template.getPath().toString(), template.getPriority());
        if (tabView == null) {
            throw new NullPointerException("tabView is marked non-null but is null");
        }
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        if (eventQueue == null) {
            throw new NullPointerException("eventQueue is marked non-null but is null");
        }
        if (playerProvider == null) {
            throw new NullPointerException("playerProvider is marked non-null but is null");
        }
        if (globalPlayerSetFactory == null) {
            throw new NullPointerException("globalPlayerSetFactory is marked non-null but is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        this.template = template;
        this.activationHandler = new ActivationHandler(template.getViewerPredicate().instantiateWithBooleanResult());
        this.logger = logger;
        this.context = Context.from(viewer, eventQueue);
        this.context.setPlayerSetFactory(new PlayerSetFactory(playerProvider, globalPlayerSetFactory, tabView.getLogger(), this.context));
    }

    @Override
    protected void onAttach() {
        this.context.getTabEventQueue().submit(() -> {
            try {
                this.activationHandler.activate(this.context);
            }
            catch (Throwable th) {
                this.logger.log(Level.SEVERE, "Failed to activate activationHandler for " + this.template.getPath().toString(), th);
            }
        }).get();
    }

    @Override
    protected void onActivate(TabOverlayHandler handler) {
        this.context.getTabEventQueue().submit(() -> {
            try {
                this.tabOverlayView = TabOverlayView.create(this.getTabView(), handler, this.context, this.template);
            }
            catch (Throwable th) {
                this.logger.log(Level.SEVERE, "Failed to activate tab overlay " + this.template.getPath().toString(), th);
            }
        }).get();
    }

    @Override
    protected void onDeactivate() {
        try {
            this.context.getTabEventQueue().submit(() -> {
                try {
                    if (this.tabOverlayView != null) {
                        this.tabOverlayView.deactivate();
                    }
                }
                catch (Throwable th) {
                    this.logger.log(Level.SEVERE, "Failed to deactivate tab overlay " + this.template.getPath().toString(), th);
                }
            }).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected void onDetach() {
        try {
            this.context.getTabEventQueue().submit(() -> {
                try {
                    this.activationHandler.deactivate();
                }
                catch (Throwable th) {
                    this.logger.log(Level.SEVERE, "Failed to deactivate activationHandler for " + this.template.getPath().toString(), th);
                }
            }).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected boolean shouldActivate() {
        return this.activationHandler.shouldActivate;
    }

    private class ActivationHandler
    implements ExpressionUpdateListener,
    ActiveElement {
        private final ToBooleanExpression predicate;
        private volatile boolean shouldActivate = false;

        private ActivationHandler(ToBooleanExpression predicate) {
            this.predicate = predicate;
        }

        protected void activate(Context context) {
            this.predicate.activate(context, this);
            this.shouldActivate = this.predicate.evaluate();
        }

        @Override
        public void deactivate() {
            this.predicate.deactivate();
            this.shouldActivate = false;
        }

        @Override
        public void onExpressionUpdate() {
            boolean shouldActivate = this.predicate.evaluate();
            if (shouldActivate != this.shouldActivate) {
                this.shouldActivate = shouldActivate;
                ConfigTabOverlayProvider.this.getTabView().getTabOverlayProviders().scheduleUpdate();
            }
        }
    }
}

