/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.codecrafter47.data.api.DataKey;
import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.TabOverlayProvider;
import de.codecrafter47.taboverlay.TabView;
import de.codecrafter47.taboverlay.config.ComponentSpec;
import de.codecrafter47.taboverlay.config.ConfigTabOverlayProvider;
import de.codecrafter47.taboverlay.config.ErrorHandler;
import de.codecrafter47.taboverlay.config.SortingRulePreprocessor;
import de.codecrafter47.taboverlay.config.TabOverlayTypeSpec;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.dsl.AbstractTabOverlayTemplateConfiguration;
import de.codecrafter47.taboverlay.config.dsl.ComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.DynamicSizeTabOverlayTemplateConfiguration;
import de.codecrafter47.taboverlay.config.dsl.HeaderFooterOnlyTabOverlayTemplateConfiguration;
import de.codecrafter47.taboverlay.config.dsl.RectangularTabOverlayTemplateConfiguration;
import de.codecrafter47.taboverlay.config.dsl.components.AnimatedComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.components.ConditionalComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.components.ContainerComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.components.PlayersComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.components.SpacerComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.components.TableComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderAliasConfiguration;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderAnimatedConfiguration;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderColorAnimationConfiguration;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderComputeConfiguration;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConditionalConfiguration;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConfiguration;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderProgressBarConfiguration;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderSelectConfiguration;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderSwitchConfiguration;
import de.codecrafter47.taboverlay.config.dsl.yaml.ComponentConfigurationInheritanceHandler;
import de.codecrafter47.taboverlay.config.dsl.yaml.CustomPropertyUtils;
import de.codecrafter47.taboverlay.config.dsl.yaml.CustomRepresenter;
import de.codecrafter47.taboverlay.config.dsl.yaml.CustomYamlConstructor;
import de.codecrafter47.taboverlay.config.dsl.yaml.TagInheritanceHandler;
import de.codecrafter47.taboverlay.config.dsl.yaml.TypeFieldInheritanceHandler;
import de.codecrafter47.taboverlay.config.expression.DefaultExpressionEngine;
import de.codecrafter47.taboverlay.config.expression.ExpressionEngine;
import de.codecrafter47.taboverlay.config.icon.IconManager;
import de.codecrafter47.taboverlay.config.placeholder.AbstractPlayerPlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderResolverChain;
import de.codecrafter47.taboverlay.config.placeholder.PlayerPlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.PlayerSetPlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.TextTransformPlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.TimePlaceholderResolver;
import de.codecrafter47.taboverlay.config.platform.EventListener;
import de.codecrafter47.taboverlay.config.platform.Platform;
import de.codecrafter47.taboverlay.config.player.GlobalPlayerSetFactory;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.player.PlayerProvider;
import de.codecrafter47.taboverlay.config.template.AbstractTabOverlayTemplate;
import de.codecrafter47.taboverlay.config.template.PlayerSetTemplate;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.icon.IconTemplate;
import de.codecrafter47.taboverlay.config.template.ping.PingTemplate;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.libs.snakeyaml.DumperOptions;
import de.codecrafter47.taboverlay.libs.snakeyaml.Yaml;
import de.codecrafter47.taboverlay.libs.snakeyaml.error.MarkedYAMLException;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.Tag;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public class ConfigTabOverlayManager {
    private final PlayerProvider playerProvider;
    private final AbstractPlayerPlaceholderResolver playerPlaceholderResolver;
    private final Collection<PlaceholderResolver<Context>> additionalGlobalPlaceholderResolvers;
    private final Yaml yaml;
    private final Logger logger;
    private final ScheduledExecutorService tabEventQueue;
    private final ExpressionEngine expressionEngine;
    private final IconManager iconManager;
    @Nullable
    private TimeZone timeZone = null;
    private final GlobalPlayerSetFactory globalPlayerSetFactory;
    private final List<AbstractTabOverlayTemplateConfiguration<?>> configurations = new ArrayList();
    private final List<AbstractTabOverlayTemplate> templates = new ArrayList<AbstractTabOverlayTemplate>();
    private final DataKey<Icon> playerIconDataKey;
    private final DataKey<Integer> playerPingDataKey;
    private final SortingRulePreprocessor sortingRulePreprocessor;
    private final Map<TabView, Player> tabViews = new HashMap<TabView, Player>();
    @Nonnull
    @NonNull
    private Map<String, CustomPlaceholderConfiguration> globalCustomPlaceholders = new HashMap<String, CustomPlaceholderConfiguration>();

    public ConfigTabOverlayManager(Platform platform, PlayerProvider playerProvider, AbstractPlayerPlaceholderResolver playerPlaceholderResolver, Collection<PlaceholderResolver<Context>> additionalGlobalPlaceholderResolvers, Yaml yaml, Options options, Logger logger, ScheduledExecutorService tabEventQueue, IconManager iconManager) {
        this.playerProvider = playerProvider;
        this.playerPlaceholderResolver = playerPlaceholderResolver;
        this.additionalGlobalPlaceholderResolvers = additionalGlobalPlaceholderResolvers;
        this.yaml = yaml;
        this.logger = logger;
        this.expressionEngine = ConfigTabOverlayManager.constructExpressionEngine(options);
        this.tabEventQueue = tabEventQueue;
        this.iconManager = iconManager;
        this.globalPlayerSetFactory = new GlobalPlayerSetFactory(playerProvider, tabEventQueue, logger, options.playerInvisibleDataKey, options.playerCanSeeInvisibleDataKey);
        this.playerIconDataKey = options.playerIconDataKey;
        this.playerPingDataKey = options.playerPingDataKey;
        this.sortingRulePreprocessor = options.sortingRulePreprocessor;
        platform.addEventListener(new Listener());
    }

    private static ExpressionEngine constructExpressionEngine(Options options) {
        DefaultExpressionEngine.Options expressionEngineOptions = DefaultExpressionEngine.Options.builder().withDefaultValueReaders().withDefaultTokenReaders().withDefaultOperators().build();
        return new DefaultExpressionEngine(expressionEngineOptions);
    }

    public static Yaml constructYamlInstance(Options options) {
        ImmutableMap.Builder inheritanceHandlerMap = ImmutableMap.builder();
        CustomRepresenter representer = new CustomRepresenter();
        ImmutableMap.Builder tabOverlayTypeMap = ImmutableMap.builder();
        for (TabOverlayTypeSpec tabOverlayTypeSpec : options.getTabOverlayTypes()) {
            tabOverlayTypeMap.put((Object)tabOverlayTypeSpec.getId(), tabOverlayTypeSpec.getConfigurationClass());
        }
        inheritanceHandlerMap.put(AbstractTabOverlayTemplateConfiguration.class, (Object)new TypeFieldInheritanceHandler("type", (Map<String, Class<?>>)tabOverlayTypeMap.build(), null));
        ImmutableMap.Builder componentMap = ImmutableMap.builder();
        for (ComponentSpec component : options.getComponents()) {
            componentMap.put((Object)component.getTag(), component.getConfigurationClass());
            representer.addClassTag(component.getConfigurationClass(), new Tag(component.getTag()));
        }
        inheritanceHandlerMap.put(ComponentConfiguration.class, (Object)new ComponentConfigurationInheritanceHandler((Map<String, Class<?>>)componentMap.build()));
        ImmutableMap customPlaceholderMap = ImmutableMap.builder().put((Object)"!conditional", CustomPlaceholderConditionalConfiguration.class).put((Object)"!switch", CustomPlaceholderSwitchConfiguration.class).put((Object)"!select", CustomPlaceholderSelectConfiguration.class).put((Object)"!compute", CustomPlaceholderComputeConfiguration.class).put((Object)"!animated", CustomPlaceholderAnimatedConfiguration.class).put((Object)"!color_animation", CustomPlaceholderColorAnimationConfiguration.class).put((Object)"!progress_bar", CustomPlaceholderProgressBarConfiguration.class).build();
        inheritanceHandlerMap.put(CustomPlaceholderConfiguration.class, (Object)new TagInheritanceHandler((Map<String, Class<?>>)customPlaceholderMap, CustomPlaceholderAliasConfiguration.class));
        representer.addClassTag(CustomPlaceholderConditionalConfiguration.class, new Tag("!conditional"));
        representer.addClassTag(CustomPlaceholderSwitchConfiguration.class, new Tag("!switch"));
        representer.addClassTag(CustomPlaceholderSelectConfiguration.class, new Tag("!select"));
        representer.addClassTag(CustomPlaceholderComputeConfiguration.class, new Tag("!compute"));
        representer.addClassTag(CustomPlaceholderAnimatedConfiguration.class, new Tag("!animated"));
        representer.addClassTag(CustomPlaceholderColorAnimationConfiguration.class, new Tag("!color_animation"));
        representer.addClassTag(CustomPlaceholderProgressBarConfiguration.class, new Tag("!progress_bar"));
        CustomYamlConstructor constructor = new CustomYamlConstructor(inheritanceHandlerMap.build());
        constructor.setPropertyUtils(new CustomPropertyUtils());
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(constructor, representer, dumperOptions);
        constructor.setAllowDuplicateKeys(false);
        return yaml;
    }

    private void loadConfig(Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            AbstractTabOverlayTemplateConfiguration configuration;
            ErrorHandler.set(new ErrorHandler());
            try {
                configuration = this.yaml.loadAs(reader, AbstractTabOverlayTemplateConfiguration.class);
            }
            catch (Throwable th) {
                if (ErrorHandler.get().hasErrors()) {
                    configuration = new RectangularTabOverlayTemplateConfiguration();
                }
                throw th;
            }
            configuration.setPath(path);
            configuration.setErrorHandler(ErrorHandler.get());
            ErrorHandler.set(null);
            this.configurations.add(configuration);
        }
        catch (Throwable th) {
            this.logger.log(Level.WARNING, "Failed to load tab list configuration file " + path + ".\n" + th.toString());
        }
    }

    private boolean load(AbstractTabOverlayTemplateConfiguration<?> configuration) {
        ErrorHandler errorHandler = configuration.getErrorHandler().copy();
        AbstractTabOverlayTemplate template = null;
        try {
            TemplateCreationContext tcc = new TemplateCreationContext(this.expressionEngine, this.iconManager, this.playerIconDataKey, this.playerPingDataKey, errorHandler, this.sortingRulePreprocessor);
            tcc.setPlayerPlaceholderResolver(this.playerPlaceholderResolver);
            tcc.setCustomPlaceholders(new HashMap<String, CustomPlaceholderConfiguration>(this.globalCustomPlaceholders));
            tcc.setPlayerSets(new HashMap<String, PlayerSetTemplate>());
            tcc.setDefaultIcon(IconTemplate.STEVE);
            tcc.setDefaultPing(PingTemplate.ZERO);
            tcc.setDefaultText(TextTemplate.EMPTY);
            tcc.setViewerAvailable(true);
            PlaceholderResolverChain placeholderResolverChain = new PlaceholderResolverChain();
            placeholderResolverChain.addResolver(new PlayerPlaceholderResolver(this.playerPlaceholderResolver, PlayerPlaceholderResolver.BindPoint.VIEWER));
            placeholderResolverChain.addResolver(new PlayerPlaceholderResolver(this.playerPlaceholderResolver, PlayerPlaceholderResolver.BindPoint.PLAYER));
            placeholderResolverChain.addResolver(new TimePlaceholderResolver(this));
            placeholderResolverChain.addResolver(new TextTransformPlaceholderResolver());
            placeholderResolverChain.addResolver(new PlayerSetPlaceholderResolver());
            for (PlaceholderResolver<Context> placeholderResolver : this.additionalGlobalPlaceholderResolvers) {
                placeholderResolverChain.addResolver(placeholderResolver);
            }
            tcc.setPlaceholderResolverChain(placeholderResolverChain);
            template = (AbstractTabOverlayTemplate)configuration.toTemplate(tcc);
            template.setPath(configuration.getPath());
        }
        catch (MarkedYAMLException e) {
            errorHandler.addError("Unexpected exception. " + e.getMessage() + e.getProblem(), e.getProblemMark());
        }
        catch (Throwable th) {
            StringWriter writer = new StringWriter();
            th.printStackTrace(new PrintWriter(writer));
            errorHandler.addError("Unexpected exception. " + writer.toString(), null);
        }
        boolean success = false;
        if (template != null && !errorHandler.hasErrors()) {
            this.templates.add(template);
            success = true;
        }
        if (errorHandler.getEntries().size() > 0) {
            String fileName = configuration.getPath().toString();
            String msg = errorHandler.formatErrors(fileName);
            this.logger.log(Level.WARNING, msg);
        }
        return success;
    }

    private synchronized void loadConfigs(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.find(path, 1, (p, attr) -> p.getFileName().toString().endsWith(".yml") && attr.isRegularFile(), new FileVisitOption[0]).forEach(this::loadConfig);
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Failed to search directory " + path + " for tab list configuration files.", e);
            }
        }
    }

    public synchronized void reloadConfigs(Iterable<Path> paths) {
        this.configurations.clear();
        for (Path path : paths) {
            this.loadConfigs(path);
        }
        this.refreshConfigs();
    }

    public synchronized void refreshConfigs() {
        this.templates.clear();
        Iterator<AbstractTabOverlayTemplateConfiguration<?>> iterator = this.configurations.iterator();
        while (iterator.hasNext()) {
            AbstractTabOverlayTemplateConfiguration<?> configuration = iterator.next();
            if (this.load(configuration)) continue;
            iterator.remove();
        }
        for (Map.Entry<TabView, Player> entry : this.tabViews.entrySet()) {
            TabView tabView = entry.getKey();
            Player viewer = entry.getValue();
            tabView.getTabOverlayProviders().removeProviders(ConfigTabOverlayProvider.class);
            ArrayList<TabOverlayProvider> providers = new ArrayList<TabOverlayProvider>();
            for (AbstractTabOverlayTemplate template : this.templates) {
                providers.add(new ConfigTabOverlayProvider(tabView, template, viewer, this.tabEventQueue, this.playerProvider, this.globalPlayerSetFactory, this.logger));
            }
            tabView.getTabOverlayProviders().addProviders(providers);
        }
    }

    public List<AbstractTabOverlayTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public ExpressionEngine getExpressionEngine() {
        return this.expressionEngine;
    }

    public void setTimeZone(@Nullable TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Nullable
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setGlobalCustomPlaceholders(@Nonnull @NonNull Map<String, CustomPlaceholderConfiguration> globalCustomPlaceholders) {
        if (globalCustomPlaceholders == null) {
            throw new NullPointerException("globalCustomPlaceholders is marked non-null but is null");
        }
        this.globalCustomPlaceholders = globalCustomPlaceholders;
    }

    @Nonnull
    @NonNull
    public Map<String, CustomPlaceholderConfiguration> getGlobalCustomPlaceholders() {
        return this.globalCustomPlaceholders;
    }

    public static final class Options {
        private final ImmutableList<TabOverlayTypeSpec> tabOverlayTypes;
        private final ImmutableList<ComponentSpec> components;
        private final DataKey<Icon> playerIconDataKey;
        private final DataKey<Integer> playerPingDataKey;
        private final DataKey<Boolean> playerInvisibleDataKey;
        private final DataKey<Boolean> playerCanSeeInvisibleDataKey;
        @Nullable
        private final SortingRulePreprocessor sortingRulePreprocessor;

        public static OptionsBuilder createBuilderWithDefaults() {
            return Options.builder().tabOverlayType(new TabOverlayTypeSpec("FIXED_SIZE", RectangularTabOverlayTemplateConfiguration.class)).tabOverlayType(new TabOverlayTypeSpec("DYNAMIC_SIZE_FIXED_COLUMNS", RectangularTabOverlayTemplateConfiguration.class)).tabOverlayType(new TabOverlayTypeSpec("RECTANGULAR", RectangularTabOverlayTemplateConfiguration.class)).tabOverlayType(new TabOverlayTypeSpec("DYNAMIC_SIZE", DynamicSizeTabOverlayTemplateConfiguration.class)).tabOverlayType(new TabOverlayTypeSpec("HEADER_FOOTER", HeaderFooterOnlyTabOverlayTemplateConfiguration.class)).component(new ComponentSpec("!animated", AnimatedComponentConfiguration.class)).component(new ComponentSpec("!conditional", ConditionalComponentConfiguration.class)).component(new ComponentSpec("!container", ContainerComponentConfiguration.class)).component(new ComponentSpec("!players", PlayersComponentConfiguration.class)).component(new ComponentSpec("!spacer", SpacerComponentConfiguration.class)).component(new ComponentSpec("!table", TableComponentConfiguration.class));
        }

        Options(ImmutableList<TabOverlayTypeSpec> tabOverlayTypes, ImmutableList<ComponentSpec> components, DataKey<Icon> playerIconDataKey, DataKey<Integer> playerPingDataKey, DataKey<Boolean> playerInvisibleDataKey, DataKey<Boolean> playerCanSeeInvisibleDataKey, @Nullable SortingRulePreprocessor sortingRulePreprocessor) {
            this.tabOverlayTypes = tabOverlayTypes;
            this.components = components;
            this.playerIconDataKey = playerIconDataKey;
            this.playerPingDataKey = playerPingDataKey;
            this.playerInvisibleDataKey = playerInvisibleDataKey;
            this.playerCanSeeInvisibleDataKey = playerCanSeeInvisibleDataKey;
            this.sortingRulePreprocessor = sortingRulePreprocessor;
        }

        public static OptionsBuilder builder() {
            return new OptionsBuilder();
        }

        public ImmutableList<TabOverlayTypeSpec> getTabOverlayTypes() {
            return this.tabOverlayTypes;
        }

        public ImmutableList<ComponentSpec> getComponents() {
            return this.components;
        }

        public DataKey<Icon> getPlayerIconDataKey() {
            return this.playerIconDataKey;
        }

        public DataKey<Integer> getPlayerPingDataKey() {
            return this.playerPingDataKey;
        }

        public DataKey<Boolean> getPlayerInvisibleDataKey() {
            return this.playerInvisibleDataKey;
        }

        public DataKey<Boolean> getPlayerCanSeeInvisibleDataKey() {
            return this.playerCanSeeInvisibleDataKey;
        }

        @Nullable
        public SortingRulePreprocessor getSortingRulePreprocessor() {
            return this.sortingRulePreprocessor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            ImmutableList<TabOverlayTypeSpec> this$tabOverlayTypes = this.getTabOverlayTypes();
            ImmutableList<TabOverlayTypeSpec> other$tabOverlayTypes = other.getTabOverlayTypes();
            if (this$tabOverlayTypes == null ? other$tabOverlayTypes != null : !this$tabOverlayTypes.equals(other$tabOverlayTypes)) {
                return false;
            }
            ImmutableList<ComponentSpec> this$components = this.getComponents();
            ImmutableList<ComponentSpec> other$components = other.getComponents();
            if (this$components == null ? other$components != null : !this$components.equals(other$components)) {
                return false;
            }
            DataKey<Icon> this$playerIconDataKey = this.getPlayerIconDataKey();
            DataKey<Icon> other$playerIconDataKey = other.getPlayerIconDataKey();
            if (this$playerIconDataKey == null ? other$playerIconDataKey != null : !((Object)this$playerIconDataKey).equals(other$playerIconDataKey)) {
                return false;
            }
            DataKey<Integer> this$playerPingDataKey = this.getPlayerPingDataKey();
            DataKey<Integer> other$playerPingDataKey = other.getPlayerPingDataKey();
            if (this$playerPingDataKey == null ? other$playerPingDataKey != null : !((Object)this$playerPingDataKey).equals(other$playerPingDataKey)) {
                return false;
            }
            DataKey<Boolean> this$playerInvisibleDataKey = this.getPlayerInvisibleDataKey();
            DataKey<Boolean> other$playerInvisibleDataKey = other.getPlayerInvisibleDataKey();
            if (this$playerInvisibleDataKey == null ? other$playerInvisibleDataKey != null : !((Object)this$playerInvisibleDataKey).equals(other$playerInvisibleDataKey)) {
                return false;
            }
            DataKey<Boolean> this$playerCanSeeInvisibleDataKey = this.getPlayerCanSeeInvisibleDataKey();
            DataKey<Boolean> other$playerCanSeeInvisibleDataKey = other.getPlayerCanSeeInvisibleDataKey();
            if (this$playerCanSeeInvisibleDataKey == null ? other$playerCanSeeInvisibleDataKey != null : !((Object)this$playerCanSeeInvisibleDataKey).equals(other$playerCanSeeInvisibleDataKey)) {
                return false;
            }
            SortingRulePreprocessor this$sortingRulePreprocessor = this.getSortingRulePreprocessor();
            SortingRulePreprocessor other$sortingRulePreprocessor = other.getSortingRulePreprocessor();
            return !(this$sortingRulePreprocessor == null ? other$sortingRulePreprocessor != null : !this$sortingRulePreprocessor.equals(other$sortingRulePreprocessor));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ImmutableList<TabOverlayTypeSpec> $tabOverlayTypes = this.getTabOverlayTypes();
            result = result * 59 + ($tabOverlayTypes == null ? 43 : $tabOverlayTypes.hashCode());
            ImmutableList<ComponentSpec> $components = this.getComponents();
            result = result * 59 + ($components == null ? 43 : $components.hashCode());
            DataKey<Icon> $playerIconDataKey = this.getPlayerIconDataKey();
            result = result * 59 + ($playerIconDataKey == null ? 43 : ((Object)$playerIconDataKey).hashCode());
            DataKey<Integer> $playerPingDataKey = this.getPlayerPingDataKey();
            result = result * 59 + ($playerPingDataKey == null ? 43 : ((Object)$playerPingDataKey).hashCode());
            DataKey<Boolean> $playerInvisibleDataKey = this.getPlayerInvisibleDataKey();
            result = result * 59 + ($playerInvisibleDataKey == null ? 43 : ((Object)$playerInvisibleDataKey).hashCode());
            DataKey<Boolean> $playerCanSeeInvisibleDataKey = this.getPlayerCanSeeInvisibleDataKey();
            result = result * 59 + ($playerCanSeeInvisibleDataKey == null ? 43 : ((Object)$playerCanSeeInvisibleDataKey).hashCode());
            SortingRulePreprocessor $sortingRulePreprocessor = this.getSortingRulePreprocessor();
            result = result * 59 + ($sortingRulePreprocessor == null ? 43 : $sortingRulePreprocessor.hashCode());
            return result;
        }

        public String toString() {
            return "ConfigTabOverlayManager.Options(tabOverlayTypes=" + this.getTabOverlayTypes() + ", components=" + this.getComponents() + ", playerIconDataKey=" + this.getPlayerIconDataKey() + ", playerPingDataKey=" + this.getPlayerPingDataKey() + ", playerInvisibleDataKey=" + this.getPlayerInvisibleDataKey() + ", playerCanSeeInvisibleDataKey=" + this.getPlayerCanSeeInvisibleDataKey() + ", sortingRulePreprocessor=" + this.getSortingRulePreprocessor() + ")";
        }

        public static class OptionsBuilder {
            private ImmutableList.Builder<TabOverlayTypeSpec> tabOverlayTypes;
            private ImmutableList.Builder<ComponentSpec> components;
            private DataKey<Icon> playerIconDataKey;
            private DataKey<Integer> playerPingDataKey;
            private DataKey<Boolean> playerInvisibleDataKey;
            private DataKey<Boolean> playerCanSeeInvisibleDataKey;
            private SortingRulePreprocessor sortingRulePreprocessor;

            OptionsBuilder() {
            }

            public OptionsBuilder tabOverlayType(TabOverlayTypeSpec tabOverlayType) {
                if (this.tabOverlayTypes == null) {
                    this.tabOverlayTypes = ImmutableList.builder();
                }
                this.tabOverlayTypes.add((Object)tabOverlayType);
                return this;
            }

            public OptionsBuilder tabOverlayTypes(Iterable<? extends TabOverlayTypeSpec> tabOverlayTypes) {
                if (tabOverlayTypes == null) {
                    throw new NullPointerException("tabOverlayTypes cannot be null");
                }
                if (this.tabOverlayTypes == null) {
                    this.tabOverlayTypes = ImmutableList.builder();
                }
                this.tabOverlayTypes.addAll(tabOverlayTypes);
                return this;
            }

            public OptionsBuilder clearTabOverlayTypes() {
                this.tabOverlayTypes = null;
                return this;
            }

            public OptionsBuilder component(ComponentSpec component) {
                if (this.components == null) {
                    this.components = ImmutableList.builder();
                }
                this.components.add((Object)component);
                return this;
            }

            public OptionsBuilder components(Iterable<? extends ComponentSpec> components) {
                if (components == null) {
                    throw new NullPointerException("components cannot be null");
                }
                if (this.components == null) {
                    this.components = ImmutableList.builder();
                }
                this.components.addAll(components);
                return this;
            }

            public OptionsBuilder clearComponents() {
                this.components = null;
                return this;
            }

            public OptionsBuilder playerIconDataKey(DataKey<Icon> playerIconDataKey) {
                this.playerIconDataKey = playerIconDataKey;
                return this;
            }

            public OptionsBuilder playerPingDataKey(DataKey<Integer> playerPingDataKey) {
                this.playerPingDataKey = playerPingDataKey;
                return this;
            }

            public OptionsBuilder playerInvisibleDataKey(DataKey<Boolean> playerInvisibleDataKey) {
                this.playerInvisibleDataKey = playerInvisibleDataKey;
                return this;
            }

            public OptionsBuilder playerCanSeeInvisibleDataKey(DataKey<Boolean> playerCanSeeInvisibleDataKey) {
                this.playerCanSeeInvisibleDataKey = playerCanSeeInvisibleDataKey;
                return this;
            }

            public OptionsBuilder sortingRulePreprocessor(@Nullable SortingRulePreprocessor sortingRulePreprocessor) {
                this.sortingRulePreprocessor = sortingRulePreprocessor;
                return this;
            }

            public Options build() {
                ImmutableList tabOverlayTypes = this.tabOverlayTypes == null ? ImmutableList.of() : this.tabOverlayTypes.build();
                ImmutableList components = this.components == null ? ImmutableList.of() : this.components.build();
                return new Options((ImmutableList<TabOverlayTypeSpec>)tabOverlayTypes, (ImmutableList<ComponentSpec>)components, this.playerIconDataKey, this.playerPingDataKey, this.playerInvisibleDataKey, this.playerCanSeeInvisibleDataKey, this.sortingRulePreprocessor);
            }

            public String toString() {
                return "ConfigTabOverlayManager.Options.OptionsBuilder(tabOverlayTypes=" + this.tabOverlayTypes + ", components=" + this.components + ", playerIconDataKey=" + this.playerIconDataKey + ", playerPingDataKey=" + this.playerPingDataKey + ", playerInvisibleDataKey=" + this.playerInvisibleDataKey + ", playerCanSeeInvisibleDataKey=" + this.playerCanSeeInvisibleDataKey + ", sortingRulePreprocessor=" + this.sortingRulePreprocessor + ")";
            }
        }
    }

    private class Listener
    implements EventListener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTabViewAdded(TabView tabView, Player viewer) {
            ConfigTabOverlayManager configTabOverlayManager = ConfigTabOverlayManager.this;
            synchronized (configTabOverlayManager) {
                ConfigTabOverlayManager.this.tabViews.put(tabView, viewer);
                ArrayList<TabOverlayProvider> providers = new ArrayList<TabOverlayProvider>();
                for (AbstractTabOverlayTemplate template : ConfigTabOverlayManager.this.templates) {
                    providers.add(new ConfigTabOverlayProvider(tabView, template, viewer, ConfigTabOverlayManager.this.tabEventQueue, ConfigTabOverlayManager.this.playerProvider, ConfigTabOverlayManager.this.globalPlayerSetFactory, ConfigTabOverlayManager.this.logger));
                }
                tabView.getTabOverlayProviders().addProviders(providers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTabViewRemoved(TabView tabView) {
            ConfigTabOverlayManager configTabOverlayManager = ConfigTabOverlayManager.this;
            synchronized (configTabOverlayManager) {
                ConfigTabOverlayManager.this.tabViews.remove(tabView);
                tabView.getTabOverlayProviders().removeProviders(ConfigTabOverlayProvider.class);
            }
        }
    }
}

