/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.util;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.IntConsumer;

public final class ConcurrentBitSet {
    final int size;
    final AtomicLongArray array;

    public ConcurrentBitSet(int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"size must not be negative");
        this.size = size;
        this.array = new AtomicLongArray((size + 63) / 64);
    }

    public void set(int index) {
        long expect;
        Preconditions.checkElementIndex((int)index, (int)this.size);
        int longIndex = index >> 6;
        long mask = 1L << (index & 0x3F);
        while (!this.array.compareAndSet(longIndex, expect = this.array.get(longIndex), expect | mask)) {
        }
    }

    public void clear(int index) {
        long expect;
        Preconditions.checkElementIndex((int)index, (int)this.size);
        int longIndex = index >> 6;
        long mask = 1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL;
        while (!this.array.compareAndSet(longIndex, expect = this.array.get(longIndex), expect & mask)) {
        }
    }

    public void iterateAndClear(IntConsumer consumer) {
        for (int longIndex = 0; longIndex < this.array.length(); ++longIndex) {
            int i;
            for (long l = this.array.getAndSet(longIndex, 0L); l != 0L; l &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL) {
                i = Long.numberOfTrailingZeros(l);
                consumer.accept(longIndex << 6 | i);
            }
        }
    }
}

