/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class Completer
implements TabCompleter {
    private List<TabCompleter> completers = new ArrayList<TabCompleter>();

    public static Completer create() {
        return new Completer();
    }

    public Completer player() {
        this.completers.add(new TabCompletePlayer());
        return this;
    }

    public Completer any(String ... args) {
        this.completers.add(new TabCompleteCollection(Arrays.asList(args)));
        return this;
    }

    public Completer any(Collection args) {
        this.completers.add(new TabCompleteCollection(args));
        return this;
    }

    public Completer single(String arg) {
        this.completers.add(new TabCompleteSingle(arg));
        return this;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        int i = args.length;
        if (i <= this.completers.size()) {
            return this.completers.get(i - 1).onTabComplete(sender, command, alias, args);
        }
        return null;
    }

    private static class TabCompletePlayer
    implements TabCompleter {
        private TabCompletePlayer() {
        }

        public List<String> onTabComplete(CommandSender sender, Command command, String alias, final String[] args) {
            ArrayList<String> list = new ArrayList<String>();
            FluentIterable.from((Iterable)Bukkit.getOnlinePlayers()).filter((Predicate)new Predicate<Player>(){

                public boolean apply(Player player) {
                    return player.getName().toLowerCase().startsWith(args[args.length - 1].toLowerCase());
                }
            }).transform((Function)new Function<Player, String>(){

                public String apply(Player player) {
                    return player.getName();
                }
            }).copyInto(list);
            return list;
        }
    }

    private static class TabCompleteCollection
    implements TabCompleter {
        private final Collection<String> options;

        private TabCompleteCollection(Collection<String> options) {
            this.options = options;
        }

        public List<String> onTabComplete(CommandSender sender, Command command, String alias, final String[] args) {
            ArrayList<String> list = new ArrayList<String>();
            FluentIterable.from(this.options).filter((Predicate)new Predicate<String>(){

                public boolean apply(String option) {
                    return option.toLowerCase().startsWith(args[args.length - 1].toLowerCase());
                }
            }).copyInto(list);
            return list;
        }
    }

    private static class TabCompleteSingle
    implements TabCompleter {
        private final String result;

        private TabCompleteSingle(String result) {
            this.result = result;
        }

        public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            return Lists.newArrayList((Object[])new String[]{this.result});
        }
    }
}

