/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.util;

import com.google.common.base.Preconditions;
import de.codecrafter47.taboverlay.bukkit.internal.util.ConcurrentBitSet;

public class BitSet {
    private final int size;
    private final long[] array;

    public BitSet(int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"size must not be negative");
        this.size = size;
        this.array = new long[(size + 63) / 64];
    }

    public void set(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.size);
        int longIndex = index >> 6;
        long mask = 1L << (index & 0x3F);
        int n = longIndex;
        this.array[n] = this.array[n] | mask;
    }

    public void set(int fromIndex, int toIndex) {
        Preconditions.checkElementIndex((int)fromIndex, (int)this.size);
        Preconditions.checkPositionIndex((int)toIndex, (int)this.size);
        if (fromIndex >= toIndex) {
            return;
        }
        int startWordIndex = fromIndex >> 6;
        int endWordIndex = toIndex - 1 >> 6;
        long firstWordMask = -1L << fromIndex;
        long lastWordMask = -1L >>> -toIndex;
        if (startWordIndex == endWordIndex) {
            int n = startWordIndex;
            this.array[n] = this.array[n] | firstWordMask & lastWordMask;
        } else {
            int n = startWordIndex;
            this.array[n] = this.array[n] | firstWordMask;
            for (int i = startWordIndex + 1; i < endWordIndex; ++i) {
                this.array[i] = -1L;
            }
            int n2 = endWordIndex;
            this.array[n2] = this.array[n2] | lastWordMask;
        }
    }

    public void clear(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.size);
        int longIndex = index >> 6;
        long mask = 1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL;
        int n = longIndex;
        this.array[n] = this.array[n] & mask;
    }

    public void clear() {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = 0L;
        }
    }

    public boolean get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.size);
        int longIndex = index >> 6;
        long mask = 1L << (index & 0x3F);
        return 0L != (this.array[longIndex] & mask);
    }

    public int cardinality() {
        int sum = 0;
        for (int i = 0; i < this.array.length; ++i) {
            sum += Long.bitCount(this.array[i]);
        }
        return sum;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.array.length; ++i) {
            long l = this.array[i];
            if (l == 0L) continue;
            return false;
        }
        return true;
    }

    public int nextSetBit(int previous) {
        Preconditions.checkPositionIndex((int)previous, (int)this.size);
        int longIndex = previous >> 6;
        if (longIndex >= this.array.length) {
            return -1;
        }
        long word = this.array[longIndex] & -1L << previous;
        while (word == 0L) {
            if (++longIndex == this.array.length) {
                return -1;
            }
            word = this.array[longIndex];
        }
        return longIndex * 64 + Long.numberOfTrailingZeros(word);
    }

    public int previousSetBit(int fromIndex) {
        Preconditions.checkElementIndex((int)fromIndex, (int)this.size);
        int longIndex = fromIndex >> 6;
        long word = this.array[longIndex] & -1L >>> -(fromIndex + 1);
        while (word == 0L) {
            if (longIndex-- == 0) {
                return -1;
            }
            word = this.array[longIndex];
        }
        return (longIndex + 1) * 64 - 1 - Long.numberOfLeadingZeros(word);
    }

    public void copyAndClear(ConcurrentBitSet source) {
        Preconditions.checkArgument((source.size == this.size ? 1 : 0) != 0);
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = source.array.getAndSet(i, 0L);
        }
    }

    public void orAndClear(ConcurrentBitSet source) {
        Preconditions.checkArgument((source.size == this.size ? 1 : 0) != 0);
        for (int i = 0; i < this.array.length; ++i) {
            int n = i;
            this.array[n] = this.array[n] | source.array.getAndSet(i, 0L);
        }
    }

    public void orXor(BitSet a, BitSet b) {
        Preconditions.checkArgument((a.size == this.size ? 1 : 0) != 0);
        Preconditions.checkArgument((b.size == this.size ? 1 : 0) != 0);
        for (int i = 0; i < this.array.length; ++i) {
            int n = i;
            this.array[n] = this.array[n] | a.array[i] ^ b.array[i];
        }
    }
}

