/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.template;

import de.codecrafter47.taboverlay.bukkit.internal.ATOContextKeys;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.player.PlayerSetFactory;
import de.codecrafter47.taboverlay.config.template.PlayerOrderTemplate;
import de.codecrafter47.taboverlay.config.template.PlayerSetTemplate;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.template.icon.IconTemplate;
import de.codecrafter47.taboverlay.config.template.ping.PingTemplate;
import de.codecrafter47.taboverlay.config.template.text.TextTemplate;
import de.codecrafter47.taboverlay.config.view.components.ComponentView;
import de.codecrafter47.taboverlay.config.view.components.ContainerComponentView;
import de.codecrafter47.taboverlay.config.view.components.PartitionedPlayersView;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class PlayersByWorldComponentTemplate
implements ComponentTemplate {
    private final PlayerSetTemplate playerSet;
    private final PlayerSetFactory playerSetFactory;
    private final PlayerOrderTemplate playerOrder;
    private final ComponentTemplate playerComponent;
    @Nonnull
    @NonNull
    private final ComponentTemplate morePlayersComponent;
    @Nullable
    private final ComponentTemplate worldHeader;
    @Nullable
    private final ComponentTemplate worldFooter;
    @Nullable
    private final ComponentTemplate worldSeparator;
    private final boolean fillSlotsVertical;
    private final int minSize;
    private final int maxSize;
    private final int minSizePerWorld;
    private final int maxSizePerWorld;
    private final int columns;
    private final TextTemplate defaultText;
    private final PingTemplate defaultPing;
    private final IconTemplate defaultIcon;
    private final ExpressionTemplate partitionFunction;

    @Override
    public ComponentTemplate.LayoutInfo getLayoutInfo() {
        return ComponentTemplate.LayoutInfo.builder().constantSize(false).minSize(0).blockAligned(true).build();
    }

    @Override
    public ComponentView instantiate() {
        return new ContainerComponentView(new PartitionedPlayersView(this.fillSlotsVertical ? 1 : this.columns, this.playerSet, this.playerComponent, this.playerComponent.getLayoutInfo().getMinSize(), this.morePlayersComponent, this.morePlayersComponent.getLayoutInfo().getMinSize(), this.playerOrder, this.defaultText, this.defaultPing, this.defaultIcon, this.partitionFunction, this.worldHeader, this.worldFooter, this.worldSeparator, this.minSizePerWorld, this.maxSizePerWorld, (parent, sectionId, playerSet1) -> {
            Context child = parent.clone();
            child.setCustomObject(ATOContextKeys.WORLD_ID, sectionId);
            child.setCustomObject(ATOContextKeys.WORLD_PLAYER_SET, playerSet1);
            return child;
        }), this.fillSlotsVertical, this.minSize, this.maxSize, this.columns, false);
    }

    PlayersByWorldComponentTemplate(PlayerSetTemplate playerSet, PlayerSetFactory playerSetFactory, PlayerOrderTemplate playerOrder, ComponentTemplate playerComponent, @Nonnull @NonNull ComponentTemplate morePlayersComponent, @Nullable ComponentTemplate worldHeader, @Nullable ComponentTemplate worldFooter, @Nullable ComponentTemplate worldSeparator, boolean fillSlotsVertical, int minSize, int maxSize, int minSizePerWorld, int maxSizePerWorld, int columns, TextTemplate defaultText, PingTemplate defaultPing, IconTemplate defaultIcon, ExpressionTemplate partitionFunction) {
        if (morePlayersComponent == null) {
            throw new NullPointerException("morePlayersComponent is marked non-null but is null");
        }
        this.playerSet = playerSet;
        this.playerSetFactory = playerSetFactory;
        this.playerOrder = playerOrder;
        this.playerComponent = playerComponent;
        this.morePlayersComponent = morePlayersComponent;
        this.worldHeader = worldHeader;
        this.worldFooter = worldFooter;
        this.worldSeparator = worldSeparator;
        this.fillSlotsVertical = fillSlotsVertical;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.minSizePerWorld = minSizePerWorld;
        this.maxSizePerWorld = maxSizePerWorld;
        this.columns = columns;
        this.defaultText = defaultText;
        this.defaultPing = defaultPing;
        this.defaultIcon = defaultIcon;
        this.partitionFunction = partitionFunction;
    }

    public static PlayersByWorldComponentTemplateBuilder builder() {
        return new PlayersByWorldComponentTemplateBuilder();
    }

    public PlayerSetTemplate getPlayerSet() {
        return this.playerSet;
    }

    public PlayerSetFactory getPlayerSetFactory() {
        return this.playerSetFactory;
    }

    public PlayerOrderTemplate getPlayerOrder() {
        return this.playerOrder;
    }

    public ComponentTemplate getPlayerComponent() {
        return this.playerComponent;
    }

    @Nonnull
    @NonNull
    public ComponentTemplate getMorePlayersComponent() {
        return this.morePlayersComponent;
    }

    @Nullable
    public ComponentTemplate getWorldHeader() {
        return this.worldHeader;
    }

    @Nullable
    public ComponentTemplate getWorldFooter() {
        return this.worldFooter;
    }

    @Nullable
    public ComponentTemplate getWorldSeparator() {
        return this.worldSeparator;
    }

    public boolean isFillSlotsVertical() {
        return this.fillSlotsVertical;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinSizePerWorld() {
        return this.minSizePerWorld;
    }

    public int getMaxSizePerWorld() {
        return this.maxSizePerWorld;
    }

    public int getColumns() {
        return this.columns;
    }

    public TextTemplate getDefaultText() {
        return this.defaultText;
    }

    public PingTemplate getDefaultPing() {
        return this.defaultPing;
    }

    public IconTemplate getDefaultIcon() {
        return this.defaultIcon;
    }

    public ExpressionTemplate getPartitionFunction() {
        return this.partitionFunction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayersByWorldComponentTemplate)) {
            return false;
        }
        PlayersByWorldComponentTemplate other = (PlayersByWorldComponentTemplate)o;
        if (this.isFillSlotsVertical() != other.isFillSlotsVertical()) {
            return false;
        }
        if (this.getMinSize() != other.getMinSize()) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        if (this.getMinSizePerWorld() != other.getMinSizePerWorld()) {
            return false;
        }
        if (this.getMaxSizePerWorld() != other.getMaxSizePerWorld()) {
            return false;
        }
        if (this.getColumns() != other.getColumns()) {
            return false;
        }
        PlayerSetTemplate this$playerSet = this.getPlayerSet();
        PlayerSetTemplate other$playerSet = other.getPlayerSet();
        if (this$playerSet == null ? other$playerSet != null : !((Object)this$playerSet).equals(other$playerSet)) {
            return false;
        }
        PlayerSetFactory this$playerSetFactory = this.getPlayerSetFactory();
        PlayerSetFactory other$playerSetFactory = other.getPlayerSetFactory();
        if (this$playerSetFactory == null ? other$playerSetFactory != null : !this$playerSetFactory.equals(other$playerSetFactory)) {
            return false;
        }
        PlayerOrderTemplate this$playerOrder = this.getPlayerOrder();
        PlayerOrderTemplate other$playerOrder = other.getPlayerOrder();
        if (this$playerOrder == null ? other$playerOrder != null : !((Object)this$playerOrder).equals(other$playerOrder)) {
            return false;
        }
        ComponentTemplate this$playerComponent = this.getPlayerComponent();
        ComponentTemplate other$playerComponent = other.getPlayerComponent();
        if (this$playerComponent == null ? other$playerComponent != null : !this$playerComponent.equals(other$playerComponent)) {
            return false;
        }
        ComponentTemplate this$morePlayersComponent = this.getMorePlayersComponent();
        ComponentTemplate other$morePlayersComponent = other.getMorePlayersComponent();
        if (this$morePlayersComponent == null ? other$morePlayersComponent != null : !this$morePlayersComponent.equals(other$morePlayersComponent)) {
            return false;
        }
        ComponentTemplate this$worldHeader = this.getWorldHeader();
        ComponentTemplate other$worldHeader = other.getWorldHeader();
        if (this$worldHeader == null ? other$worldHeader != null : !this$worldHeader.equals(other$worldHeader)) {
            return false;
        }
        ComponentTemplate this$worldFooter = this.getWorldFooter();
        ComponentTemplate other$worldFooter = other.getWorldFooter();
        if (this$worldFooter == null ? other$worldFooter != null : !this$worldFooter.equals(other$worldFooter)) {
            return false;
        }
        ComponentTemplate this$worldSeparator = this.getWorldSeparator();
        ComponentTemplate other$worldSeparator = other.getWorldSeparator();
        if (this$worldSeparator == null ? other$worldSeparator != null : !this$worldSeparator.equals(other$worldSeparator)) {
            return false;
        }
        TextTemplate this$defaultText = this.getDefaultText();
        TextTemplate other$defaultText = other.getDefaultText();
        if (this$defaultText == null ? other$defaultText != null : !this$defaultText.equals(other$defaultText)) {
            return false;
        }
        PingTemplate this$defaultPing = this.getDefaultPing();
        PingTemplate other$defaultPing = other.getDefaultPing();
        if (this$defaultPing == null ? other$defaultPing != null : !this$defaultPing.equals(other$defaultPing)) {
            return false;
        }
        IconTemplate this$defaultIcon = this.getDefaultIcon();
        IconTemplate other$defaultIcon = other.getDefaultIcon();
        if (this$defaultIcon == null ? other$defaultIcon != null : !this$defaultIcon.equals(other$defaultIcon)) {
            return false;
        }
        ExpressionTemplate this$partitionFunction = this.getPartitionFunction();
        ExpressionTemplate other$partitionFunction = other.getPartitionFunction();
        return !(this$partitionFunction == null ? other$partitionFunction != null : !this$partitionFunction.equals(other$partitionFunction));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFillSlotsVertical() ? 79 : 97);
        result = result * 59 + this.getMinSize();
        result = result * 59 + this.getMaxSize();
        result = result * 59 + this.getMinSizePerWorld();
        result = result * 59 + this.getMaxSizePerWorld();
        result = result * 59 + this.getColumns();
        PlayerSetTemplate $playerSet = this.getPlayerSet();
        result = result * 59 + ($playerSet == null ? 43 : ((Object)$playerSet).hashCode());
        PlayerSetFactory $playerSetFactory = this.getPlayerSetFactory();
        result = result * 59 + ($playerSetFactory == null ? 43 : $playerSetFactory.hashCode());
        PlayerOrderTemplate $playerOrder = this.getPlayerOrder();
        result = result * 59 + ($playerOrder == null ? 43 : ((Object)$playerOrder).hashCode());
        ComponentTemplate $playerComponent = this.getPlayerComponent();
        result = result * 59 + ($playerComponent == null ? 43 : $playerComponent.hashCode());
        ComponentTemplate $morePlayersComponent = this.getMorePlayersComponent();
        result = result * 59 + ($morePlayersComponent == null ? 43 : $morePlayersComponent.hashCode());
        ComponentTemplate $worldHeader = this.getWorldHeader();
        result = result * 59 + ($worldHeader == null ? 43 : $worldHeader.hashCode());
        ComponentTemplate $worldFooter = this.getWorldFooter();
        result = result * 59 + ($worldFooter == null ? 43 : $worldFooter.hashCode());
        ComponentTemplate $worldSeparator = this.getWorldSeparator();
        result = result * 59 + ($worldSeparator == null ? 43 : $worldSeparator.hashCode());
        TextTemplate $defaultText = this.getDefaultText();
        result = result * 59 + ($defaultText == null ? 43 : $defaultText.hashCode());
        PingTemplate $defaultPing = this.getDefaultPing();
        result = result * 59 + ($defaultPing == null ? 43 : $defaultPing.hashCode());
        IconTemplate $defaultIcon = this.getDefaultIcon();
        result = result * 59 + ($defaultIcon == null ? 43 : $defaultIcon.hashCode());
        ExpressionTemplate $partitionFunction = this.getPartitionFunction();
        result = result * 59 + ($partitionFunction == null ? 43 : $partitionFunction.hashCode());
        return result;
    }

    public String toString() {
        return "PlayersByWorldComponentTemplate(playerSet=" + this.getPlayerSet() + ", playerSetFactory=" + this.getPlayerSetFactory() + ", playerOrder=" + this.getPlayerOrder() + ", playerComponent=" + this.getPlayerComponent() + ", morePlayersComponent=" + this.getMorePlayersComponent() + ", worldHeader=" + this.getWorldHeader() + ", worldFooter=" + this.getWorldFooter() + ", worldSeparator=" + this.getWorldSeparator() + ", fillSlotsVertical=" + this.isFillSlotsVertical() + ", minSize=" + this.getMinSize() + ", maxSize=" + this.getMaxSize() + ", minSizePerWorld=" + this.getMinSizePerWorld() + ", maxSizePerWorld=" + this.getMaxSizePerWorld() + ", columns=" + this.getColumns() + ", defaultText=" + this.getDefaultText() + ", defaultPing=" + this.getDefaultPing() + ", defaultIcon=" + this.getDefaultIcon() + ", partitionFunction=" + this.getPartitionFunction() + ")";
    }

    public static class PlayersByWorldComponentTemplateBuilder {
        private PlayerSetTemplate playerSet;
        private PlayerSetFactory playerSetFactory;
        private PlayerOrderTemplate playerOrder;
        private ComponentTemplate playerComponent;
        private ComponentTemplate morePlayersComponent;
        private ComponentTemplate worldHeader;
        private ComponentTemplate worldFooter;
        private ComponentTemplate worldSeparator;
        private boolean fillSlotsVertical;
        private int minSize;
        private int maxSize;
        private int minSizePerWorld;
        private int maxSizePerWorld;
        private int columns;
        private TextTemplate defaultText;
        private PingTemplate defaultPing;
        private IconTemplate defaultIcon;
        private ExpressionTemplate partitionFunction;

        PlayersByWorldComponentTemplateBuilder() {
        }

        public PlayersByWorldComponentTemplateBuilder playerSet(PlayerSetTemplate playerSet) {
            this.playerSet = playerSet;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder playerSetFactory(PlayerSetFactory playerSetFactory) {
            this.playerSetFactory = playerSetFactory;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder playerOrder(PlayerOrderTemplate playerOrder) {
            this.playerOrder = playerOrder;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder playerComponent(ComponentTemplate playerComponent) {
            this.playerComponent = playerComponent;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder morePlayersComponent(@Nonnull @NonNull ComponentTemplate morePlayersComponent) {
            if (morePlayersComponent == null) {
                throw new NullPointerException("morePlayersComponent is marked non-null but is null");
            }
            this.morePlayersComponent = morePlayersComponent;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder worldHeader(@Nullable ComponentTemplate worldHeader) {
            this.worldHeader = worldHeader;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder worldFooter(@Nullable ComponentTemplate worldFooter) {
            this.worldFooter = worldFooter;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder worldSeparator(@Nullable ComponentTemplate worldSeparator) {
            this.worldSeparator = worldSeparator;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder fillSlotsVertical(boolean fillSlotsVertical) {
            this.fillSlotsVertical = fillSlotsVertical;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder minSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder minSizePerWorld(int minSizePerWorld) {
            this.minSizePerWorld = minSizePerWorld;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder maxSizePerWorld(int maxSizePerWorld) {
            this.maxSizePerWorld = maxSizePerWorld;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder columns(int columns) {
            this.columns = columns;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder defaultText(TextTemplate defaultText) {
            this.defaultText = defaultText;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder defaultPing(PingTemplate defaultPing) {
            this.defaultPing = defaultPing;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder defaultIcon(IconTemplate defaultIcon) {
            this.defaultIcon = defaultIcon;
            return this;
        }

        public PlayersByWorldComponentTemplateBuilder partitionFunction(ExpressionTemplate partitionFunction) {
            this.partitionFunction = partitionFunction;
            return this;
        }

        public PlayersByWorldComponentTemplate build() {
            return new PlayersByWorldComponentTemplate(this.playerSet, this.playerSetFactory, this.playerOrder, this.playerComponent, this.morePlayersComponent, this.worldHeader, this.worldFooter, this.worldSeparator, this.fillSlotsVertical, this.minSize, this.maxSize, this.minSizePerWorld, this.maxSizePerWorld, this.columns, this.defaultText, this.defaultPing, this.defaultIcon, this.partitionFunction);
        }

        public String toString() {
            return "PlayersByWorldComponentTemplate.PlayersByWorldComponentTemplateBuilder(playerSet=" + this.playerSet + ", playerSetFactory=" + this.playerSetFactory + ", playerOrder=" + this.playerOrder + ", playerComponent=" + this.playerComponent + ", morePlayersComponent=" + this.morePlayersComponent + ", worldHeader=" + this.worldHeader + ", worldFooter=" + this.worldFooter + ", worldSeparator=" + this.worldSeparator + ", fillSlotsVertical=" + this.fillSlotsVertical + ", minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", minSizePerWorld=" + this.minSizePerWorld + ", maxSizePerWorld=" + this.maxSizePerWorld + ", columns=" + this.columns + ", defaultText=" + this.defaultText + ", defaultPing=" + this.defaultPing + ", defaultIcon=" + this.defaultIcon + ", partitionFunction=" + this.partitionFunction + ")";
        }
    }
}

