/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.placeholders;

import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.taboverlay.bukkit.internal.ATOContextKeys;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderException;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.UnknownPlaceholderException;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.player.PlayerSet;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import java.util.List;
import javax.annotation.Nonnull;

public class WorldPlaceholderResolver
implements PlaceholderResolver<Context> {
    @Override
    @Nonnull
    public PlaceholderBuilder<?, ?> resolve(PlaceholderBuilder<Context, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) throws UnknownPlaceholderException, PlaceholderException {
        if (args.size() >= 1 && "world".equalsIgnoreCase(args.get(0).getText())) {
            args.remove(0);
            if (args.size() == 1 && "name".equalsIgnoreCase(args.get(0).getText())) {
                args.remove(0);
                return builder.acquireData(WorldIdPlaceholder::new, TypeToken.STRING);
            }
            if (args.size() == 1 && "player_count".equalsIgnoreCase(args.get(0).getText())) {
                args.remove(0);
                return builder.acquireData(() -> new WorldPlayerCountPlaceholder(), TypeToken.INTEGER);
            }
            if (args.size() == 0) {
                return builder.acquireData(WorldIdPlaceholder::new, TypeToken.STRING);
            }
            throw new PlaceholderException("Unknown world placeholder");
        }
        throw new UnknownPlaceholderException();
    }

    private static class WorldPlayerCountPlaceholder
    extends AbstractActiveElement<Runnable>
    implements PlaceholderDataProvider<Context, Integer>,
    PlayerSet.Listener {
        private PlayerSet playerSet;

        private WorldPlayerCountPlaceholder() {
        }

        @Override
        protected void onActivation() {
            this.playerSet = this.getContext().getCustomObject(ATOContextKeys.WORLD_PLAYER_SET);
            this.playerSet.addListener(this);
        }

        @Override
        public Integer getData() {
            return this.playerSet.getCount();
        }

        @Override
        protected void onDeactivation() {
            this.playerSet.removeListener(this);
        }

        @Override
        public void onPlayerAdded(Player player) {
            if (this.hasListener()) {
                ((Runnable)this.getListener()).run();
            }
        }

        @Override
        public void onPlayerRemoved(Player player) {
            if (this.hasListener()) {
                ((Runnable)this.getListener()).run();
            }
        }
    }

    public static class WorldIdPlaceholder
    extends AbstractActiveElement<Runnable>
    implements PlaceholderDataProvider<Context, String> {
        @Override
        public String getData() {
            return this.getContext().getCustomObject(ATOContextKeys.WORLD_ID);
        }

        @Override
        protected void onActivation() {
        }

        @Override
        protected void onDeactivation() {
        }
    }
}

