/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.placeholders;

import de.codecrafter47.data.api.DataKey;
import de.codecrafter47.data.api.TypeToken;
import de.codecrafter47.data.bukkit.api.BukkitData;
import de.codecrafter47.data.minecraft.api.MinecraftData;
import de.codecrafter47.taboverlay.bukkit.internal.ATODataKeys;
import de.codecrafter47.taboverlay.config.context.Context;
import de.codecrafter47.taboverlay.config.expression.ExpressionUpdateListener;
import de.codecrafter47.taboverlay.config.expression.ToStringExpression;
import de.codecrafter47.taboverlay.config.expression.template.ExpressionTemplate;
import de.codecrafter47.taboverlay.config.placeholder.AbstractPlayerPlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderDataProvider;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderException;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.view.AbstractActiveElement;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class PlayerPlaceholderResolver
extends AbstractPlayerPlaceholderResolver {
    public PlayerPlaceholderResolver() {
        this.addPlaceholder("ping", PlayerPlaceholderResolver.create(ATODataKeys.PING));
        this.addPlaceholder("world", PlayerPlaceholderResolver.create(MinecraftData.World));
        this.addPlaceholder("team", PlayerPlaceholderResolver.create(MinecraftData.Team));
        this.addPlaceholder("vault_balance", PlayerPlaceholderResolver.create(MinecraftData.Economy_Balance));
        this.addPlaceholder("vault_balance2", PlayerPlaceholderResolver.create(MinecraftData.Economy_Balance, (R b) -> {
            if (b >= 1.0E7) {
                return String.format("%1.0fM", b / 1000000.0);
            }
            if (b >= 10000.0) {
                return String.format("%1.0fK", b / 1000.0);
            }
            if (b >= 100.0) {
                return String.format("%1.0f", b);
            }
            return String.format("%1.2f", b);
        }, TypeToken.STRING));
        this.addPlaceholder("multiverse_world_alias", PlayerPlaceholderResolver.create(BukkitData.Multiverse_WorldAlias));
        this.addPlaceholder("faction_name", PlayerPlaceholderResolver.create(BukkitData.Factions_FactionName));
        this.addPlaceholder("faction_member_count", PlayerPlaceholderResolver.create(BukkitData.Factions_FactionMembers));
        this.addPlaceholder("faction_online_member_count", PlayerPlaceholderResolver.create(BukkitData.Factions_OnlineFactionMembers));
        this.addPlaceholder("faction_at_current_location", PlayerPlaceholderResolver.create(BukkitData.Factions_FactionsWhere));
        this.addPlaceholder("faction_power", PlayerPlaceholderResolver.create(BukkitData.Factions_FactionPower));
        this.addPlaceholder("faction_player_power", PlayerPlaceholderResolver.create(BukkitData.Factions_PlayerPower));
        this.addPlaceholder("faction_rank", PlayerPlaceholderResolver.create(BukkitData.Factions_FactionsRank));
        this.addPlaceholder("SimpleClans_ClanName", PlayerPlaceholderResolver.create(BukkitData.SimpleClans_ClanName));
        this.addPlaceholder("SimpleClans_ClanMembers", PlayerPlaceholderResolver.create(BukkitData.SimpleClans_ClanMembers));
        this.addPlaceholder("SimpleClans_OnlineClanMembers", PlayerPlaceholderResolver.create(BukkitData.SimpleClans_OnlineClanMembers));
        this.addPlaceholder("SimpleClans_ClanTag", PlayerPlaceholderResolver.create(BukkitData.SimpleClans_ClanTag));
        this.addPlaceholder("SimpleClans_ClanTagLabel", PlayerPlaceholderResolver.create(BukkitData.SimpleClans_ClanTagLabel));
        this.addPlaceholder("SimpleClans_ClanColorTag", PlayerPlaceholderResolver.create(BukkitData.SimpleClans_ClanColorTag));
        this.addPlaceholder("vault_primary_group", PlayerPlaceholderResolver.create(MinecraftData.Permissions_PermissionGroup));
        this.addPlaceholder("vault_prefix", PlayerPlaceholderResolver.create(MinecraftData.Permissions_Prefix));
        this.addPlaceholder("vault_suffix", PlayerPlaceholderResolver.create(MinecraftData.Permissions_Suffix));
        this.addPlaceholder("vault_primary_group_prefix", PlayerPlaceholderResolver.create(MinecraftData.Permissions_PrimaryGroupPrefix));
        this.addPlaceholder("vault_primary_group_weight", PlayerPlaceholderResolver.create(MinecraftData.Permissions_PermissionGroupWeight));
        this.addPlaceholder("vault_player_prefix", PlayerPlaceholderResolver.create(MinecraftData.Permissions_PlayerPrefix));
        this.addPlaceholder("health", PlayerPlaceholderResolver.create(MinecraftData.Health));
        this.addPlaceholder("max_health", PlayerPlaceholderResolver.create(MinecraftData.MaxHealth));
        this.addPlaceholder("location_x", PlayerPlaceholderResolver.create(MinecraftData.PosX));
        this.addPlaceholder("location_y", PlayerPlaceholderResolver.create(MinecraftData.PosY));
        this.addPlaceholder("location_z", PlayerPlaceholderResolver.create(MinecraftData.PosZ));
        this.addPlaceholder("xp", PlayerPlaceholderResolver.create(MinecraftData.XP));
        this.addPlaceholder("total_xp", PlayerPlaceholderResolver.create(MinecraftData.TotalXP));
        this.addPlaceholder("level", PlayerPlaceholderResolver.create(MinecraftData.Level));
        this.addPlaceholder("player_points", PlayerPlaceholderResolver.create(BukkitData.PlayerPoints_Points));
        this.addPlaceholder("vault_currency", PlayerPlaceholderResolver.create(MinecraftData.Economy_CurrencyNameSingular));
        this.addPlaceholder("vault_currency_plural", PlayerPlaceholderResolver.create(MinecraftData.Economy_CurrencyNamePlural));
        this.addPlaceholder("tab_name", PlayerPlaceholderResolver.create(BukkitData.PlayerListName, (Player player, R name) -> name == null ? player.getName() : name, TypeToken.STRING));
        this.addPlaceholder("display_name", PlayerPlaceholderResolver.create(MinecraftData.DisplayName, (Player player, R name) -> name == null ? player.getName() : name, TypeToken.STRING));
        this.addPlaceholder("essentials_afk", PlayerPlaceholderResolver.create(BukkitData.Essentials_IsAFK, (Player player, R afk) -> afk == null ? false : afk, TypeToken.BOOLEAN));
        this.addPlaceholder("is_hidden", PlayerPlaceholderResolver.create(ATODataKeys.HIDDEN));
        this.addPlaceholder("gamemode", PlayerPlaceholderResolver.create(ATODataKeys.GAMEMODE));
        this.addPlaceholder("askyblock_island_level", PlayerPlaceholderResolver.create(BukkitData.ASkyBlock_IslandLevel));
        this.addPlaceholder("askyblock_island_name", PlayerPlaceholderResolver.create(BukkitData.ASkyBlock_IslandName));
        this.addPlaceholder("askyblock_team_leader", PlayerPlaceholderResolver.create(BukkitData.ASkyBlock_TeamLeader));
        this.addPlaceholder("permission", this::resolvePermissionPlaceholder);
    }

    @Nonnull
    private PlaceholderBuilder<?, ?> resolvePermissionPlaceholder(PlaceholderBuilder<Player, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) {
        if (args.isEmpty()) {
            throw new PlaceholderException("Use of permission placeholder lacks specification of specific permission");
        }
        ExpressionTemplate permission = args.remove(0).getExpression();
        Function<Context, Player> playerFunction = builder.getContextTransformation();
        return PlaceholderBuilder.create().acquireData(() -> new PermissionDataProvider(permission.instantiateWithStringResult(), playerFunction), TypeToken.BOOLEAN, builder.isRequiresViewerContext() || permission.requiresViewerContext());
    }

    private static class PermissionDataProvider
    extends AbstractActiveElement<Runnable>
    implements PlaceholderDataProvider<Context, Boolean>,
    ExpressionUpdateListener {
        private final ToStringExpression permission;
        private final Function<Context, Player> playerFunction;
        private DataKey<Boolean> permissionDataKey;

        private PermissionDataProvider(ToStringExpression permission, Function<Context, Player> playerFunction) {
            this.permission = permission;
            this.playerFunction = playerFunction;
        }

        @Override
        protected void onActivation() {
            this.permission.activate(this.getContext(), this);
            this.permissionDataKey = MinecraftData.permission(this.permission.evaluate());
            if (this.hasListener()) {
                this.playerFunction.apply(this.getContext()).addDataChangeListener(this.permissionDataKey, (Runnable)this.getListener());
            }
        }

        @Override
        protected void onDeactivation() {
            this.permission.deactivate();
            if (this.hasListener()) {
                this.playerFunction.apply(this.getContext()).removeDataChangeListener(this.permissionDataKey, (Runnable)this.getListener());
            }
        }

        @Override
        public Boolean getData() {
            return this.playerFunction.apply(this.getContext()).get(this.permissionDataKey);
        }

        @Override
        public void onExpressionUpdate() {
            if (this.hasListener()) {
                this.playerFunction.apply(this.getContext()).removeDataChangeListener(this.permissionDataKey, (Runnable)this.getListener());
            }
            this.permissionDataKey = MinecraftData.permission(this.permission.evaluate());
            if (this.hasListener()) {
                this.playerFunction.apply(this.getContext()).addDataChangeListener(this.permissionDataKey, (Runnable)this.getListener());
                ((Runnable)this.getListener()).run();
            }
        }
    }
}

