/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.placeholders;

import de.codecrafter47.taboverlay.bukkit.internal.ATODataKeys;
import de.codecrafter47.taboverlay.bukkit.internal.placeholders.PlayerPlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderArg;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderBuilder;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderException;
import de.codecrafter47.taboverlay.config.placeholder.PlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.UnknownPlaceholderException;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.clip.placeholderapi.PlaceholderAPI;

public class PAPIAwarePlayerPlaceholderResolver
extends PlayerPlaceholderResolver {
    @Override
    @Nonnull
    public PlaceholderBuilder<?, ?> resolve(PlaceholderBuilder<Player, ?> builder, List<PlaceholderArg> args, TemplateCreationContext tcc) throws UnknownPlaceholderException, PlaceholderException {
        try {
            return super.resolve(builder, args, tcc);
        }
        catch (UnknownPlaceholderException unknownPlaceholderException) {
            if (args.size() > 0 && args.get(0) instanceof PlaceholderArg.Text) {
                String token = args.get(0).getText();
                Set prefixes = PlaceholderAPI.getRegisteredPlaceholderPlugins();
                for (String prefix : prefixes) {
                    if (token.length() < prefix.length() || !token.substring(0, prefix.length()).equalsIgnoreCase(prefix)) continue;
                    args.remove(0);
                    PlaceholderResolver<Player> resolver = PAPIAwarePlayerPlaceholderResolver.create(ATODataKeys.createPlaceholderAPIDataKey("%" + token + "%"));
                    this.addPlaceholder(token, resolver);
                    return resolver.resolve(builder, args, tcc);
                }
            }
            throw new UnknownPlaceholderException();
        }
    }
}

