/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.handler.safe;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedProfilePublicKey;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.PacketHelper;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

final class VanillaTabOverlayTracker {
    private PacketHelper packetHelper;
    private boolean is119;
    private WrappedChatComponent header = null;
    private WrappedChatComponent footer = null;
    private Map<String, String> playerToTeamMap = new HashMap<String, String>();
    private Map<String, PacketHelper.TeamProperties> teamProperties = new HashMap<String, PacketHelper.TeamProperties>();
    private Map<String, Set<String>> teamPlayers = new HashMap<String, Set<String>>();
    private Map<UUID, PlayerListEntry> playerListEntries = new HashMap<UUID, PlayerListEntry>();
    private TeamEventListener teamEventListener;
    private PlayerListEventListener playerListEventListener;

    VanillaTabOverlayTracker(PacketHelper packetHelper) {
        this.packetHelper = packetHelper;
        try {
            Class.forName("com.comphenix.protocol.wrappers.WrappedProfilePublicKey");
            this.is119 = true;
        }
        catch (ClassNotFoundException e) {
            this.is119 = false;
        }
    }

    void onPacketSending(PacketContainer packet, ChannelHandlerContext ctx) {
        PacketType type = packet.getType();
        if (type == PacketType.Play.Server.PLAYER_LIST_HEADER_FOOTER) {
            this.header = (WrappedChatComponent)packet.getChatComponents().read(0);
            this.footer = (WrappedChatComponent)packet.getChatComponents().read(1);
        } else if (type == PacketType.Play.Server.PLAYER_INFO) {
            EnumWrappers.PlayerInfoAction action = (EnumWrappers.PlayerInfoAction)packet.getPlayerInfoAction().read(0);
            List data = (List)packet.getPlayerInfoDataLists().read(0);
            switch (action) {
                case ADD_PLAYER: {
                    for (PlayerInfoData infoData : data) {
                        PlayerListEntry entry = this.playerListEntries.remove(infoData.getProfile().getUUID());
                        if (entry != null) {
                            this.fireOnPlayerRemoved(ctx, entry);
                        }
                        entry = this.is119 ? new PlayerListEntry119(infoData) : new PlayerListEntry(infoData);
                        this.playerListEntries.put(infoData.getProfile().getUUID(), entry);
                        this.fireOnPlayerAdded(ctx, entry);
                    }
                    break;
                }
                case UPDATE_GAME_MODE: {
                    for (PlayerInfoData infoData : data) {
                        PlayerListEntry entry = this.playerListEntries.get(infoData.getProfile().getUUID());
                        if (entry == null) continue;
                        entry.gameMode = infoData.getGameMode();
                        this.fireOnGameModeUpdate(ctx, entry);
                    }
                    break;
                }
                case UPDATE_LATENCY: {
                    for (PlayerInfoData infoData : data) {
                        PlayerListEntry entry = this.playerListEntries.get(infoData.getProfile().getUUID());
                        if (entry == null) continue;
                        entry.latency = infoData.getLatency();
                    }
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    for (PlayerInfoData infoData : data) {
                        PlayerListEntry entry = this.playerListEntries.get(infoData.getProfile().getUUID());
                        if (entry == null) continue;
                        entry.displayName = infoData.getDisplayName();
                    }
                    break;
                }
                case REMOVE_PLAYER: {
                    for (PlayerInfoData infoData : data) {
                        PlayerListEntry entry = this.playerListEntries.remove(infoData.getProfile().getUUID());
                        if (entry == null) continue;
                        this.fireOnPlayerRemoved(ctx, entry);
                    }
                    break;
                }
            }
        }
    }

    void onPacketSent(ChannelHandlerContext ctx, PacketContainer packet) {
        PacketType type = packet.getType();
        if (type == PacketType.Play.Server.SCOREBOARD_TEAM) {
            String teamName = this.packetHelper.getTeamName(packet);
            switch (this.packetHelper.getTeamMode(packet)) {
                case CREATE: {
                    Set<String> playerSet = this.teamPlayers.remove(teamName);
                    if (playerSet != null) {
                        for (String player : playerSet) {
                            if (!this.playerToTeamMap.remove(player, teamName)) continue;
                            this.fireOnPlayerRemovedFromTeam(ctx, player, teamName);
                        }
                    }
                    Collection<String> players = this.packetHelper.getTeamPlayers(packet);
                    PacketHelper.TeamProperties properties = this.packetHelper.getTeamProperties(packet);
                    this.teamProperties.put(teamName, properties);
                    this.teamPlayers.put(teamName, new HashSet<String>(players));
                    this.fireOnTeamPropertiesUpdated(ctx, teamName, properties);
                    for (String player : players) {
                        String oldTeam = this.playerToTeamMap.put(player, teamName);
                        if (oldTeam != null) {
                            this.fireOnPlayerRemovedFromTeam(ctx, player, oldTeam);
                        }
                        this.fireOnPlayerAddedToTeam(ctx, player, teamName);
                    }
                    break;
                }
                case REMOVE: {
                    this.teamProperties.remove(teamName);
                    Set<String> playerSet = this.teamPlayers.remove(teamName);
                    if (playerSet == null) break;
                    for (String player : playerSet) {
                        if (!this.playerToTeamMap.remove(player, teamName)) continue;
                        this.fireOnPlayerRemovedFromTeam(ctx, player, teamName);
                    }
                    break;
                }
                case UPDATE: {
                    PacketHelper.TeamProperties properties = this.packetHelper.getTeamProperties(packet);
                    this.teamProperties.put(teamName, properties);
                    this.fireOnTeamPropertiesUpdated(ctx, teamName, properties);
                    break;
                }
                case ADD_PLAYERS: {
                    Collection<String> players = this.packetHelper.getTeamPlayers(packet);
                    Set<String> playerSet = this.teamPlayers.get(teamName);
                    if (playerSet == null) break;
                    playerSet.addAll(players);
                    for (String player : players) {
                        String oldTeam = this.playerToTeamMap.put(player, teamName);
                        if (oldTeam != null) {
                            this.fireOnPlayerRemovedFromTeam(ctx, player, oldTeam);
                        }
                        this.fireOnPlayerAddedToTeam(ctx, player, teamName);
                    }
                    break;
                }
                case REMOVE_PLAYERS: {
                    Collection<String> players = this.packetHelper.getTeamPlayers(packet);
                    Set<String> playerSet = this.teamPlayers.get(teamName);
                    if (playerSet == null) break;
                    playerSet.removeAll(players);
                    for (String player : players) {
                        if (!this.playerToTeamMap.remove(player, teamName)) continue;
                        this.fireOnPlayerRemovedFromTeam(ctx, player, teamName);
                    }
                    break;
                }
            }
        }
    }

    @Nullable
    PacketHelper.TeamProperties getTeamProperties(String teamName) {
        return this.teamProperties.get(teamName);
    }

    @Nullable
    Set<String> getTeamMembers(String teamName) {
        return this.teamPlayers.get(teamName);
    }

    @Nullable
    String getTeamForPlayer(String player) {
        return this.playerToTeamMap.get(player);
    }

    @Nullable
    PlayerListEntry getPlayerListEntry(UUID uuid) {
        return this.playerListEntries.get(uuid);
    }

    Collection<PlayerListEntry> getPlayerListEntries() {
        return this.playerListEntries.values();
    }

    private void fireOnPlayerRemovedFromTeam(ChannelHandlerContext ctx, String player, String team) {
        if (this.teamEventListener != null) {
            this.teamEventListener.onPlayerRemovedFromTeam(ctx, player, team);
        }
    }

    private void fireOnPlayerAddedToTeam(ChannelHandlerContext ctx, String player, String team) {
        if (this.teamEventListener != null) {
            this.teamEventListener.onPlayerAddedToTeam(ctx, player, team);
        }
    }

    private void fireOnTeamPropertiesUpdated(ChannelHandlerContext ctx, String team, PacketHelper.TeamProperties properties) {
        if (this.teamEventListener != null) {
            this.teamEventListener.onTeamPropertiesUpdated(ctx, team, properties);
        }
    }

    private void fireOnPlayerAdded(ChannelHandlerContext ctx, PlayerListEntry entry) {
        if (this.playerListEventListener != null) {
            this.playerListEventListener.onPlayerAdded(ctx, entry);
        }
    }

    private void fireOnPlayerRemoved(ChannelHandlerContext ctx, PlayerListEntry entry) {
        if (this.playerListEventListener != null) {
            this.playerListEventListener.onPlayerRemoved(ctx, entry);
        }
    }

    private void fireOnGameModeUpdate(ChannelHandlerContext ctx, PlayerListEntry entry) {
        if (this.playerListEventListener != null) {
            this.playerListEventListener.onGameModeUpdate(ctx, entry);
        }
    }

    public WrappedChatComponent getHeader() {
        return this.header;
    }

    public WrappedChatComponent getFooter() {
        return this.footer;
    }

    public TeamEventListener getTeamEventListener() {
        return this.teamEventListener;
    }

    public void setTeamEventListener(TeamEventListener teamEventListener) {
        this.teamEventListener = teamEventListener;
    }

    public PlayerListEventListener getPlayerListEventListener() {
        return this.playerListEventListener;
    }

    public void setPlayerListEventListener(PlayerListEventListener playerListEventListener) {
        this.playerListEventListener = playerListEventListener;
    }

    static class PlayerListEntry {
        int latency;
        EnumWrappers.NativeGameMode gameMode;
        WrappedGameProfile profile;
        WrappedChatComponent displayName;

        PlayerListEntry(PlayerInfoData data) {
            this.latency = data.getLatency();
            this.gameMode = data.getGameMode();
            this.profile = data.getProfile();
            this.displayName = data.getDisplayName();
        }
    }

    static class PlayerListEntry119
    extends PlayerListEntry {
        WrappedProfilePublicKey.WrappedProfileKeyData profileKeyData;

        PlayerListEntry119(PlayerInfoData data) {
            super(data);
            this.profileKeyData = data.getProfileKeyData();
        }
    }

    static interface TeamEventListener {
        public void onPlayerRemovedFromTeam(ChannelHandlerContext var1, String var2, String var3);

        public void onPlayerAddedToTeam(ChannelHandlerContext var1, String var2, String var3);

        public void onTeamPropertiesUpdated(ChannelHandlerContext var1, String var2, PacketHelper.TeamProperties var3);
    }

    static interface PlayerListEventListener {
        public void onPlayerAdded(ChannelHandlerContext var1, PlayerListEntry var2);

        public void onPlayerRemoved(ChannelHandlerContext var1, PlayerListEntry var2);

        public void onGameModeUpdate(ChannelHandlerContext var1, PlayerListEntry var2);
    }
}

