/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.handler.safe;

import com.comphenix.protocol.events.PacketContainer;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.Constants;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.PacketHelper;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.VanillaTabOverlayTracker;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class TeamManager
implements VanillaTabOverlayTracker.TeamEventListener {
    private PacketHelper packetHelper;
    private final VanillaTabOverlayTracker tracker;
    private final Set<String> trackedPlayers = new HashSet<String>();
    private final Map<String, Integer> playerToSlotMap = new HashMap<String, Integer>();

    TeamManager(VanillaTabOverlayTracker tracker, PacketHelper packetHelper) {
        this.tracker = tracker;
        this.packetHelper = packetHelper;
    }

    void activate(ChannelHandlerContext ctx) {
        for (int i = 0; i < 80; ++i) {
            PacketContainer packet = this.packetHelper.createTeam(Constants.SLOT_TEAM_NAME[i], Collections.singleton(Constants.SLOT_USERNAME[i]));
            ctx.write(packet.getHandle(), ctx.newPromise());
        }
        PacketContainer packet = this.packetHelper.createTeam(Constants.OVERFLOW_TEAM_NAME, Collections.emptySet());
        ctx.write(packet.getHandle(), ctx.newPromise());
        this.tracker.setTeamEventListener(this);
    }

    void deactivate(ChannelHandlerContext ctx) {
        if (!this.trackedPlayers.isEmpty()) {
            throw new AssertionError((Object)"Called deactivate, but trackedPlayers is not empty");
        }
        for (int i = 0; i < 80; ++i) {
            PacketContainer packet = this.packetHelper.removeTeam(Constants.SLOT_TEAM_NAME[i]);
            ctx.write(packet.getHandle(), ctx.newPromise());
        }
        PacketContainer packet = this.packetHelper.removeTeam(Constants.OVERFLOW_TEAM_NAME);
        ctx.write(packet.getHandle(), ctx.newPromise());
        this.tracker.setTeamEventListener(null);
    }

    void trackPlayer(ChannelHandlerContext ctx, String name) {
        if (this.trackedPlayers.contains(name)) {
            throw new AssertionError((Object)("Already tracking " + name));
        }
        this.trackedPlayers.add(name);
        String vanillaTeam = this.tracker.getTeamForPlayer(name);
        if (null == vanillaTeam) {
            this.addToOverflowTeam(ctx, name);
        }
    }

    private void addToOverflowTeam(ChannelHandlerContext ctx, String name) {
        PacketContainer packet = this.packetHelper.addPlayerToTeam(Constants.OVERFLOW_TEAM_NAME, name);
        ctx.write(packet.getHandle(), ctx.newPromise());
    }

    void addPlayerToTeam(ChannelHandlerContext ctx, int slot, String name) {
        PacketHelper.TeamProperties properties;
        PacketContainer packet;
        if (!this.trackedPlayers.contains(name)) {
            throw new AssertionError((Object)("Not tracking " + name));
        }
        if (this.playerToSlotMap.containsKey(name)) {
            throw new AssertionError((Object)("player " + name + " has been assigned to a team already."));
        }
        String vanillaTeam = this.tracker.getTeamForPlayer(name);
        if (null != vanillaTeam) {
            packet = this.packetHelper.removePlayerFromTeam(vanillaTeam, name);
            ctx.write(packet.getHandle(), ctx.newPromise());
        }
        if (vanillaTeam == null) {
            this.removeFromOverflowTeam(ctx, name);
        }
        packet = this.packetHelper.addPlayerToTeam(Constants.SLOT_TEAM_NAME[slot], name);
        ctx.write(packet.getHandle(), ctx.newPromise());
        this.playerToSlotMap.put(name, slot);
        if (null != vanillaTeam && null != (properties = this.tracker.getTeamProperties(vanillaTeam))) {
            packet = this.packetHelper.updateTeam(Constants.SLOT_TEAM_NAME[slot], properties);
            ctx.write(packet.getHandle(), ctx.newPromise());
        }
    }

    private void removeFromOverflowTeam(ChannelHandlerContext ctx, String name) {
        PacketContainer packet = this.packetHelper.removePlayerFromTeam(Constants.OVERFLOW_TEAM_NAME, name);
        ctx.write(packet.getHandle(), ctx.newPromise());
    }

    void removePlayerFromTeam(ChannelHandlerContext ctx, int slot, String name) {
        if (!this.trackedPlayers.contains(name)) {
            throw new AssertionError((Object)("Not tracking " + name));
        }
        if (this.playerToSlotMap.get(name) != slot) {
            if (this.playerToSlotMap.containsKey(name)) {
                throw new AssertionError((Object)("player " + name + " is assigned to a different team"));
            }
            throw new AssertionError((Object)("player " + name + " is assigned to a no team"));
        }
        PacketContainer packet = this.packetHelper.removePlayerFromTeam(Constants.SLOT_TEAM_NAME[slot], name);
        ctx.write(packet.getHandle(), ctx.newPromise());
        this.playerToSlotMap.remove(name);
        String vanillaTeam = this.tracker.getTeamForPlayer(name);
        if (null != vanillaTeam) {
            packet = this.packetHelper.updateTeamWithDefaults(Constants.SLOT_TEAM_NAME[slot]);
            ctx.write(packet.getHandle(), ctx.newPromise());
            packet = this.packetHelper.addPlayerToTeam(vanillaTeam, name);
            ctx.write(packet.getHandle(), ctx.newPromise());
        } else {
            this.addToOverflowTeam(ctx, name);
        }
    }

    void untrackPlayer(ChannelHandlerContext ctx, String name) {
        if (!this.trackedPlayers.contains(name)) {
            throw new AssertionError((Object)("Not tracking " + name));
        }
        if (this.playerToSlotMap.containsKey(name)) {
            throw new AssertionError((Object)("player " + name + " is assigned to a team."));
        }
        String vanillaTeam = this.tracker.getTeamForPlayer(name);
        if (vanillaTeam == null) {
            this.removeFromOverflowTeam(ctx, name);
        }
        this.trackedPlayers.remove(name);
    }

    void onTeamPacket(PacketContainer packet) {
        Collection<String> players = this.packetHelper.getTeamPlayers(packet);
        if (players != null) {
            int toRemove = 0;
            for (String player : players) {
                if (!this.trackedPlayers.contains(player)) continue;
                ++toRemove;
            }
            if (toRemove > 0) {
                HashSet<String> newPlayers = new HashSet<String>(players.size() - toRemove);
                for (String player : players) {
                    if (this.trackedPlayers.contains(player)) continue;
                    newPlayers.add(player);
                }
                this.packetHelper.setTeamPlayers(packet, newPlayers);
            }
        }
    }

    @Override
    public void onPlayerRemovedFromTeam(ChannelHandlerContext ctx, String player, String team) {
        Integer slot = this.playerToSlotMap.get(player);
        if (slot != null) {
            PacketContainer packet = this.packetHelper.updateTeamWithDefaults(Constants.SLOT_TEAM_NAME[slot]);
            ctx.write(packet.getHandle(), ctx.newPromise());
        } else {
            this.addToOverflowTeam(ctx, player);
        }
    }

    @Override
    public void onPlayerAddedToTeam(ChannelHandlerContext ctx, String player, String team) {
        Integer slot = this.playerToSlotMap.get(player);
        if (slot != null) {
            PacketHelper.TeamProperties properties = this.tracker.getTeamProperties(team);
            if (null != properties) {
                PacketContainer packet = this.packetHelper.updateTeam(Constants.SLOT_TEAM_NAME[slot], properties);
                ctx.write(packet.getHandle(), ctx.newPromise());
            }
        } else {
            PacketContainer packet = this.packetHelper.addPlayerToTeam(team, player);
            ctx.write(packet.getHandle(), ctx.newPromise());
        }
    }

    @Override
    public void onTeamPropertiesUpdated(ChannelHandlerContext ctx, String team, PacketHelper.TeamProperties properties) {
        Set<String> teamMembers = this.tracker.getTeamMembers(team);
        if (teamMembers != null) {
            for (String player : teamMembers) {
                Integer slot = this.playerToSlotMap.get(player);
                if (slot == null) continue;
                PacketContainer packet = this.packetHelper.updateTeam(Constants.SLOT_TEAM_NAME[slot], properties);
                ctx.write(packet.getHandle(), ctx.newPromise());
            }
        }
    }
}

