/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.handler.safe;

import com.google.common.base.Preconditions;
import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.CustomContentOperationModeHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.PacketHelper;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.SafeTabOverlayHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.VanillaTabOverlayTracker;
import de.codecrafter47.taboverlay.bukkit.internal.util.BitSet;
import de.codecrafter47.taboverlay.handler.SimpleTabOverlay;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

class SimpleOperationModeHandler
extends CustomContentOperationModeHandler<Representation> {
    private static final BitSet[] SIZE_TO_USED_SLOTS = new BitSet[81];

    SimpleOperationModeHandler(SafeTabOverlayHandler handler, VanillaTabOverlayTracker tracker, UUID viewerUuid, PacketHelper packetHelper) {
        super(handler, tracker, viewerUuid, packetHelper);
    }

    @Override
    Representation createRepresentation() {
        return new Representation();
    }

    @Override
    void updateSize() {
        int newSize = ((Representation)this.representation).size;
        int vanillaTabListSize = this.freePlayers.size() + this.playerUuidToSlotMap.size();
        if (newSize != 80 && newSize < vanillaTabListSize) {
            newSize = Integer.min(vanillaTabListSize, 80);
            this.canShrink = true;
        } else {
            this.canShrink = false;
        }
        if (newSize > this.highestUsedSlotIndex + 1) {
            this.dirtySlots.set(this.highestUsedSlotIndex + 1, newSize);
        } else if (newSize <= this.highestUsedSlotIndex) {
            this.dirtySlots.set(newSize, this.highestUsedSlotIndex + 1);
        }
        this.usedSlots = SIZE_TO_USED_SLOTS[newSize];
    }

    static {
        for (int size = 0; size <= 80; ++size) {
            BitSet usedSlots = new BitSet(80);
            usedSlots.set(0, size);
            SimpleOperationModeHandler.SIZE_TO_USED_SLOTS[size] = usedSlots;
        }
    }

    class Representation
    extends CustomContentOperationModeHandler.Representation
    implements SimpleTabOverlay {
        int size;

        Representation() {
            super(SimpleOperationModeHandler.this);
            this.size = 0;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public int getMaxSize() {
            return 80;
        }

        @Override
        public void setSize(int size) {
            if (size < 0 || size > 80) {
                throw new IllegalArgumentException("size");
            }
            this.size = size;
            this.dirtyFlagSize = true;
            this.scheduleUpdateIfNotInBatch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSlot(int index, @Nullable UUID uuid, @Nonnull Icon icon, @Nonnull String text, int ping) {
            if (this.isValid()) {
                Preconditions.checkElementIndex((int)index, (int)this.size, (String)"index");
                this.beginBatchModification();
                try {
                    this.setUuidInternal(index, uuid);
                    this.setIconInternal(index, icon);
                    this.setTextInternal(index, text);
                    this.setPingInternal(index, ping);
                }
                finally {
                    this.completeBatchModification();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSlot(int index, @Nonnull Icon icon, @Nonnull String text, int ping) {
            if (this.isValid()) {
                Preconditions.checkElementIndex((int)index, (int)this.size, (String)"index");
                this.beginBatchModification();
                try {
                    this.setUuidInternal(index, null);
                    this.setIconInternal(index, icon);
                    this.setTextInternal(index, text);
                    this.setPingInternal(index, ping);
                }
                finally {
                    this.completeBatchModification();
                }
            }
        }

        @Override
        public void setUuid(int index, UUID uuid) {
            if (this.isValid()) {
                Preconditions.checkElementIndex((int)index, (int)this.size, (String)"index");
                this.setUuidInternal(index, uuid);
            }
        }

        @Override
        public void setIcon(int index, @Nonnull @NonNull Icon icon) {
            if (icon == null) {
                throw new NullPointerException("icon is marked non-null but is null");
            }
            if (this.isValid()) {
                Preconditions.checkElementIndex((int)index, (int)this.size, (String)"index");
                this.setIconInternal(index, icon);
            }
        }

        @Override
        public void setText(int index, @Nonnull @NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            if (this.isValid()) {
                Preconditions.checkElementIndex((int)index, (int)this.size, (String)"index");
                this.setTextInternal(index, text);
            }
        }

        @Override
        public void setPing(int index, int ping) {
            if (this.isValid()) {
                Preconditions.checkElementIndex((int)index, (int)this.size, (String)"index");
                this.setPingInternal(index, ping);
            }
        }
    }
}

