/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.handler.safe;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.google.common.collect.ImmutableSet;
import de.codecrafter47.taboverlay.TabView;
import de.codecrafter47.taboverlay.bukkit.TabOverlayHandlerFactory;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.PacketHelper;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.PacketHelper1_12;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.PacketHelper1_13;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.PacketHelper1_17;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.PacketHelper1_19;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.PacketHelper1_8;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.SafeTabOverlayHandler;
import de.codecrafter47.taboverlay.bukkit.internal.util.Util;
import de.codecrafter47.taboverlay.handler.ContentOperationMode;
import de.codecrafter47.taboverlay.handler.HeaderAndFooterOperationMode;
import de.codecrafter47.taboverlay.handler.TabOverlayHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;

public class SafeTabOverlayHandlerFactory
implements TabOverlayHandlerFactory {
    private final Map<Player, SafeTabOverlayHandler> tabOverlayHandlerMap = new HashMap<Player, SafeTabOverlayHandler>();
    private PacketHelper packetHelper;

    public SafeTabOverlayHandlerFactory() throws IllegalStateException {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.SCOREBOARD_TEAM);
        int size = packet.getStrings().getFields().size();
        if (size == 5) {
            this.packetHelper = new PacketHelper1_8();
        } else if (size == 6) {
            this.packetHelper = new PacketHelper1_12();
        } else if (size == 3) {
            this.packetHelper = new PacketHelper1_13();
        } else if (size == 1) {
            try {
                Class.forName("com.comphenix.protocol.wrappers.WrappedProfilePublicKey");
                this.packetHelper = new PacketHelper1_19();
            }
            catch (ClassNotFoundException e) {
                this.packetHelper = new PacketHelper1_17();
            }
        } else {
            throw new IllegalStateException("Unsupported Minecraft version");
        }
    }

    @Override
    public TabOverlayHandler create(Player player) {
        Channel channel = Util.getChannel(player);
        SafeTabOverlayHandler tabOverlayHandler = new SafeTabOverlayHandler(player, this.packetHelper);
        MyChannelHandler channelHandler = new MyChannelHandler(tabOverlayHandler);
        channel.pipeline().addBefore("packet_handler", "AdvancedTabOverlay-0", (ChannelHandler)channelHandler);
        this.tabOverlayHandlerMap.put(player, tabOverlayHandler);
        return tabOverlayHandler;
    }

    @Override
    public void onCreated(TabView tabView, Player player) {
    }

    @Override
    public void onDisable() {
        for (SafeTabOverlayHandler handler : this.tabOverlayHandlerMap.values()) {
            handler.enterContentOperationMode(ContentOperationMode.PASS_TROUGH);
            handler.enterHeaderAndFooterOperationMode(HeaderAndFooterOperationMode.PASS_TROUGH);
        }
    }

    private static class MyChannelHandler
    extends ChannelOutboundHandlerAdapter {
        private final SafeTabOverlayHandler tablistHandler;
        private static final Set<PacketType> interceptedPacketTypes = ImmutableSet.of((Object)PacketType.Play.Server.PLAYER_INFO, (Object)PacketType.Play.Server.PLAYER_LIST_HEADER_FOOTER, (Object)PacketType.Play.Server.SCOREBOARD_TEAM);

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (PacketType.hasClass(msg.getClass())) {
                PacketContainer packet = PacketContainer.fromPacket((Object)msg);
                if (interceptedPacketTypes.contains(packet.getType())) {
                    PacketContainer clonedPacket = packet.shallowClone();
                    if (this.tablistHandler.onPacketSending(ctx, packet)) {
                        super.write(ctx, packet.getHandle(), promise);
                    }
                    this.tablistHandler.onPacketSent(ctx, clonedPacket);
                } else {
                    super.write(ctx, msg, promise);
                }
                this.tablistHandler.networkTick(ctx);
            } else {
                super.write(ctx, msg, promise);
            }
        }

        public MyChannelHandler(SafeTabOverlayHandler tablistHandler) {
            this.tablistHandler = tablistHandler;
        }
    }
}

