/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.handler.safe;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.AbstractOperationModeHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.ContentPassthroughOperationModeHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.CustomHeaderAndFooterOperationModeHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.HandlerQueue;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.HeaderAndFooterPassthroughOperationModeHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.NoOpOperationModeHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.PacketHelper;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.RectangularOperationModeHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.SimpleOperationModeHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.VanillaTabOverlayTracker;
import de.codecrafter47.taboverlay.config.misc.Unchecked;
import de.codecrafter47.taboverlay.handler.ContentOperationMode;
import de.codecrafter47.taboverlay.handler.HeaderAndFooterOperationMode;
import de.codecrafter47.taboverlay.handler.TabOverlayHandler;
import io.netty.channel.ChannelHandlerContext;
import org.bukkit.entity.Player;

class SafeTabOverlayHandler
implements TabOverlayHandler {
    static final WrappedChatComponent CHAT_COMPONENT_EMPTY = WrappedChatComponent.fromJson((String)"{\"text\":\"\"}");
    private final Player player;
    private VanillaTabOverlayTracker tracker;
    private PacketHelper packetHelper;
    private HandlerQueue contentOperationModeHandlerQueue = new HandlerQueue(new NoOpOperationModeHandler());
    private HandlerQueue headerAndFooterOperationModeHandlerQueue = new HandlerQueue(new NoOpOperationModeHandler());
    private volatile boolean dirtyFlag = false;

    SafeTabOverlayHandler(Player player, PacketHelper packetHelper) {
        this.player = player;
        this.tracker = new VanillaTabOverlayTracker(packetHelper);
        this.packetHelper = packetHelper;
    }

    void setDirtyFlag() {
        this.dirtyFlag = true;
    }

    boolean onPacketSending(ChannelHandlerContext ctx, PacketContainer packet) {
        this.tracker.onPacketSending(packet, ctx);
        return this.getContentHandler().onPacketSending(ctx, packet) & this.getHeaderAndFooterHandler().onPacketSending(ctx, packet);
    }

    void onPacketSent(ChannelHandlerContext ctx, PacketContainer packet) {
        this.tracker.onPacketSent(ctx, packet);
    }

    void networkTick(ChannelHandlerContext ctx) {
        if (this.dirtyFlag) {
            this.dirtyFlag = false;
            this.contentOperationModeHandlerQueue.networkTick(ctx);
            this.headerAndFooterOperationModeHandlerQueue.networkTick(ctx);
            this.getContentHandler().networkTick(ctx);
            this.getHeaderAndFooterHandler().networkTick(ctx);
        }
    }

    private AbstractOperationModeHandler<?> getContentHandler() {
        return this.contentOperationModeHandlerQueue.getActiveHandler();
    }

    @Override
    public <R> R enterContentOperationMode(ContentOperationMode<R> operationMode) {
        AbstractOperationModeHandler newHandler;
        if (operationMode == ContentOperationMode.PASS_TROUGH) {
            newHandler = new ContentPassthroughOperationModeHandler(this.tracker);
        } else if (operationMode == ContentOperationMode.RECTANGULAR) {
            newHandler = new RectangularOperationModeHandler(this, this.tracker, this.player.getUniqueId(), this.packetHelper);
        } else if (operationMode == ContentOperationMode.SIMPLE) {
            newHandler = new SimpleOperationModeHandler(this, this.tracker, this.player.getUniqueId(), this.packetHelper);
        } else {
            throw new UnsupportedOperationException("Unsupported Operation mode " + operationMode.getName());
        }
        this.contentOperationModeHandlerQueue.addHandlerToQueue(newHandler);
        return (R)Unchecked.cast(((AbstractOperationModeHandler)newHandler).getRepresentation());
    }

    private AbstractOperationModeHandler<?> getHeaderAndFooterHandler() {
        return this.headerAndFooterOperationModeHandlerQueue.getActiveHandler();
    }

    @Override
    public <R> R enterHeaderAndFooterOperationMode(HeaderAndFooterOperationMode<R> operationMode) {
        AbstractOperationModeHandler newHandler;
        if (operationMode == HeaderAndFooterOperationMode.PASS_TROUGH) {
            newHandler = new HeaderAndFooterPassthroughOperationModeHandler(this.tracker);
        } else if (operationMode == HeaderAndFooterOperationMode.CUSTOM) {
            newHandler = new CustomHeaderAndFooterOperationModeHandler(this);
        } else {
            throw new UnsupportedOperationException("Unsupported Operation mode " + operationMode.getName());
        }
        this.headerAndFooterOperationModeHandlerQueue.addHandlerToQueue(newHandler);
        return (R)Unchecked.cast(newHandler.getRepresentation());
    }
}

