/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.handler.safe;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.CustomContentOperationModeHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.PacketHelper;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.SafeTabOverlayHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.VanillaTabOverlayTracker;
import de.codecrafter47.taboverlay.bukkit.internal.util.BitSet;
import de.codecrafter47.taboverlay.handler.RectangularTabOverlay;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class RectangularOperationModeHandler
extends CustomContentOperationModeHandler<Representation> {
    private static final ImmutableMap<RectangularTabOverlay.Dimension, BitSet> DIMENSION_TO_USED_SLOTS;

    private static int index(int column, int row) {
        return column * 20 + row;
    }

    RectangularOperationModeHandler(SafeTabOverlayHandler handler, VanillaTabOverlayTracker tracker, UUID viewerUuid, PacketHelper packetHelper) {
        super(handler, tracker, viewerUuid, packetHelper);
    }

    @Override
    Representation createRepresentation() {
        return new Representation();
    }

    @Override
    void updateSize() {
        Representation tabOverlay = (Representation)this.representation;
        RectangularTabOverlay.Dimension size = tabOverlay.getSize();
        int vanillaTabListSize = this.freePlayers.size() + this.playerUuidToSlotMap.size();
        if (size.getSize() < vanillaTabListSize && size.getSize() != 80) {
            for (RectangularTabOverlay.Dimension dimension : tabOverlay.getSupportedSizes()) {
                if (dimension.getColumns() < tabOverlay.getSize().getColumns() || dimension.getRows() < tabOverlay.getSize().getRows()) continue;
                if (size.getSize() < vanillaTabListSize && size.getSize() != 80) {
                    size = dimension;
                    continue;
                }
                if (size.getSize() <= dimension.getSize() || dimension.getSize() <= vanillaTabListSize) continue;
                size = dimension;
            }
            this.canShrink = true;
        } else {
            this.canShrink = false;
        }
        BitSet newUsedSlots = (BitSet)DIMENSION_TO_USED_SLOTS.get((Object)size);
        this.dirtySlots.orXor(this.usedSlots, newUsedSlots);
        this.usedSlots = newUsedSlots;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int columns = 1; columns <= 4; ++columns) {
            for (int rows = 0; rows <= 20; ++rows) {
                if (columns != 1 && rows != 0 && columns * rows <= (columns - 1) * 20) continue;
                BitSet usedSlots = new BitSet(80);
                for (int column = 0; column < columns; ++column) {
                    for (int row = 0; row < rows; ++row) {
                        usedSlots.set(RectangularOperationModeHandler.index(column, row));
                    }
                }
                builder.put((Object)new RectangularTabOverlay.Dimension(columns, rows), (Object)usedSlots);
            }
        }
        DIMENSION_TO_USED_SLOTS = builder.build();
    }

    class Representation
    extends CustomContentOperationModeHandler.Representation
    implements RectangularTabOverlay {
        @Nonnull
        private RectangularTabOverlay.Dimension size;

        private Representation() {
            super(RectangularOperationModeHandler.this);
            Optional<RectangularTabOverlay.Dimension> dimensionZero = this.getSupportedSizes().stream().filter(size -> size.getSize() == 0).findAny();
            if (!dimensionZero.isPresent()) {
                throw new AssertionError();
            }
            this.size = dimensionZero.get();
        }

        @Override
        @Nonnull
        public RectangularTabOverlay.Dimension getSize() {
            return this.size;
        }

        @Override
        public Collection<RectangularTabOverlay.Dimension> getSupportedSizes() {
            return DIMENSION_TO_USED_SLOTS.keySet();
        }

        @Override
        public void setSize(@Nonnull RectangularTabOverlay.Dimension size) {
            if (!this.getSupportedSizes().contains(size)) {
                throw new IllegalArgumentException("Unsupported size " + size);
            }
            if (this.isValid() && !this.size.equals(size)) {
                BitSet oldUsedSlots = (BitSet)DIMENSION_TO_USED_SLOTS.get((Object)this.size);
                BitSet newUsedSlots = (BitSet)DIMENSION_TO_USED_SLOTS.get((Object)size);
                BitSet diff = new BitSet(80);
                diff.orXor(oldUsedSlots, newUsedSlots);
                int index = diff.nextSetBit(0);
                while (index >= 0) {
                    this.uuid[index] = null;
                    this.icon[index] = Icon.DEFAULT_STEVE;
                    this.text[index] = "{\"text\":\"\"}";
                    this.ping[index] = 0;
                    index = diff.nextSetBit(index + 1);
                }
                this.size = size;
                this.dirtyFlagSize = true;
                this.scheduleUpdateIfNotInBatch();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSlot(int column, int row, @Nullable UUID uuid, @Nonnull Icon icon, @Nonnull String text, int ping) {
            if (this.isValid()) {
                Preconditions.checkElementIndex((int)column, (int)this.size.getColumns(), (String)"column");
                Preconditions.checkElementIndex((int)row, (int)this.size.getRows(), (String)"row");
                this.beginBatchModification();
                try {
                    int index = RectangularOperationModeHandler.index(column, row);
                    this.setUuidInternal(index, uuid);
                    this.setIconInternal(index, icon);
                    this.setTextInternal(index, text);
                    this.setPingInternal(index, ping);
                }
                finally {
                    this.completeBatchModification();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSlot(int column, int row, @Nonnull Icon icon, @Nonnull String text, int ping) {
            if (this.isValid()) {
                Preconditions.checkElementIndex((int)column, (int)this.size.getColumns(), (String)"column");
                Preconditions.checkElementIndex((int)row, (int)this.size.getRows(), (String)"row");
                this.beginBatchModification();
                try {
                    int index = RectangularOperationModeHandler.index(column, row);
                    this.setUuidInternal(index, null);
                    this.setIconInternal(index, icon);
                    this.setTextInternal(index, text);
                    this.setPingInternal(index, ping);
                }
                finally {
                    this.completeBatchModification();
                }
            }
        }

        @Override
        public void setUuid(int column, int row, @Nullable UUID uuid) {
            if (this.isValid()) {
                Preconditions.checkElementIndex((int)column, (int)this.size.getColumns(), (String)"column");
                Preconditions.checkElementIndex((int)row, (int)this.size.getRows(), (String)"row");
                this.setUuidInternal(RectangularOperationModeHandler.index(column, row), uuid);
            }
        }

        @Override
        public void setIcon(int column, int row, @Nonnull Icon icon) {
            if (this.isValid()) {
                Preconditions.checkElementIndex((int)column, (int)this.size.getColumns(), (String)"column");
                Preconditions.checkElementIndex((int)row, (int)this.size.getRows(), (String)"row");
                this.setIconInternal(RectangularOperationModeHandler.index(column, row), icon);
            }
        }

        @Override
        public void setText(int column, int row, @Nonnull String text) {
            if (this.isValid()) {
                Preconditions.checkElementIndex((int)column, (int)this.size.getColumns(), (String)"column");
                Preconditions.checkElementIndex((int)row, (int)this.size.getRows(), (String)"row");
                this.setTextInternal(RectangularOperationModeHandler.index(column, row), text);
            }
        }

        @Override
        public void setPing(int column, int row, int ping) {
            if (this.isValid()) {
                Preconditions.checkElementIndex((int)column, (int)this.size.getColumns(), (String)"column");
                Preconditions.checkElementIndex((int)row, (int)this.size.getRows(), (String)"row");
                this.setPingInternal(RectangularOperationModeHandler.index(column, row), ping);
            }
        }
    }
}

