/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.handler.safe;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.PacketHelper;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.SafeTabOverlayHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.VanillaTabOverlayTracker;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;

class PacketHelper1_13
implements PacketHelper {
    PacketHelper1_13() {
    }

    @Override
    public PacketContainer createTeam(String teamName, Set<String> players) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.SCOREBOARD_TEAM);
        packet.getStrings().write(0, (Object)teamName);
        packet.getIntegers().write(0, (Object)0);
        packet.getChatComponents().write(0, (Object)SafeTabOverlayHandler.CHAT_COMPONENT_EMPTY);
        packet.getChatComponents().write(1, (Object)SafeTabOverlayHandler.CHAT_COMPONENT_EMPTY);
        packet.getChatComponents().write(2, (Object)SafeTabOverlayHandler.CHAT_COMPONENT_EMPTY);
        packet.getStrings().write(1, (Object)"always");
        packet.getStrings().write(2, (Object)"always");
        packet.getEnumModifier(ChatColor.class, 6).write(0, (Object)ChatColor.RESET);
        packet.getIntegers().write(1, (Object)1);
        packet.getSpecificModifier(Collection.class).write(0, players);
        return packet;
    }

    @Override
    public PacketContainer removeTeam(String teamName) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.SCOREBOARD_TEAM);
        packet.getStrings().write(0, (Object)teamName);
        packet.getIntegers().write(0, (Object)1);
        return packet;
    }

    @Override
    public PacketContainer addPlayerToTeam(String teamName, String player) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.SCOREBOARD_TEAM);
        packet.getStrings().write(0, (Object)teamName);
        packet.getIntegers().write(0, (Object)3);
        packet.getSpecificModifier(Collection.class).write(0, Collections.singleton(player));
        return packet;
    }

    @Override
    public PacketContainer removePlayerFromTeam(String teamName, String player) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.SCOREBOARD_TEAM);
        packet.getStrings().write(0, (Object)teamName);
        packet.getIntegers().write(0, (Object)4);
        packet.getSpecificModifier(Collection.class).write(0, Collections.singleton(player));
        return packet;
    }

    @Override
    public PacketContainer updateTeam(String name, PacketHelper.TeamProperties properties) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.SCOREBOARD_TEAM);
        packet.getStrings().write(0, (Object)name);
        packet.getIntegers().write(0, (Object)2);
        properties.applyTo(packet);
        return packet;
    }

    @Override
    public PacketContainer updateTeamWithDefaults(String name) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.SCOREBOARD_TEAM);
        packet.getStrings().write(0, (Object)name);
        packet.getIntegers().write(0, (Object)2);
        packet.getChatComponents().write(0, (Object)SafeTabOverlayHandler.CHAT_COMPONENT_EMPTY);
        packet.getChatComponents().write(1, (Object)SafeTabOverlayHandler.CHAT_COMPONENT_EMPTY);
        packet.getChatComponents().write(2, (Object)SafeTabOverlayHandler.CHAT_COMPONENT_EMPTY);
        packet.getStrings().write(1, (Object)"always");
        packet.getStrings().write(2, (Object)"always");
        packet.getEnumModifier(ChatColor.class, 6).write(0, (Object)ChatColor.RESET);
        packet.getIntegers().write(1, (Object)1);
        return packet;
    }

    @Override
    public PacketHelper.TeamProperties getTeamProperties(PacketContainer packet) {
        final WrappedChatComponent display = (WrappedChatComponent)packet.getChatComponents().read(0);
        final WrappedChatComponent prefix = (WrappedChatComponent)packet.getChatComponents().read(1);
        final WrappedChatComponent suffix = (WrappedChatComponent)packet.getChatComponents().read(2);
        final String nameTagVisibility = (String)packet.getStrings().read(1);
        final String collisionRule = (String)packet.getStrings().read(2);
        final ChatColor color = (ChatColor)packet.getEnumModifier(ChatColor.class, 6).read(0);
        final Integer friendlyFire = (Integer)packet.getIntegers().read(1);
        return new PacketHelper.TeamProperties(){

            @Override
            public void applyTo(PacketContainer packet) {
                packet.getChatComponents().write(0, (Object)display);
                packet.getChatComponents().write(1, (Object)prefix);
                packet.getChatComponents().write(2, (Object)suffix);
                packet.getStrings().write(1, (Object)nameTagVisibility);
                packet.getStrings().write(2, (Object)collisionRule);
                packet.getEnumModifier(ChatColor.class, 6).write(0, (Object)color);
                packet.getIntegers().write(1, (Object)friendlyFire);
            }
        };
    }

    @Override
    public PacketHelper.TeamMode getTeamMode(PacketContainer packet) {
        Integer mode = (Integer)packet.getIntegers().read(0);
        switch (mode) {
            case 0: {
                return PacketHelper.TeamMode.CREATE;
            }
            case 1: {
                return PacketHelper.TeamMode.REMOVE;
            }
            case 2: {
                return PacketHelper.TeamMode.UPDATE;
            }
            case 3: {
                return PacketHelper.TeamMode.ADD_PLAYERS;
            }
            case 4: {
                return PacketHelper.TeamMode.REMOVE_PLAYERS;
            }
        }
        throw new AssertionError((Object)("Illegal team mode " + mode));
    }

    @Override
    public Collection<String> getTeamPlayers(PacketContainer packet) {
        return (Collection)packet.getSpecificModifier(Collection.class).read(0);
    }

    @Override
    public void setTeamPlayers(PacketContainer packet, Set<String> players) {
        packet.getSpecificModifier(Collection.class).write(0, players);
    }

    @Override
    public String getTeamName(PacketContainer packet) {
        return (String)packet.getStrings().read(0);
    }

    @Override
    public PacketContainer addPlayerListEntry(UUID uuid, String name, WrappedChatComponent displayName, int latency) {
        WrappedGameProfile gameProfile = new WrappedGameProfile(uuid, name);
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
        packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
        packet.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(gameProfile, latency, EnumWrappers.NativeGameMode.SURVIVAL, displayName)));
        return packet;
    }

    @Override
    public PacketContainer addPlayerListEntry(UUID uuid, String name, WrappedSignedProperty textureProperty, WrappedChatComponent displayName, int latency) {
        WrappedGameProfile gameProfile = new WrappedGameProfile(uuid, name);
        gameProfile.getProperties().put((Object)textureProperty.getName(), (Object)textureProperty);
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
        packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
        packet.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(gameProfile, latency, EnumWrappers.NativeGameMode.SURVIVAL, displayName)));
        return packet;
    }

    @Override
    public PacketContainer addPlayerListEntry(VanillaTabOverlayTracker.PlayerListEntry entry, WrappedChatComponent displayName, int latency, EnumWrappers.NativeGameMode gameMode) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
        packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
        packet.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(entry.profile, latency, gameMode, displayName)));
        return packet;
    }

    @Override
    public PacketContainer removePlayerListEntry(UUID uuid) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
        packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
        packet.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(new WrappedGameProfile(uuid, "dummy"), 0, EnumWrappers.NativeGameMode.NOT_SET, null)));
        return packet;
    }

    @Override
    public PacketContainer updateDisplayName(UUID uuid, WrappedChatComponent displayName) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
        packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME);
        packet.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(new WrappedGameProfile(uuid, "dummy"), 0, EnumWrappers.NativeGameMode.NOT_SET, displayName)));
        return packet;
    }

    @Override
    public PacketContainer updateLatency(UUID uuid, int latency) {
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
        packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.UPDATE_LATENCY);
        packet.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(new WrappedGameProfile(uuid, "dummy"), latency, EnumWrappers.NativeGameMode.NOT_SET, null)));
        return packet;
    }
}

