/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.handler.safe;

import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.AbstractOperationModeHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

final class HandlerQueue {
    private final Queue<AbstractOperationModeHandler<?>> nextActiveHandlerQueue = new ConcurrentLinkedQueue();
    private AbstractOperationModeHandler<?> activeHandler;

    HandlerQueue(AbstractOperationModeHandler<?> activeHandler) {
        this.activeHandler = activeHandler;
    }

    void addHandlerToQueue(AbstractOperationModeHandler<?> handler) {
        this.nextActiveHandlerQueue.add(handler);
    }

    void networkTick(ChannelHandlerContext ctx) {
        AbstractOperationModeHandler<?> handler;
        while (null != (handler = this.nextActiveHandlerQueue.poll())) {
            this.activeHandler.onDeactivated(ctx);
            handler.onActivated(this.activeHandler, ctx);
            this.activeHandler = handler;
        }
    }

    public AbstractOperationModeHandler<?> getActiveHandler() {
        return this.activeHandler;
    }
}

