/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.handler.safe;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.AbstractOperationModeHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.SafeTabOverlayHandler;
import de.codecrafter47.taboverlay.config.misc.ChatFormat;
import de.codecrafter47.taboverlay.handler.HeaderAndFooterHandle;
import io.netty.channel.ChannelHandlerContext;
import java.util.Objects;
import javax.annotation.Nullable;

final class CustomHeaderAndFooterOperationModeHandler
extends AbstractOperationModeHandler<HeaderAndFooterHandle> {
    private SafeTabOverlayHandler safeTabOverlayHandler;
    private Representation representation = new Representation();
    private volatile boolean dirty;

    CustomHeaderAndFooterOperationModeHandler(SafeTabOverlayHandler safeTabOverlayHandler) {
        this.safeTabOverlayHandler = safeTabOverlayHandler;
    }

    @Override
    HeaderAndFooterHandle getRepresentation() {
        return this.representation;
    }

    @Override
    boolean onPacketSending(ChannelHandlerContext ctx, PacketContainer packet) {
        return packet.getType() != PacketType.Play.Server.PLAYER_LIST_HEADER_FOOTER;
    }

    @Override
    void onDeactivated(ChannelHandlerContext ctx) {
        this.representation.valid = false;
        super.onDeactivated(ctx);
    }

    @Override
    void networkTick(ChannelHandlerContext ctx) {
        if (this.dirty) {
            this.dirty = false;
            PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_LIST_HEADER_FOOTER);
            packet.getChatComponents().write(0, (Object)this.representation.header);
            packet.getChatComponents().write(1, (Object)this.representation.footer);
            ctx.write(packet.getHandle(), ctx.newPromise());
        }
    }

    private void markDirty() {
        this.dirty = true;
        this.safeTabOverlayHandler.setDirtyFlag();
    }

    class Representation
    implements HeaderAndFooterHandle {
        boolean valid = true;
        WrappedChatComponent header = SafeTabOverlayHandler.CHAT_COMPONENT_EMPTY;
        WrappedChatComponent footer = SafeTabOverlayHandler.CHAT_COMPONENT_EMPTY;

        Representation() {
        }

        @Override
        public void setHeaderFooter(@Nullable String header, @Nullable String footer) {
            WrappedChatComponent footerComponent;
            WrappedChatComponent headerComponent = header != null ? WrappedChatComponent.fromJson((String)ChatFormat.formattedTextToJson(header)) : SafeTabOverlayHandler.CHAT_COMPONENT_EMPTY;
            WrappedChatComponent wrappedChatComponent = footerComponent = footer != null ? WrappedChatComponent.fromJson((String)ChatFormat.formattedTextToJson(footer)) : SafeTabOverlayHandler.CHAT_COMPONENT_EMPTY;
            if (!Objects.equals(this.header, headerComponent) || !Objects.equals(this.footer, footerComponent)) {
                this.header = headerComponent;
                this.footer = footerComponent;
                CustomHeaderAndFooterOperationModeHandler.this.markDirty();
            }
        }

        @Override
        public void setHeader(@Nullable String header) {
            WrappedChatComponent headerComponent;
            WrappedChatComponent wrappedChatComponent = headerComponent = header != null ? WrappedChatComponent.fromJson((String)ChatFormat.formattedTextToJson(header)) : SafeTabOverlayHandler.CHAT_COMPONENT_EMPTY;
            if (!Objects.equals(this.header, headerComponent)) {
                this.header = headerComponent;
                CustomHeaderAndFooterOperationModeHandler.this.markDirty();
            }
        }

        @Override
        public void setFooter(@Nullable String footer) {
            WrappedChatComponent footerComponent;
            WrappedChatComponent wrappedChatComponent = footerComponent = footer != null ? WrappedChatComponent.fromJson((String)ChatFormat.formattedTextToJson(footer)) : SafeTabOverlayHandler.CHAT_COMPONENT_EMPTY;
            if (!Objects.equals(this.footer, footerComponent)) {
                this.footer = footerComponent;
                CustomHeaderAndFooterOperationModeHandler.this.markDirty();
            }
        }

        @Override
        public void beginBatchModification() {
        }

        @Override
        public void completeBatchModification() {
        }

        @Override
        public boolean isValid() {
            return this.valid;
        }
    }
}

