/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.handler.safe;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.ProfileProperty;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.AbstractOperationModeHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.Constants;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.PacketHelper;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.SafeTabOverlayHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.TeamManager;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.VanillaTabOverlayTracker;
import de.codecrafter47.taboverlay.bukkit.internal.util.BitSet;
import de.codecrafter47.taboverlay.bukkit.internal.util.ConcurrentBitSet;
import de.codecrafter47.taboverlay.config.misc.ChatFormat;
import de.codecrafter47.taboverlay.handler.TabOverlayHandle;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class CustomContentOperationModeHandler<R extends Representation>
extends AbstractOperationModeHandler<R>
implements VanillaTabOverlayTracker.PlayerListEventListener {
    private SafeTabOverlayHandler handler;
    final R representation;
    private volatile boolean dirty = false;
    private PacketHelper packetHelper;
    private final VanillaTabOverlayTracker tracker;
    private final TeamManager teamManager;
    private final UUID viewerUuid;
    @Nonnull
    BitSet usedSlots;
    BitSet dirtySlots;
    private boolean using80Slots;
    private int usedSlotsCount;
    private final SlotState[] slotState;
    private final UUID[] slotUuid;
    private final String[] slotUsername;
    private boolean viewerIsSpectator = false;
    int highestUsedSlotIndex;
    final Map<UUID, Integer> playerUuidToSlotMap;
    final Set<UUID> freePlayers;
    boolean canShrink = false;

    CustomContentOperationModeHandler(SafeTabOverlayHandler handler, VanillaTabOverlayTracker tracker, UUID viewerUuid, PacketHelper packetHelper) {
        this.handler = handler;
        this.tracker = tracker;
        this.viewerUuid = viewerUuid;
        this.representation = this.createRepresentation();
        this.teamManager = new TeamManager(tracker, packetHelper);
        this.dirtySlots = new BitSet(80);
        this.usedSlots = new BitSet(80);
        this.usedSlotsCount = 0;
        this.using80Slots = false;
        this.slotState = new SlotState[80];
        Arrays.fill((Object[])this.slotState, (Object)SlotState.UNUSED);
        this.slotUuid = new UUID[80];
        this.slotUsername = new String[80];
        this.highestUsedSlotIndex = -1;
        this.playerUuidToSlotMap = new HashMap<UUID, Integer>();
        this.freePlayers = new HashSet<UUID>();
        this.packetHelper = packetHelper;
    }

    @Override
    R getRepresentation() {
        return this.representation;
    }

    abstract R createRepresentation();

    abstract void updateSize();

    @Override
    boolean onPacketSending(ChannelHandlerContext ctx, PacketContainer packet) {
        PacketType type = packet.getType();
        if (type == PacketType.Play.Server.SCOREBOARD_TEAM) {
            this.teamManager.onTeamPacket(packet);
        } else if (type == PacketType.Play.Server.PLAYER_INFO) {
            List list = (List)packet.getPlayerInfoDataLists().read(0);
            List prunedList = list.stream().filter(entry -> entry.getProfile().getUUID().version() == 2).collect(Collectors.toList());
            if (prunedList.isEmpty()) {
                return false;
            }
            packet.getPlayerInfoDataLists().write(0, prunedList);
        }
        return true;
    }

    @Override
    void onActivated(AbstractOperationModeHandler<?> previous, ChannelHandlerContext ctx) {
        super.onActivated(previous, ctx);
        this.teamManager.activate(ctx);
        List list = this.tracker.getPlayerListEntries().stream().filter(entry -> entry.profile.getUUID().version() != 2).filter(entry -> !entry.profile.getUUID().equals(this.viewerUuid)).map(entry -> new PlayerInfoData(entry.profile, 0, EnumWrappers.NativeGameMode.SURVIVAL, null)).collect(Collectors.toList());
        PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
        packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.UPDATE_GAME_MODE);
        packet.getPlayerInfoDataLists().write(0, list);
        ctx.write(packet.getHandle(), ctx.newPromise());
        VanillaTabOverlayTracker.PlayerListEntry viewerEntry = this.tracker.getPlayerListEntry(this.viewerUuid);
        this.viewerIsSpectator = viewerEntry != null && viewerEntry.gameMode == EnumWrappers.NativeGameMode.SPECTATOR;
        this.freePlayers.addAll(this.tracker.getPlayerListEntries().stream().filter(entry -> entry.profile.getUUID().version() != 2).map(entry -> entry.profile.getUUID()).collect(Collectors.toList()));
        for (UUID uuid : this.freePlayers) {
            String name = this.tracker.getPlayerListEntry((UUID)uuid).profile.getName();
            this.teamManager.trackPlayer(ctx, name);
        }
        if (!this.freePlayers.isEmpty()) {
            ((Representation)this.representation).dirtyFlagSize = true;
            this.scheduleUpdate();
        }
        this.tracker.setPlayerListEventListener(this);
    }

    @Override
    void onDeactivated(ChannelHandlerContext ctx) {
        super.onDeactivated(ctx);
        for (int index = 0; index < 80; ++index) {
            if (this.slotState[index] == SlotState.UNUSED) continue;
            this.retireSlot(ctx, index);
        }
        for (UUID player : this.freePlayers) {
            VanillaTabOverlayTracker.PlayerListEntry entry = this.tracker.getPlayerListEntry(player);
            if (entry == null) {
                throw new AssertionError((Object)("No player list entry for " + player));
            }
            this.teamManager.untrackPlayer(ctx, entry.profile.getName());
        }
        this.teamManager.deactivate(ctx);
        this.tracker.setPlayerListEventListener(null);
    }

    private void checkViewerGameMode() {
        boolean viewerIsSpectator;
        VanillaTabOverlayTracker.PlayerListEntry viewerEntry = this.tracker.getPlayerListEntry(this.viewerUuid);
        boolean bl = viewerIsSpectator = viewerEntry != null && viewerEntry.gameMode == EnumWrappers.NativeGameMode.SPECTATOR;
        if (this.viewerIsSpectator != viewerIsSpectator) {
            Integer i;
            this.viewerIsSpectator = viewerIsSpectator;
            if (!this.using80Slots && this.highestUsedSlotIndex >= 0) {
                this.dirtySlots.set(this.highestUsedSlotIndex);
            }
            if (viewerIsSpectator && (i = this.playerUuidToSlotMap.get(this.viewerUuid)) != null) {
                this.dirtySlots.set(i);
            }
            this.scheduleUpdate();
        }
    }

    @Override
    public void onPlayerAdded(ChannelHandlerContext ctx, VanillaTabOverlayTracker.PlayerListEntry entry) {
        int vanillaTabListSize;
        UUID uuid = entry.profile.getUUID();
        if (uuid.version() != 2 && !this.freePlayers.contains(uuid) && !this.playerUuidToSlotMap.containsKey(uuid)) {
            PacketContainer packet = this.packetHelper.addPlayerListEntry(entry, null, 0, uuid.equals(this.viewerUuid) ? entry.gameMode : EnumWrappers.NativeGameMode.SURVIVAL);
            ctx.write(packet.getHandle(), ctx.newPromise());
            this.freePlayers.add(uuid);
            this.teamManager.trackPlayer(ctx, entry.profile.getName());
        }
        if (uuid.equals(this.viewerUuid)) {
            this.checkViewerGameMode();
        }
        if (this.usedSlotsCount < (vanillaTabListSize = this.freePlayers.size() + this.playerUuidToSlotMap.size()) && !this.using80Slots) {
            ((Representation)this.representation).dirtyFlagSize = true;
        }
        this.scheduleUpdate();
    }

    @Override
    public void onPlayerRemoved(ChannelHandlerContext ctx, VanillaTabOverlayTracker.PlayerListEntry entry) {
        int vanillaTabListSize;
        UUID uuid = entry.profile.getUUID();
        String username = entry.profile.getName();
        if (uuid.version() != 2) {
            Integer index = this.playerUuidToSlotMap.get(uuid);
            if (index != null) {
                this.retireSlot(ctx, index);
                this.customSlot(ctx, index);
            }
            this.teamManager.untrackPlayer(ctx, username);
            this.freePlayers.remove(uuid);
            PacketContainer packet = this.packetHelper.removePlayerListEntry(entry.profile.getUUID());
            ctx.write(packet.getHandle(), ctx.newPromise());
        }
        if (uuid.equals(this.viewerUuid)) {
            this.checkViewerGameMode();
        }
        if (this.usedSlotsCount > (vanillaTabListSize = this.freePlayers.size() + this.playerUuidToSlotMap.size()) && this.canShrink) {
            ((Representation)this.representation).dirtyFlagSize = true;
            this.scheduleUpdate();
        }
    }

    @Override
    public void onGameModeUpdate(ChannelHandlerContext ctx, VanillaTabOverlayTracker.PlayerListEntry entry) {
        UUID uuid = entry.profile.getUUID();
        if (uuid.equals(this.viewerUuid)) {
            PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
            packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.UPDATE_GAME_MODE);
            packet.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(entry.profile, 0, entry.gameMode, null)));
            ctx.write(packet.getHandle(), ctx.newPromise());
            this.checkViewerGameMode();
        }
    }

    @Override
    void networkTick(ChannelHandlerContext ctx) {
        if (this.dirty) {
            int index;
            this.dirty = false;
            if (((Representation)this.representation).dirtyFlagSize) {
                ((Representation)this.representation).dirtyFlagSize = false;
                if (this.viewerIsSpectator && this.highestUsedSlotIndex >= 0) {
                    this.dirtySlots.set(this.highestUsedSlotIndex);
                }
                this.updateSize();
                this.highestUsedSlotIndex = this.usedSlots.previousSetBit(79);
                this.usedSlotsCount = this.usedSlots.cardinality();
                boolean bl = this.using80Slots = this.usedSlotsCount == 80;
                if (!this.using80Slots && this.viewerIsSpectator && this.highestUsedSlotIndex >= 0) {
                    this.dirtySlots.set(this.highestUsedSlotIndex);
                }
            }
            this.dirtySlots.orAndClear(((Representation)this.representation).dirtyFlagsUuid);
            if (!this.dirtySlots.isEmpty() || !this.freePlayers.isEmpty()) {
                index = this.dirtySlots.nextSetBit(0);
                while (index >= 0) {
                    Integer i;
                    UUID uuid = ((Representation)this.representation).uuid[index];
                    if (uuid != null && (i = this.playerUuidToSlotMap.get(uuid)) != null) {
                        this.dirtySlots.set(i);
                    }
                    index = this.dirtySlots.nextSetBit(index + 1);
                }
                index = this.dirtySlots.nextSetBit(0);
                while (index >= 0) {
                    if (this.usedSlots.get(index)) {
                        if (this.slotState[index] == SlotState.PLAYER && !Objects.equals(this.slotUuid[index], ((Representation)this.representation).uuid[index])) {
                            this.retireSlot(ctx, index);
                        }
                    } else if (this.slotState[index] != SlotState.UNUSED) {
                        this.retireSlot(ctx, index);
                    }
                    index = this.dirtySlots.nextSetBit(index + 1);
                }
                if (!this.using80Slots && this.viewerIsSpectator && !this.viewerUuid.equals(this.slotUuid[this.highestUsedSlotIndex])) {
                    if (this.slotState[this.highestUsedSlotIndex] != SlotState.UNUSED) {
                        this.retireSlot(ctx, this.highestUsedSlotIndex);
                    }
                    if (this.playerUuidToSlotMap.containsKey(this.viewerUuid)) {
                        this.dirtySlots.set(this.playerUuidToSlotMap.get(this.viewerUuid));
                        this.retireSlot(ctx, this.playerUuidToSlotMap.get(this.viewerUuid));
                    }
                    this.playerSlot(ctx, this.highestUsedSlotIndex, this.viewerUuid);
                }
                for (int repeat = 1; repeat > 0; --repeat) {
                    UUID uuid;
                    int index2 = this.dirtySlots.nextSetBit(0);
                    while (index2 >= 0) {
                        if (!(!this.usedSlots.get(index2) || this.slotState[index2] == SlotState.PLAYER || (uuid = ((Representation)this.representation).uuid[index2]) == null || !this.freePlayers.contains(uuid) || this.using80Slots && this.viewerIsSpectator && Objects.equals(this.viewerUuid, uuid))) {
                            this.retireSlot(ctx, index2);
                            this.playerSlot(ctx, index2, uuid);
                        }
                        index2 = this.dirtySlots.nextSetBit(index2 + 1);
                    }
                    if (this.freePlayers.isEmpty()) continue;
                    for (int slot = 0; slot < 80; ++slot) {
                        if (this.slotState[slot] != SlotState.CUSTOM || (uuid = ((Representation)this.representation).uuid[slot]) == null || !this.freePlayers.contains(uuid)) continue;
                        this.dirtySlots.set(slot);
                        repeat = 2;
                    }
                }
                index = 80;
                if (!this.using80Slots) {
                    for (UUID uuid : new ArrayList<UUID>(this.freePlayers)) {
                        index = this.usedSlots.previousSetBit(index - 1);
                        while (index >= 0) {
                            if (this.slotState[index] != SlotState.PLAYER) {
                                if (this.slotState[index] == SlotState.CUSTOM) {
                                    this.retireSlot(ctx, index);
                                }
                                this.playerSlot(ctx, index, uuid);
                                break;
                            }
                            index = this.usedSlots.previousSetBit(index - 1);
                        }
                        if (index < 0) {
                            throw new AssertionError((Object)"Not enough space on player list.");
                        }
                    }
                }
                index = this.dirtySlots.nextSetBit(0);
                while (index >= 0) {
                    if (this.usedSlots.get(index) && this.slotState[index] == SlotState.UNUSED) {
                        this.customSlot(ctx, index);
                    }
                    index = this.dirtySlots.nextSetBit(index + 1);
                }
            }
            this.dirtySlots.copyAndClear(((Representation)this.representation).dirtyFlagsIcon);
            index = this.dirtySlots.nextSetBit(0);
            while (index >= 0) {
                if (this.slotState[index] == SlotState.CUSTOM) {
                    this.customSlot(ctx, index);
                }
                index = this.dirtySlots.nextSetBit(index + 1);
            }
            this.dirtySlots.copyAndClear(((Representation)this.representation).dirtyFlagsText);
            index = this.dirtySlots.nextSetBit(0);
            while (index >= 0) {
                if (this.slotState[index] != SlotState.UNUSED) {
                    PacketContainer packet = this.packetHelper.updateDisplayName(this.slotUuid[index], WrappedChatComponent.fromJson((String)((Representation)this.representation).text[index]));
                    ctx.write(packet.getHandle(), ctx.newPromise());
                }
                index = this.dirtySlots.nextSetBit(index + 1);
            }
            this.dirtySlots.copyAndClear(((Representation)this.representation).dirtyFlagsPing);
            index = this.dirtySlots.nextSetBit(0);
            while (index >= 0) {
                if (this.slotState[index] != SlotState.UNUSED) {
                    PacketContainer packet = this.packetHelper.updateLatency(this.slotUuid[index], ((Representation)this.representation).ping[index]);
                    ctx.write(packet.getHandle(), ctx.newPromise());
                }
                index = this.dirtySlots.nextSetBit(index + 1);
            }
            this.dirtySlots.clear();
        }
    }

    private void retireSlot(ChannelHandlerContext ctx, int index) {
        switch (this.slotState[index]) {
            case PLAYER: {
                if (this.playerUuidToSlotMap.get(this.slotUuid[index]) != index) {
                    throw new AssertionError((Object)("playerUuidToSlotMap inconsistent for " + index));
                }
                this.teamManager.removePlayerFromTeam(ctx, index, this.slotUsername[index]);
                this.freePlayers.add(this.slotUuid[index]);
                break;
            }
            case CUSTOM: {
                PacketContainer packet = this.packetHelper.removePlayerListEntry(this.slotUuid[index]);
                ctx.write(packet.getHandle(), ctx.newPromise());
            }
        }
        this.playerUuidToSlotMap.remove(this.slotUuid[index], index);
        this.slotState[index] = SlotState.UNUSED;
        this.slotUuid[index] = null;
        this.slotUsername[index] = null;
    }

    private void customSlot(ChannelHandlerContext ctx, int index) {
        PacketContainer packet;
        String customSlotUsername;
        if (this.slotState[index] == SlotState.CUSTOM) {
            this.retireSlot(ctx, index);
        }
        ((Representation)this.representation).dirtyFlagsIcon.clear(index);
        ((Representation)this.representation).dirtyFlagsText.clear(index);
        ((Representation)this.representation).dirtyFlagsPing.clear(index);
        Icon icon = ((Representation)this.representation).icon[index];
        UUID customSlotUuid = icon.isAlex() ? Constants.SLOT_UUID_ALEX[index] : Constants.SLOT_UUID_STEVE[index];
        this.slotUsername[index] = customSlotUsername = Constants.SLOT_USERNAME[index];
        this.slotState[index] = SlotState.CUSTOM;
        this.slotUuid[index] = customSlotUuid;
        if (icon.hasTextureProperty()) {
            ProfileProperty iconProperty = icon.getTextureProperty();
            WrappedSignedProperty wrappedProperty = WrappedSignedProperty.fromValues((String)iconProperty.getName(), (String)iconProperty.getValue(), (String)iconProperty.getSignature());
            packet = this.packetHelper.addPlayerListEntry(customSlotUuid, customSlotUsername, wrappedProperty, WrappedChatComponent.fromJson((String)((Representation)this.representation).text[index]), ((Representation)this.representation).ping[index]);
        } else {
            packet = this.packetHelper.addPlayerListEntry(customSlotUuid, customSlotUsername, WrappedChatComponent.fromJson((String)((Representation)this.representation).text[index]), ((Representation)this.representation).ping[index]);
        }
        ctx.write(packet.getHandle(), ctx.newPromise());
    }

    private void playerSlot(ChannelHandlerContext ctx, int index, UUID uuid) {
        if (this.slotState[index] != SlotState.UNUSED) {
            throw new AssertionError((Object)("slot " + index + " is not unused"));
        }
        if (this.playerUuidToSlotMap.containsKey(uuid)) {
            throw new AssertionError((Object)("player " + uuid + " is already assigned to another slot"));
        }
        VanillaTabOverlayTracker.PlayerListEntry playerListEntry = this.tracker.getPlayerListEntry(uuid);
        if (playerListEntry == null) {
            throw new AssertionError((Object)("No player list entry for " + uuid));
        }
        String username = playerListEntry.profile.getName();
        this.teamManager.addPlayerToTeam(ctx, index, username);
        PacketContainer packet = this.packetHelper.updateDisplayName(uuid, WrappedChatComponent.fromJson((String)((Representation)this.representation).text[index]));
        ctx.write(packet.getHandle(), ctx.newPromise());
        packet = this.packetHelper.updateLatency(uuid, ((Representation)this.representation).ping[index]);
        ctx.write(packet.getHandle(), ctx.newPromise());
        this.slotState[index] = SlotState.PLAYER;
        this.slotUuid[index] = uuid;
        this.slotUsername[index] = username;
        this.playerUuidToSlotMap.put(uuid, index);
        this.freePlayers.remove(uuid);
    }

    private void scheduleUpdate() {
        this.dirty = true;
        this.handler.setDirtyFlag();
    }

    class Representation
    implements TabOverlayHandle.BatchModifiable,
    TabOverlayHandle {
        final UUID[] uuid = new UUID[80];
        final Icon[] icon = new Icon[80];
        final String[] text;
        final int[] ping;
        final AtomicInteger batchUpdateRecursionLevel;
        volatile boolean dirtyFlagSize;
        final ConcurrentBitSet dirtyFlagsUuid;
        final ConcurrentBitSet dirtyFlagsIcon;
        final ConcurrentBitSet dirtyFlagsText;
        final ConcurrentBitSet dirtyFlagsPing;

        Representation() {
            Arrays.fill(this.icon, Icon.DEFAULT_STEVE);
            this.text = new String[80];
            Arrays.fill(this.text, "{\"text\":\"\"}");
            this.ping = new int[80];
            this.batchUpdateRecursionLevel = new AtomicInteger(0);
            this.dirtyFlagSize = true;
            this.dirtyFlagsUuid = new ConcurrentBitSet(80);
            this.dirtyFlagsIcon = new ConcurrentBitSet(80);
            this.dirtyFlagsText = new ConcurrentBitSet(80);
            this.dirtyFlagsPing = new ConcurrentBitSet(80);
        }

        @Override
        public void beginBatchModification() {
            if (this.isValid() && this.batchUpdateRecursionLevel.incrementAndGet() < 0) {
                throw new AssertionError((Object)"Recursion level overflow");
            }
        }

        @Override
        public void completeBatchModification() {
            if (this.isValid()) {
                int level = this.batchUpdateRecursionLevel.decrementAndGet();
                if (level == 0) {
                    CustomContentOperationModeHandler.this.scheduleUpdate();
                } else if (level < 0) {
                    throw new AssertionError((Object)"Recursion level underflow");
                }
            }
        }

        void scheduleUpdateIfNotInBatch() {
            if (this.batchUpdateRecursionLevel.get() == 0) {
                CustomContentOperationModeHandler.this.scheduleUpdate();
            }
        }

        void setUuidInternal(int index, @Nullable UUID uuid) {
            if (!Objects.equals(uuid, this.uuid[index])) {
                this.uuid[index] = uuid;
                this.dirtyFlagsUuid.set(index);
                this.scheduleUpdateIfNotInBatch();
            }
        }

        void setIconInternal(int index, @Nonnull Icon icon) {
            if (!icon.equals(this.icon[index])) {
                this.icon[index] = icon;
                this.dirtyFlagsIcon.set(index);
                this.scheduleUpdateIfNotInBatch();
            }
        }

        void setTextInternal(int index, @Nonnull String text) {
            String jsonText = ChatFormat.formattedTextToJson(text);
            if (!jsonText.equals(this.text[index])) {
                this.text[index] = jsonText;
                this.dirtyFlagsText.set(index);
                this.scheduleUpdateIfNotInBatch();
            }
        }

        void setTextInternal(int index, @Nonnull String text, char alternateColorChar) {
            String jsonText = ChatFormat.formattedTextToJson(text);
            if (!jsonText.equals(this.text[index])) {
                this.text[index] = jsonText;
                this.dirtyFlagsText.set(index);
                this.scheduleUpdateIfNotInBatch();
            }
        }

        void setPingInternal(int index, int ping) {
            if (ping != this.ping[index]) {
                this.ping[index] = ping;
                this.dirtyFlagsPing.set(index);
                this.scheduleUpdateIfNotInBatch();
            }
        }

        @Override
        public boolean isValid() {
            return CustomContentOperationModeHandler.this.valid;
        }
    }

    private static enum SlotState {
        UNUSED,
        CUSTOM,
        PLAYER;

    }
}

