/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.handler.aggressive;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.codecrafter47.taboverlay.TabView;
import de.codecrafter47.taboverlay.bukkit.AdvancedTabOverlay;
import de.codecrafter47.taboverlay.bukkit.TabOverlayHandlerFactory;
import de.codecrafter47.taboverlay.bukkit.internal.handler.aggressive.AggressiveTabOverlayHandler;
import de.codecrafter47.taboverlay.bukkit.internal.handler.aggressive.PassthroughPriorFirstMoveHandler;
import de.codecrafter47.taboverlay.bukkit.internal.util.UnorderedPair;
import de.codecrafter47.taboverlay.bukkit.internal.util.Util;
import de.codecrafter47.taboverlay.handler.ContentOperationMode;
import de.codecrafter47.taboverlay.handler.HeaderAndFooterOperationMode;
import de.codecrafter47.taboverlay.handler.TabOverlayHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class AggressiveTabOverlayHandlerFactory
implements TabOverlayHandlerFactory,
Listener {
    private final Map<UnorderedPair<Player>, Double> lastDistance = new HashMap<UnorderedPair<Player>, Double>();
    private final AdvancedTabOverlay plugin;
    private final Map<Player, AggressiveTabOverlayHandler> tabOverlayHandlerMap = new HashMap<Player, AggressiveTabOverlayHandler>();

    public AggressiveTabOverlayHandlerFactory(AdvancedTabOverlay plugin) {
        this.plugin = plugin;
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, this::removePlayers, 2L, 2L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, this::updatePlayerTracker, 5L, 5L);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerMoved(PlayerMoveEvent event) {
        AggressiveTabOverlayHandler tabListHandler = this.tabOverlayHandlerMap.get(event.getPlayer());
        if (tabListHandler != null) {
            tabListHandler.active = true;
            if (tabListHandler.handler != null) {
                tabListHandler.handler.update();
            }
        }
    }

    private void updatePlayerTracker() {
        this.lastDistance.keySet().removeIf(it -> !((Player)it.a).isOnline() || !((Player)it.b).isOnline());
        ImmutableList playerList = ImmutableList.copyOf((Collection)Bukkit.getOnlinePlayers());
        for (int i = 1; i < playerList.size() - 1; ++i) {
            for (int j = 0; j < i - 1; ++j) {
                Player a = (Player)playerList.get(i);
                Player b = (Player)playerList.get(j);
                UnorderedPair<Player> key = new UnorderedPair<Player>(a, b);
                if (a.getWorld() != b.getWorld()) {
                    this.lastDistance.put(key, Double.POSITIVE_INFINITY);
                    continue;
                }
                double distance = a.getLocation().distance(b.getLocation());
                double lastD = this.lastDistance.getOrDefault(key, Double.POSITIVE_INFINITY);
                if (distance < 100.0) {
                    if (!(distance < lastD) || !(lastD - distance > 20.0)) continue;
                    if (a.canSee(b)) {
                        a.hidePlayer(b);
                        a.showPlayer(b);
                    }
                    if (b.canSee(a)) {
                        b.hidePlayer(a);
                        b.showPlayer(a);
                    }
                    this.lastDistance.put(key, distance);
                    continue;
                }
                this.lastDistance.put(key, Double.POSITIVE_INFINITY);
            }
        }
    }

    private void removePlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            AggressiveTabOverlayHandler playerTabOverlayHandler = this.tabOverlayHandlerMap.get(player);
            if (playerTabOverlayHandler == null) continue;
            playerTabOverlayHandler.tick();
        }
    }

    @Override
    public TabOverlayHandler create(Player player) {
        Channel channel = Util.getChannel(player);
        AggressiveTabOverlayHandler tabOverlayHandler = new AggressiveTabOverlayHandler(player);
        MyChannelHandler channelHandler = new MyChannelHandler(tabOverlayHandler);
        channel.pipeline().addBefore("packet_handler", "AdvancedTabOverlay-0", (ChannelHandler)channelHandler);
        this.tabOverlayHandlerMap.put(player, tabOverlayHandler);
        return tabOverlayHandler;
    }

    @Override
    public void onCreated(TabView tabView, Player player) {
        AggressiveTabOverlayHandler playerTabOverlayHandler = this.tabOverlayHandlerMap.get(player);
        playerTabOverlayHandler.handler = new PassthroughPriorFirstMoveHandler(playerTabOverlayHandler, tabView);
        tabView.getTabOverlayProviders().addProvider(playerTabOverlayHandler.handler);
    }

    @Override
    public void onDisable() {
        for (AggressiveTabOverlayHandler handler : this.tabOverlayHandlerMap.values()) {
            handler.enterContentOperationMode(ContentOperationMode.PASS_TROUGH);
            handler.enterHeaderAndFooterOperationMode(HeaderAndFooterOperationMode.PASS_TROUGH);
        }
    }

    private static class MyChannelHandler
    extends ChannelOutboundHandlerAdapter {
        private final AggressiveTabOverlayHandler tablistHandler;
        private static final Set<PacketType> interceptedPacketTypes = ImmutableSet.of((Object)PacketType.Play.Server.PLAYER_INFO, (Object)PacketType.Play.Server.PLAYER_LIST_HEADER_FOOTER, (Object)PacketType.Play.Server.NAMED_ENTITY_SPAWN, (Object)PacketType.Play.Server.RESPAWN, (Object)PacketType.Play.Server.POSITION, (Object)PacketType.Play.Server.SPAWN_POSITION, (Object[])new PacketType[0]);

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            PacketContainer packet = PacketContainer.fromPacket((Object)msg);
            if (interceptedPacketTypes.contains(packet.getType())) {
                if (this.tablistHandler.onPacketSending(ctx, packet)) {
                    super.write(ctx, packet.getHandle(), promise);
                }
            } else {
                super.write(ctx, msg, promise);
            }
        }

        public MyChannelHandler(AggressiveTabOverlayHandler tablistHandler) {
            this.tablistHandler = tablistHandler;
        }
    }
}

