/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.handler.aggressive;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.bukkit.internal.handler.aggressive.PassthroughPriorFirstMoveHandler;
import de.codecrafter47.taboverlay.bukkit.internal.util.Util;
import de.codecrafter47.taboverlay.config.misc.Unchecked;
import de.codecrafter47.taboverlay.handler.ContentOperationMode;
import de.codecrafter47.taboverlay.handler.HeaderAndFooterHandle;
import de.codecrafter47.taboverlay.handler.HeaderAndFooterOperationMode;
import de.codecrafter47.taboverlay.handler.RectangularTabOverlay;
import de.codecrafter47.taboverlay.handler.SimpleTabOverlay;
import de.codecrafter47.taboverlay.handler.TabOverlayHandle;
import de.codecrafter47.taboverlay.handler.TabOverlayHandler;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

class AggressiveTabOverlayHandler
implements TabOverlayHandler {
    private static final WrappedChatComponent CHAT_COMPONENT_EMPTY = WrappedChatComponent.fromJson((String)"{\"text\":\"\"}");
    private final Player player;
    boolean active = false;
    PassthroughPriorFirstMoveHandler handler = null;
    private OperationModeHandler<?> contentOperationModeHandler = new PassthroughOperationModeHandler();
    private OperationModeHandler<?> headerAndFooterOperationModeHandler = new PassthroughOperationModeHandler();
    private static final Map<Integer, RectangularTabOverlay.Dimension> SUPPORTED_DIMENSIONS;
    private static int TABLIST_PLAYER_REMOVE_DELAY;
    private static String[] fakePlayerUsernames;
    private static UUID[] fakePlayerUUIDs;
    private static Set<UUID> fakePlayerUUIDSet;

    boolean onPacketSending(ChannelHandlerContext ctx, PacketContainer packet) {
        return this.contentOperationModeHandler.onPacketSending(ctx, packet) & this.headerAndFooterOperationModeHandler.onPacketSending(ctx, packet);
    }

    void tick() {
        this.contentOperationModeHandler.tick();
        this.headerAndFooterOperationModeHandler.tick();
    }

    @Override
    public <R> R enterContentOperationMode(ContentOperationMode<R> operationMode) {
        OperationModeHandler newHandler;
        if (operationMode == ContentOperationMode.PASS_TROUGH) {
            newHandler = new PassthroughOperationModeHandler();
        } else if (operationMode == ContentOperationMode.RECTANGULAR) {
            newHandler = new FixedSizeOperationModeHandler();
        } else if (operationMode == ContentOperationMode.SIMPLE) {
            newHandler = new SimpleOperationModeHandler();
        } else {
            throw new UnsupportedOperationException("Unsupported Operation mode " + operationMode.getName());
        }
        this.contentOperationModeHandler.onDeactivated();
        newHandler.onActivated();
        this.contentOperationModeHandler = newHandler;
        return (R)Unchecked.cast(this.contentOperationModeHandler.getRepresentation());
    }

    @Override
    public <R> R enterHeaderAndFooterOperationMode(HeaderAndFooterOperationMode<R> operationMode) {
        OperationModeHandler newHandler;
        if (operationMode == HeaderAndFooterOperationMode.PASS_TROUGH) {
            newHandler = new HeaderAndFooterPassthroughOperationModeHandler();
        } else if (operationMode == HeaderAndFooterOperationMode.CUSTOM) {
            newHandler = new CustomHeaderAndFooterOperationModeHandler();
        } else {
            throw new UnsupportedOperationException("Unsupported Operation mode " + operationMode.getName());
        }
        this.headerAndFooterOperationModeHandler.onDeactivated();
        newHandler.onActivated();
        this.headerAndFooterOperationModeHandler = newHandler;
        return (R)Unchecked.cast(this.headerAndFooterOperationModeHandler.getRepresentation());
    }

    public AggressiveTabOverlayHandler(Player player) {
        this.player = player;
    }

    static {
        TABLIST_PLAYER_REMOVE_DELAY = 5;
        fakePlayerUsernames = (String[])IntStream.range(0, 80).mapToObj(n -> String.format(" Tab Slot %02d", n)).toArray(String[]::new);
        fakePlayerUUIDs = (UUID[])Arrays.stream(fakePlayerUsernames).map(name -> UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(StandardCharsets.UTF_8))).toArray(UUID[]::new);
        fakePlayerUUIDSet = ImmutableSet.copyOf((Object[])fakePlayerUUIDs);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int columns = 1; columns <= 4; ++columns) {
            int rows;
            int n2 = rows = columns == 1 ? 0 : 1;
            while (rows <= 20) {
                if (columns == 1 || rows == 0 || columns * rows > (columns - 1) * 20) {
                    builder.put((Object)(columns * rows), (Object)new RectangularTabOverlay.Dimension(columns, rows));
                }
                ++rows;
            }
        }
        SUPPORTED_DIMENSIONS = builder.build();
    }

    private abstract class OperationModeHandler<R> {
        boolean valid;

        private OperationModeHandler() {
        }

        abstract R getRepresentation();

        abstract boolean onPacketSending(ChannelHandlerContext var1, PacketContainer var2);

        void onActivated() {
            this.valid = true;
        }

        void onDeactivated() {
            this.valid = false;
        }

        void tick() {
        }
    }

    private final class PassthroughOperationModeHandler
    extends OperationModeHandler<Void> {
        private PassthroughOperationModeHandler() {
        }

        @Override
        Void getRepresentation() {
            return null;
        }

        @Override
        boolean onPacketSending(ChannelHandlerContext ctx, PacketContainer packet) {
            return true;
        }

        @Override
        void onActivated() {
            super.onActivated();
            List list = Bukkit.getOnlinePlayers().stream().map(Util::getPlayerInfoData).collect(Collectors.toList());
            PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
            packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
            packet.getPlayerInfoDataLists().write(0, list);
            ProtocolLibrary.getProtocolManager().sendServerPacket(AggressiveTabOverlayHandler.this.player, packet);
        }
    }

    private final class FixedSizeOperationModeHandler
    extends CustomOperationModeHandler<Representation> {
        private FixedSizeOperationModeHandler() {
        }

        @Override
        Representation createRepresentation() {
            return new Representation();
        }

        class Representation
        extends CustomOperationModeHandler.Representation
        implements RectangularTabOverlay {
            Representation() {
            }

            @Override
            public RectangularTabOverlay.Dimension getSize() {
                int size = FixedSizeOperationModeHandler.this.size;
                return (RectangularTabOverlay.Dimension)SUPPORTED_DIMENSIONS.get(size);
            }

            @Override
            public Collection<RectangularTabOverlay.Dimension> getSupportedSizes() {
                return SUPPORTED_DIMENSIONS.values();
            }

            @Override
            public void setSize(@Nonnull RectangularTabOverlay.Dimension size) {
                this.setSize(size.getSize());
            }

            @Override
            public void setSlot(int column, int row, UUID uuid, @Nonnull Icon icon, @Nonnull String text, int ping) {
                int index = this.getIndex(column, row);
                this.texts[index] = text;
                this.icons[index] = icon;
                this.pings[index] = ping;
                this.updateSlot(index);
            }

            private int getIndex(int column, int row) {
                int columns = (FixedSizeOperationModeHandler.this.size + 19) / 20;
                int rows = (FixedSizeOperationModeHandler.this.size + columns - 1) / columns;
                int index = column * rows + row;
                if (index < 0 || index >= FixedSizeOperationModeHandler.this.size) {
                    throw new IndexOutOfBoundsException();
                }
                return index;
            }

            @Override
            public void setUuid(int column, int row, UUID uuid) {
            }

            @Override
            public void setIcon(int column, int row, @Nonnull Icon icon) {
                int index = this.getIndex(column, row);
                this.icons[index] = icon;
                this.updateSlot(index);
            }

            @Override
            public void setText(int column, int row, @Nonnull String text) {
                int index = this.getIndex(column, row);
                this.texts[index] = text;
                this.updateSlotText(index);
            }

            @Override
            public void setPing(int column, int row, int ping) {
                int index = this.getIndex(column, row);
                this.pings[index] = ping;
                this.updateSlotPing(index);
            }
        }
    }

    private final class SimpleOperationModeHandler
    extends CustomOperationModeHandler<Representation> {
        private SimpleOperationModeHandler() {
        }

        @Override
        Representation createRepresentation() {
            return new Representation();
        }

        class Representation
        extends CustomOperationModeHandler.Representation
        implements SimpleTabOverlay {
            Representation() {
            }

            @Override
            public void setSize(int size) {
                super.setSize(size);
            }

            @Override
            public int getSize() {
                return SimpleOperationModeHandler.this.size;
            }

            @Override
            public int getMaxSize() {
                return 80;
            }

            @Override
            public void setSlot(int index, @Nullable UUID uuid, @Nonnull Icon icon, @Nonnull String text, int ping) {
                this.texts[index] = text;
                this.icons[index] = icon;
                this.pings[index] = ping;
                this.updateSlot(index);
            }

            @Override
            public void setUuid(int index, @Nullable UUID uuid) {
            }

            @Override
            public void setIcon(int index, @Nonnull Icon icon) {
                this.icons[index] = icon;
                this.updateSlot(index);
            }

            @Override
            public void setText(int index, @Nonnull String text) {
                this.texts[index] = text;
                this.updateSlotText(index);
            }

            @Override
            public void setPing(int index, int ping) {
                this.pings[index] = ping;
                this.updateSlotPing(index);
            }
        }
    }

    private final class HeaderAndFooterPassthroughOperationModeHandler
    extends OperationModeHandler<Void> {
        private HeaderAndFooterPassthroughOperationModeHandler() {
        }

        @Override
        Void getRepresentation() {
            return null;
        }

        @Override
        boolean onPacketSending(ChannelHandlerContext ctx, PacketContainer packet) {
            return true;
        }

        @Override
        void onActivated() {
            super.onActivated();
        }
    }

    private final class CustomHeaderAndFooterOperationModeHandler
    extends OperationModeHandler<HeaderAndFooterHandle> {
        Representation representation = new Representation();

        private CustomHeaderAndFooterOperationModeHandler() {
        }

        @Override
        HeaderAndFooterHandle getRepresentation() {
            return this.representation;
        }

        @Override
        boolean onPacketSending(ChannelHandlerContext ctx, PacketContainer packet) {
            return true;
        }

        @Override
        void onDeactivated() {
            this.representation.valid = false;
            super.onDeactivated();
        }

        class Representation
        implements HeaderAndFooterHandle {
            boolean valid = true;
            WrappedChatComponent header = AggressiveTabOverlayHandler.access$700();
            WrappedChatComponent footer = AggressiveTabOverlayHandler.access$700();

            Representation() {
            }

            private void updateHeaderFooter() {
                PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_LIST_HEADER_FOOTER);
                packet.getChatComponents().write(0, (Object)this.header);
                packet.getChatComponents().write(1, (Object)this.footer);
                ProtocolLibrary.getProtocolManager().sendServerPacket(AggressiveTabOverlayHandler.this.player, packet);
            }

            @Override
            public void setHeaderFooter(@Nullable String header, @Nullable String footer) {
                this.header = header != null ? WrappedChatComponent.fromText((String)header) : CHAT_COMPONENT_EMPTY;
                this.footer = footer != null ? WrappedChatComponent.fromText((String)footer) : CHAT_COMPONENT_EMPTY;
                this.updateHeaderFooter();
            }

            @Override
            public void setHeader(@Nullable String header) {
                this.header = header != null ? WrappedChatComponent.fromText((String)header) : CHAT_COMPONENT_EMPTY;
                this.updateHeaderFooter();
            }

            @Override
            public void setFooter(@Nullable String footer) {
                this.footer = footer != null ? WrappedChatComponent.fromText((String)footer) : CHAT_COMPONENT_EMPTY;
                this.updateHeaderFooter();
            }

            @Override
            public void beginBatchModification() {
            }

            @Override
            public void completeBatchModification() {
            }

            @Override
            public boolean isValid() {
                return this.valid;
            }
        }
    }

    private abstract class CustomOperationModeHandler<R extends Representation>
    extends OperationModeHandler<R> {
        final Map<UUID, Integer> removePlayers = new LinkedHashMap<UUID, Integer>();
        final R representation = this.createRepresentation();
        int size = 0;

        CustomOperationModeHandler() {
        }

        @Override
        R getRepresentation() {
            return this.representation;
        }

        abstract R createRepresentation();

        @Override
        boolean onPacketSending(ChannelHandlerContext ctx, PacketContainer packet) {
            List infoDataList;
            PacketType type = packet.getType();
            if (type == PacketType.Play.Server.NAMED_ENTITY_SPAWN) {
                UUID uuid = (UUID)packet.getSpecificModifier(UUID.class).read(0);
                this.addBackPlayerEntry(ctx, uuid);
                this.removePlayers.put(uuid, TABLIST_PLAYER_REMOVE_DELAY);
            } else if (type == PacketType.Play.Server.RESPAWN) {
                UUID uuid = AggressiveTabOverlayHandler.this.player.getUniqueId();
                this.addBackPlayerEntry(ctx, uuid);
                this.removePlayers.put(uuid, TABLIST_PLAYER_REMOVE_DELAY);
                AggressiveTabOverlayHandler.this.active = false;
                if (AggressiveTabOverlayHandler.this.handler != null) {
                    AggressiveTabOverlayHandler.this.handler.update();
                }
            } else if (type == PacketType.Play.Server.PLAYER_INFO && !(infoDataList = (List)packet.getPlayerInfoDataLists().read(0)).isEmpty() && !fakePlayerUUIDSet.contains(((PlayerInfoData)infoDataList.get(0)).getProfile().getUUID())) {
                EnumWrappers.PlayerInfoAction action = (EnumWrappers.PlayerInfoAction)packet.getPlayerInfoAction().read(0);
                if (action == EnumWrappers.PlayerInfoAction.ADD_PLAYER) {
                    for (PlayerInfoData item : infoDataList) {
                        this.removePlayers.put(item.getProfile().getUUID(), TABLIST_PLAYER_REMOVE_DELAY);
                    }
                } else if (action == EnumWrappers.PlayerInfoAction.REMOVE_PLAYER) {
                    for (PlayerInfoData item : infoDataList) {
                        this.removePlayers.remove(item.getProfile().getUUID());
                    }
                } else if (action == EnumWrappers.PlayerInfoAction.UPDATE_GAME_MODE) {
                    packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                    for (PlayerInfoData item : infoDataList) {
                        this.removePlayers.put(item.getProfile().getUUID(), TABLIST_PLAYER_REMOVE_DELAY);
                    }
                } else {
                    return false;
                }
            }
            return true;
        }

        private void addBackPlayerEntry(ChannelHandlerContext ctx, UUID uuid) {
            if (!this.removePlayers.containsKey(uuid)) {
                PacketContainer addPlayerPacket = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
                addPlayerPacket.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                Player player1 = Bukkit.getPlayer((UUID)uuid);
                addPlayerPacket.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(WrappedGameProfile.fromPlayer((Player)player1), 0, EnumWrappers.NativeGameMode.fromBukkit((GameMode)player1.getGameMode()), null)));
                ctx.write(addPlayerPacket.getHandle());
            }
        }

        @Override
        void onActivated() {
            super.onActivated();
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.removePlayers.put(p.getUniqueId(), TABLIST_PLAYER_REMOVE_DELAY);
            }
        }

        @Override
        void onDeactivated() {
            super.onDeactivated();
            if (this.size > 0) {
                List list = Arrays.stream(fakePlayerUUIDs, 0, this.size).map(uuid -> new PlayerInfoData(new WrappedGameProfile(uuid, ""), 0, EnumWrappers.NativeGameMode.SURVIVAL, null)).collect(Collectors.toList());
                PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
                packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                packet.getPlayerInfoDataLists().write(0, list);
                ProtocolLibrary.getProtocolManager().sendServerPacket(AggressiveTabOverlayHandler.this.player, packet);
                this.size = 0;
            }
            ((Representation)this.representation).valid = false;
        }

        @Override
        void tick() {
            if (AggressiveTabOverlayHandler.this.active) {
                ArrayList<PlayerInfoData> list = new ArrayList<PlayerInfoData>();
                for (Map.Entry<UUID, Integer> entry : this.removePlayers.entrySet()) {
                    entry.setValue(entry.getValue() - 1);
                    if (entry.getValue() > 0) continue;
                    list.add(new PlayerInfoData(new WrappedGameProfile(entry.getKey(), null), 0, EnumWrappers.NativeGameMode.NOT_SET, null));
                }
                this.removePlayers.values().removeIf(value -> value < 0);
                if (!list.isEmpty()) {
                    PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
                    packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                    packet.getPlayerInfoDataLists().write(0, list);
                    ProtocolLibrary.getProtocolManager().sendServerPacket(AggressiveTabOverlayHandler.this.player, packet);
                }
            }
        }

        class Representation
        implements TabOverlayHandle.BatchModifiable,
        TabOverlayHandle {
            boolean valid = true;
            Icon[] icons = new Icon[80];
            String[] texts;
            int[] pings;

            Representation() {
                Arrays.fill(this.icons, Icon.DEFAULT_STEVE);
                this.texts = new String[80];
                Arrays.fill(this.texts, "");
                this.pings = new int[80];
                Arrays.fill(this.pings, 0);
            }

            void setSize(int size) {
                if (size < CustomOperationModeHandler.this.size) {
                    List list = Arrays.stream(fakePlayerUUIDs, size, CustomOperationModeHandler.this.size).map(uuid -> new PlayerInfoData(new WrappedGameProfile(uuid, ""), 0, EnumWrappers.NativeGameMode.SURVIVAL, null)).collect(Collectors.toList());
                    PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
                    packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                    packet.getPlayerInfoDataLists().write(0, list);
                    ProtocolLibrary.getProtocolManager().sendServerPacket(AggressiveTabOverlayHandler.this.player, packet);
                    size = 0;
                }
                CustomOperationModeHandler.this.size = size;
            }

            void updateSlot(int index) {
                Icon icon = this.icons[index];
                String text = this.texts[index];
                int ping = this.pings[index];
                WrappedGameProfile profile = new WrappedGameProfile(fakePlayerUUIDs[index], fakePlayerUsernames[index]);
                if (icon.hasTextureProperty()) {
                    profile.getProperties().put((Object)"textures", (Object)new WrappedSignedProperty(icon.getTextureProperty().getName(), icon.getTextureProperty().getValue(), icon.getTextureProperty().getSignature()));
                }
                PlayerInfoData data = new PlayerInfoData(profile, ping, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)text));
                PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
                packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                packet.getPlayerInfoDataLists().write(0, Collections.singletonList(data));
                ProtocolLibrary.getProtocolManager().sendServerPacket(AggressiveTabOverlayHandler.this.player, packet);
            }

            void updateSlotText(int index) {
                String text = this.texts[index];
                WrappedGameProfile profile = new WrappedGameProfile(fakePlayerUUIDs[index], fakePlayerUsernames[index]);
                PlayerInfoData data = new PlayerInfoData(profile, 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)text));
                PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
                packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME);
                packet.getPlayerInfoDataLists().write(0, Collections.singletonList(data));
                ProtocolLibrary.getProtocolManager().sendServerPacket(AggressiveTabOverlayHandler.this.player, packet);
            }

            void updateSlotPing(int index) {
                int ping = this.pings[index];
                WrappedGameProfile profile = new WrappedGameProfile(fakePlayerUUIDs[index], fakePlayerUsernames[index]);
                PlayerInfoData data = new PlayerInfoData(profile, ping, EnumWrappers.NativeGameMode.SURVIVAL, null);
                PacketContainer packet = ProtocolLibrary.getProtocolManager().createPacket(PacketType.Play.Server.PLAYER_INFO);
                packet.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.UPDATE_LATENCY);
                packet.getPlayerInfoDataLists().write(0, Collections.singletonList(data));
                ProtocolLibrary.getProtocolManager().sendServerPacket(AggressiveTabOverlayHandler.this.player, packet);
            }

            @Override
            public void beginBatchModification() {
            }

            @Override
            public void completeBatchModification() {
            }

            @Override
            public boolean isValid() {
                return this.valid;
            }
        }
    }
}

