/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.config;

import de.codecrafter47.taboverlay.bukkit.internal.placeholders.WorldPlaceholderResolver;
import de.codecrafter47.taboverlay.bukkit.internal.template.PlayersByWorldComponentTemplate;
import de.codecrafter47.taboverlay.config.dsl.ComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.PlayerOrderConfiguration;
import de.codecrafter47.taboverlay.config.dsl.components.BasicComponentConfiguration;
import de.codecrafter47.taboverlay.config.dsl.util.ConfigValidationUtil;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedIntegerProperty;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedPropertyBase;
import de.codecrafter47.taboverlay.config.dsl.yaml.MarkedStringProperty;
import de.codecrafter47.taboverlay.config.placeholder.OtherCountPlaceholderResolver;
import de.codecrafter47.taboverlay.config.placeholder.PlayerPlaceholderResolver;
import de.codecrafter47.taboverlay.config.template.PlayerOrderTemplate;
import de.codecrafter47.taboverlay.config.template.TemplateCreationContext;
import de.codecrafter47.taboverlay.config.template.component.ComponentTemplate;
import de.codecrafter47.taboverlay.config.template.icon.PlayerIconTemplate;
import de.codecrafter47.taboverlay.config.template.ping.PlayerPingTemplate;
import javax.annotation.Nullable;

public class PlayersByWorldComponentConfiguration
extends MarkedPropertyBase
implements ComponentConfiguration {
    private PlayerOrderConfiguration playerOrder = PlayerOrderConfiguration.DEFAULT;
    private MarkedStringProperty playerSet;
    private ComponentConfiguration playerComponent = new BasicComponentConfiguration("${player name}");
    @Nullable
    private ComponentConfiguration morePlayersComponent;
    private boolean fillSlotsVertical = false;
    private MarkedIntegerProperty minSize = new MarkedIntegerProperty(0);
    private MarkedIntegerProperty maxSize = new MarkedIntegerProperty(-1);
    private MarkedIntegerProperty minSizePerWorld = new MarkedIntegerProperty(0);
    private MarkedIntegerProperty maxSizePerWorld = new MarkedIntegerProperty(-1);
    @Nullable
    private ComponentConfiguration worldHeader;
    @Nullable
    private ComponentConfiguration worldFooter;
    @Nullable
    private ComponentConfiguration worldSeparator;

    @Override
    public ComponentTemplate toTemplate(TemplateCreationContext tcc) {
        ComponentTemplate morePlayersComponentTemplate;
        if (ConfigValidationUtil.checkNotNull(tcc, "!players_by_world component", "playerSet", this.playerSet, this.getStartMark()) && !tcc.getPlayerSets().containsKey(this.playerSet.getValue())) {
            tcc.getErrorHandler().addError("No player set definition available for player set \"" + this.playerSet.getValue() + "\"", this.playerSet.getStartMark());
        }
        PlayerOrderTemplate playerOrderTemplate = PlayerOrderConfiguration.DEFAULT.toTemplate(tcc);
        if (ConfigValidationUtil.checkNotNull(tcc, "!players_by_world component", "playerOrder", this.playerOrder, this.getStartMark())) {
            playerOrderTemplate = this.playerOrder.toTemplate(tcc);
        }
        if (this.minSize.getValue() < 0) {
            tcc.getErrorHandler().addError("Failed to configure players component. MinSize is negative", this.minSize.getStartMark());
        }
        if (this.maxSize.getValue() != -1 && this.minSize.getValue() > this.maxSize.getValue()) {
            tcc.getErrorHandler().addError("Failed to configure players component. MaxSize is lower than minSize", this.maxSize.getStartMark());
        }
        if (this.minSizePerWorld.getValue() < 0) {
            tcc.getErrorHandler().addError("Failed to configure players component. MinSizePerWorld is negative", this.minSizePerWorld.getStartMark());
        }
        if (this.maxSizePerWorld.getValue() != -1 && this.minSizePerWorld.getValue() > this.maxSizePerWorld.getValue()) {
            tcc.getErrorHandler().addError("Failed to configure players component. MaxSizePerWorld is lower than minSizePerWorld", this.maxSizePerWorld.getStartMark());
        }
        TemplateCreationContext childContextS = tcc.clone();
        if (this.fillSlotsVertical) {
            childContextS.setColumns(1);
        }
        childContextS.addPlaceholderResolver(new WorldPlaceholderResolver());
        TemplateCreationContext childContextP = childContextS.clone();
        childContextP.setDefaultIcon(new PlayerIconTemplate(PlayerPlaceholderResolver.BindPoint.PLAYER, tcc.getPlayerIconDataKey()));
        childContextP.setDefaultPing(new PlayerPingTemplate(PlayerPlaceholderResolver.BindPoint.PLAYER, tcc.getPlayerPingDataKey()));
        childContextP.setPlayerAvailable(true);
        TemplateCreationContext childContextM = tcc.clone();
        if (this.fillSlotsVertical) {
            childContextM.setColumns(1);
        }
        childContextM.addPlaceholderResolver(new OtherCountPlaceholderResolver());
        ComponentTemplate playerComponentTemplate = tcc.emptyComponent();
        if (ConfigValidationUtil.checkNotNull(tcc, "!players_by_world component", "playerComponent", this.playerComponent, this.getStartMark())) {
            playerComponentTemplate = this.playerComponent.toTemplate(childContextP);
            ComponentTemplate.LayoutInfo layoutInfo = playerComponentTemplate.getLayoutInfo();
            if (!layoutInfo.isConstantSize()) {
                tcc.getErrorHandler().addError("Failed to configure !players_by_world component. Attribute playerComponent must not have variable size.", this.playerComponent.getStartMark());
            }
            if (layoutInfo.isBlockAligned()) {
                tcc.getErrorHandler().addError("Failed to configure !players_by_world component. Attribute playerComponent must not require block alignment.", this.playerComponent.getStartMark());
            }
        }
        if (this.morePlayersComponent != null) {
            morePlayersComponentTemplate = this.morePlayersComponent.toTemplate(childContextM);
            ComponentTemplate.LayoutInfo layoutInfo = morePlayersComponentTemplate.getLayoutInfo();
            if (!layoutInfo.isConstantSize()) {
                tcc.getErrorHandler().addError("Failed to configure !players_by_world component. Attribute playerComponent cannot have variable size.", this.morePlayersComponent.getStartMark());
            }
            if (layoutInfo.isBlockAligned()) {
                tcc.getErrorHandler().addError("Failed to configure !players_by_world component. Attribute playerComponent must not require block alignment.", this.morePlayersComponent.getStartMark());
            }
        } else {
            morePlayersComponentTemplate = childContextM.emptyComponent();
        }
        return PlayersByWorldComponentTemplate.builder().playerOrder(playerOrderTemplate).playerSet(tcc.getPlayerSets().get(this.playerSet.getValue())).playerComponent(playerComponentTemplate).morePlayersComponent(morePlayersComponentTemplate).worldHeader(this.worldHeader != null ? this.worldHeader.toTemplate(childContextS) : null).worldFooter(this.worldFooter != null ? this.worldFooter.toTemplate(childContextS) : null).worldSeparator(this.worldSeparator != null ? this.worldSeparator.toTemplate(tcc) : null).fillSlotsVertical(this.fillSlotsVertical).minSize(this.minSize.getValue()).maxSize(this.maxSize.getValue()).minSizePerWorld(this.minSizePerWorld.getValue()).maxSizePerWorld(this.maxSizePerWorld.getValue()).columns(tcc.getColumns().orElse(1)).defaultIcon(tcc.getDefaultIcon()).defaultText(tcc.getDefaultText()).defaultPing(tcc.getDefaultPing()).partitionFunction(tcc.getExpressionEngine().compile(childContextP, "${player world}", null)).build();
    }

    public PlayerOrderConfiguration getPlayerOrder() {
        return this.playerOrder;
    }

    public MarkedStringProperty getPlayerSet() {
        return this.playerSet;
    }

    public ComponentConfiguration getPlayerComponent() {
        return this.playerComponent;
    }

    @Nullable
    public ComponentConfiguration getMorePlayersComponent() {
        return this.morePlayersComponent;
    }

    public boolean isFillSlotsVertical() {
        return this.fillSlotsVertical;
    }

    public MarkedIntegerProperty getMinSize() {
        return this.minSize;
    }

    public MarkedIntegerProperty getMaxSize() {
        return this.maxSize;
    }

    public MarkedIntegerProperty getMinSizePerWorld() {
        return this.minSizePerWorld;
    }

    public MarkedIntegerProperty getMaxSizePerWorld() {
        return this.maxSizePerWorld;
    }

    @Nullable
    public ComponentConfiguration getWorldHeader() {
        return this.worldHeader;
    }

    @Nullable
    public ComponentConfiguration getWorldFooter() {
        return this.worldFooter;
    }

    @Nullable
    public ComponentConfiguration getWorldSeparator() {
        return this.worldSeparator;
    }

    public void setPlayerOrder(PlayerOrderConfiguration playerOrder) {
        this.playerOrder = playerOrder;
    }

    public void setPlayerSet(MarkedStringProperty playerSet) {
        this.playerSet = playerSet;
    }

    public void setPlayerComponent(ComponentConfiguration playerComponent) {
        this.playerComponent = playerComponent;
    }

    public void setMorePlayersComponent(@Nullable ComponentConfiguration morePlayersComponent) {
        this.morePlayersComponent = morePlayersComponent;
    }

    public void setFillSlotsVertical(boolean fillSlotsVertical) {
        this.fillSlotsVertical = fillSlotsVertical;
    }

    public void setMinSize(MarkedIntegerProperty minSize) {
        this.minSize = minSize;
    }

    public void setMaxSize(MarkedIntegerProperty maxSize) {
        this.maxSize = maxSize;
    }

    public void setMinSizePerWorld(MarkedIntegerProperty minSizePerWorld) {
        this.minSizePerWorld = minSizePerWorld;
    }

    public void setMaxSizePerWorld(MarkedIntegerProperty maxSizePerWorld) {
        this.maxSizePerWorld = maxSizePerWorld;
    }

    public void setWorldHeader(@Nullable ComponentConfiguration worldHeader) {
        this.worldHeader = worldHeader;
    }

    public void setWorldFooter(@Nullable ComponentConfiguration worldFooter) {
        this.worldFooter = worldFooter;
    }

    public void setWorldSeparator(@Nullable ComponentConfiguration worldSeparator) {
        this.worldSeparator = worldSeparator;
    }
}

