/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal.config;

import com.google.common.collect.ImmutableList;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConfiguration;
import de.codecrafter47.taboverlay.config.dsl.yaml.UpdateableConfig;
import de.codecrafter47.taboverlay.config.dsl.yaml.YamlUtil;
import de.codecrafter47.taboverlay.libs.snakeyaml.Yaml;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.MappingNode;
import de.codecrafter47.taboverlay.libs.snakeyaml.nodes.Tag;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class MainConfig
implements UpdateableConfig {
    public Map<String, CustomPlaceholderConfiguration> customPlaceholders = new HashMap<String, CustomPlaceholderConfiguration>();
    public boolean disableCustomTabListForSpectators = true;
    public String timeZone = TimeZone.getDefault().getID();
    public transient boolean needWrite = false;

    @Override
    public void update(MappingNode node) {
        ImmutableList outdatedConfigOptions = ImmutableList.of();
        for (String option : outdatedConfigOptions) {
            this.needWrite |= YamlUtil.contains(node, option);
            YamlUtil.remove(node, option);
        }
        ImmutableList newConfigOptions = ImmutableList.of((Object)"customPlaceholders", (Object)"disableCustomTabListForSpectators", (Object)"timeZone");
        for (String option : newConfigOptions) {
            this.needWrite |= !YamlUtil.contains(node, option);
        }
    }

    public void write(Writer writer, Yaml yaml) throws IOException {
        writer.write(yaml.dumpAs(this, Tag.MAP, null));
        writer.close();
    }
}

