/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal;

import de.codecrafter47.taboverlay.bukkit.AdvancedTabOverlay;
import de.codecrafter47.taboverlay.bukkit.internal.BukkitPlayer;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.player.PlayerProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import lombok.NonNull;

public class PlayerManager
implements PlayerProvider {
    private final AdvancedTabOverlay plugin;
    private final Map<UUID, BukkitPlayer> playerMap = new HashMap<UUID, BukkitPlayer>();
    private final Set<PlayerProvider.Listener> listenerSet = new HashSet<PlayerProvider.Listener>();

    public PlayerManager(AdvancedTabOverlay plugin) {
        this.plugin = plugin;
    }

    public Player onPlayerJoin(org.bukkit.entity.Player bukkitPlayer) {
        BukkitPlayer player = new BukkitPlayer(bukkitPlayer);
        this.plugin.getTabEventQueue().execute(() -> {
            this.playerMap.put(bukkitPlayer.getUniqueId(), player);
            for (PlayerProvider.Listener listener : this.listenerSet) {
                try {
                    listener.onPlayerAdded(player);
                }
                catch (Throwable th) {
                    this.plugin.getLogger().log(Level.SEVERE, "Error invoking player login listener", th);
                }
            }
        });
        return player;
    }

    public void onPlayerDisconnect(org.bukkit.entity.Player bukkitPlayer) {
        this.plugin.getTabEventQueue().execute(() -> {
            BukkitPlayer player = this.playerMap.remove(bukkitPlayer.getUniqueId());
            if (player != null) {
                for (PlayerProvider.Listener listener : this.listenerSet) {
                    try {
                        listener.onPlayerRemoved(player);
                    }
                    catch (Throwable th) {
                        this.plugin.getLogger().log(Level.SEVERE, "Error invoking player disconnect listener", th);
                    }
                }
            } else {
                throw new IllegalStateException("Player " + bukkitPlayer + " not contained in playerMap");
            }
            player.onDisconnect();
        });
    }

    @Override
    public Collection<? extends Player> getPlayers() {
        return this.playerMap.values();
    }

    @Override
    public void registerListener(@Nonnull @NonNull PlayerProvider.Listener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.listenerSet.add(listener);
    }

    @Override
    public void unregisterListener(@Nonnull @NonNull PlayerProvider.Listener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.listenerSet.remove(listener);
    }

    @Nonnull
    @NonNull
    public Player getPlayer(@Nonnull @NonNull org.bukkit.entity.Player player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return Objects.requireNonNull(this.playerMap.get(player.getUniqueId()));
    }
}

