/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal;

import com.google.common.collect.Sets;
import de.codecrafter47.data.api.DataAccess;
import de.codecrafter47.data.api.DataCache;
import de.codecrafter47.data.api.DataKey;
import de.codecrafter47.data.api.JoinedDataAccess;
import de.codecrafter47.data.bukkit.PlayerDataAccess;
import de.codecrafter47.taboverlay.bukkit.AdvancedTabOverlay;
import de.codecrafter47.taboverlay.bukkit.internal.ATODataAccess;
import de.codecrafter47.taboverlay.bukkit.internal.PAPIDataAccess;
import de.codecrafter47.taboverlay.config.misc.Unchecked;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DataManager {
    private final AdvancedTabOverlay plugin;
    private final Set<PlayerDataHolder> dataHolderSet = Sets.newConcurrentHashSet();
    private DataAccess<Player> playerDataAccess;

    public DataManager(AdvancedTabOverlay plugin) {
        this.plugin = plugin;
    }

    public void enable() {
        boolean hasPlaceholderAPI = this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
        this.playerDataAccess = hasPlaceholderAPI ? JoinedDataAccess.of(new PlayerDataAccess((Plugin)this.plugin), new ATODataAccess(this.plugin.getLogger(), (Plugin)this.plugin), new PAPIDataAccess(this.plugin.getLogger(), (Plugin)this.plugin)) : JoinedDataAccess.of(new PlayerDataAccess((Plugin)this.plugin), new ATODataAccess(this.plugin.getLogger(), (Plugin)this.plugin));
        this.plugin.getAsyncExecutor().scheduleWithFixedDelay(this::updateData, 1L, 1L, TimeUnit.SECONDS);
    }

    public void updateHooks() {
        boolean hasPlaceholderAPI = this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
        this.playerDataAccess = hasPlaceholderAPI ? JoinedDataAccess.of(new PlayerDataAccess((Plugin)this.plugin), new ATODataAccess(this.plugin.getLogger(), (Plugin)this.plugin), new PAPIDataAccess(this.plugin.getLogger(), (Plugin)this.plugin)) : JoinedDataAccess.of(new PlayerDataAccess((Plugin)this.plugin), new ATODataAccess(this.plugin.getLogger(), (Plugin)this.plugin));
    }

    private void updateData() {
        try {
            for (PlayerDataHolder dataHolder : this.dataHolderSet) {
                dataHolder.update((ScheduledExecutorService)this.plugin.getTabEventQueue(), this.playerDataAccess);
            }
        }
        catch (Throwable th) {
            this.plugin.getLogger().log(Level.SEVERE, "Unexpected exception", th);
        }
    }

    PlayerDataHolder createDataHolder(Player player) {
        PlayerDataHolder dataHolder = new PlayerDataHolder(player);
        this.dataHolderSet.add(dataHolder);
        return dataHolder;
    }

    void removeDataHolder(PlayerDataHolder dataHolder) {
        this.dataHolderSet.remove(dataHolder);
    }

    class PlayerDataHolder
    extends DataCache {
        private Set<DataKey<?>> activeKeys = Sets.newConcurrentHashSet();
        private final Player player;

        private PlayerDataHolder(Player player) {
            this.player = player;
        }

        void update(ScheduledExecutorService tabEventQueue, DataAccess<Player> playerDataAccess) {
            for (DataKey<?> activeKey : this.activeKeys) {
                DataKey dataKey = (DataKey)Unchecked.cast(activeKey);
                Object o = null;
                try {
                    o = playerDataAccess.get(dataKey, this.player);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                if (Objects.equals(o, this.get(dataKey))) continue;
                Object finalO = o;
                tabEventQueue.submit(() -> {
                    try {
                        super.updateValue(dataKey, finalO);
                    }
                    catch (Throwable th) {
                        DataManager.this.plugin.getLogger().log(Level.SEVERE, "Unexpected exception.", th);
                    }
                });
            }
        }

        @Override
        public <V> V get(DataKey<V> key) {
            if (!this.activeKeys.contains(key) && DataManager.this.plugin.getTabEventQueue().inEventLoop()) {
                throw new IllegalStateException("No listener registered for datakey " + key);
            }
            return super.get(key);
        }

        @Override
        public <T> void addDataChangeListener(DataKey<T> key, Runnable listener) {
            super.addDataChangeListener(key, listener);
            this.activeKeys.add(key);
        }

        @Override
        public <T> void removeDataChangeListener(DataKey<T> key, Runnable listener) {
            super.removeDataChangeListener(key, listener);
            if (!this.hasListeners(key)) {
                this.activeKeys.remove(key);
            }
        }
    }
}

