/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal;

import de.codecrafter47.data.api.DataKey;
import de.codecrafter47.taboverlay.bukkit.AdvancedTabOverlay;
import de.codecrafter47.taboverlay.bukkit.internal.DataManager;
import de.codecrafter47.taboverlay.config.player.Player;
import java.util.UUID;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitPlayer
implements Player {
    private final org.bukkit.entity.Player bukkitPlayer;
    private final DataManager.PlayerDataHolder dataHolder;

    public BukkitPlayer(org.bukkit.entity.Player bukkitPlayer) {
        this.bukkitPlayer = bukkitPlayer;
        this.dataHolder = ((AdvancedTabOverlay)JavaPlugin.getPlugin(AdvancedTabOverlay.class)).getDataManager().createDataHolder(bukkitPlayer);
    }

    void onDisconnect() {
        ((AdvancedTabOverlay)JavaPlugin.getPlugin(AdvancedTabOverlay.class)).getDataManager().removeDataHolder(this.dataHolder);
    }

    @Override
    public String getName() {
        return this.bukkitPlayer.getName();
    }

    @Override
    public UUID getUniqueID() {
        return this.bukkitPlayer.getUniqueId();
    }

    public org.bukkit.entity.Player getBukkitPlayer() {
        return this.bukkitPlayer;
    }

    @Override
    public <V> V get(@Nonnull @NonNull DataKey<V> key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.dataHolder.get(key);
    }

    @Override
    public <T> void addDataChangeListener(@Nonnull @NonNull DataKey<T> key, @Nonnull @NonNull Runnable listener) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.dataHolder.addDataChangeListener(key, listener);
    }

    @Override
    public <T> void removeDataChangeListener(@Nonnull @NonNull DataKey<T> key, @Nonnull @NonNull Runnable listener) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        this.dataHolder.removeDataChangeListener(key, listener);
    }
}

