/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit.internal;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import de.codecrafter47.data.bukkit.AbstractBukkitDataAccess;
import de.codecrafter47.data.bukkit.PlayerDataAccess;
import de.codecrafter47.data.bukkit.api.BukkitData;
import de.codecrafter47.taboverlay.Icon;
import de.codecrafter47.taboverlay.ProfileProperty;
import de.codecrafter47.taboverlay.bukkit.internal.ATODataKeys;
import java.util.Collection;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ATODataAccess
extends AbstractBukkitDataAccess<Player> {
    private final PlayerDataAccess playerDataAccess;

    public ATODataAccess(Logger logger, Plugin plugin) {
        super(logger, plugin);
        this.addProvider(ATODataKeys.PING, ATODataAccess::getPlayerPing);
        this.addProvider(ATODataKeys.GAMEMODE, ATODataAccess::getPlayerGamemode);
        this.addProvider(ATODataKeys.ICON, ATODataAccess::getPlayerIcon);
        this.addProvider(ATODataKeys.HIDDEN, this::isPlayerInvisible);
        this.playerDataAccess = new PlayerDataAccess(plugin);
    }

    private static Icon getPlayerIcon(Player player) {
        WrappedGameProfile gameProfile = WrappedGameProfile.fromPlayer((Player)player);
        Collection textures = gameProfile.getProperties().get((Object)"textures");
        if (textures.isEmpty()) {
            if ((gameProfile.getUUID().hashCode() & 1) == 1) {
                return Icon.DEFAULT_ALEX;
            }
            return Icon.DEFAULT_STEVE;
        }
        WrappedSignedProperty property = (WrappedSignedProperty)textures.iterator().next();
        return new Icon(new ProfileProperty(property.getName(), property.getValue(), property.getSignature()));
    }

    private static Integer getPlayerPing(Player player) {
        return player.getPing();
    }

    private static Integer getPlayerGamemode(Player player) {
        return player.getGameMode().getValue();
    }

    private Boolean isPlayerInvisible(Player player) {
        if (Boolean.TRUE.equals(this.playerDataAccess.get(BukkitData.CMI_IsVanished, player))) {
            return true;
        }
        if (Boolean.TRUE.equals(this.playerDataAccess.get(BukkitData.Essentials_IsVanished, player))) {
            return true;
        }
        if (Boolean.TRUE.equals(this.playerDataAccess.get(BukkitData.SuperVanish_IsVanished, player))) {
            return true;
        }
        if (Boolean.TRUE.equals(this.playerDataAccess.get(BukkitData.VanishNoPacket_IsVanished, player))) {
            return true;
        }
        return false;
    }
}

