/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay.bukkit;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.PacketListener;
import com.google.common.collect.ImmutableSet;
import de.codecrafter47.data.minecraft.api.MinecraftData;
import de.codecrafter47.taboverlay.TabView;
import de.codecrafter47.taboverlay.bukkit.TabOverlayHandlerFactory;
import de.codecrafter47.taboverlay.bukkit.internal.ATOCommand;
import de.codecrafter47.taboverlay.bukkit.internal.ATODataKeys;
import de.codecrafter47.taboverlay.bukkit.internal.DataManager;
import de.codecrafter47.taboverlay.bukkit.internal.PAPIListener;
import de.codecrafter47.taboverlay.bukkit.internal.PlayerManager;
import de.codecrafter47.taboverlay.bukkit.internal.PlayerTabViewManager;
import de.codecrafter47.taboverlay.bukkit.internal.config.MainConfig;
import de.codecrafter47.taboverlay.bukkit.internal.config.PlayersByWorldComponentConfiguration;
import de.codecrafter47.taboverlay.bukkit.internal.handler.safe.SafeTabOverlayHandlerFactory;
import de.codecrafter47.taboverlay.bukkit.internal.placeholders.PAPIAwarePlayerPlaceholderResolver;
import de.codecrafter47.taboverlay.bukkit.internal.placeholders.PlayerPlaceholderResolver;
import de.codecrafter47.taboverlay.bukkit.internal.util.Completer;
import de.codecrafter47.taboverlay.config.ComponentSpec;
import de.codecrafter47.taboverlay.config.ConfigTabOverlayManager;
import de.codecrafter47.taboverlay.config.ErrorHandler;
import de.codecrafter47.taboverlay.config.dsl.customplaceholder.CustomPlaceholderConfiguration;
import de.codecrafter47.taboverlay.config.icon.DefaultIconManager;
import de.codecrafter47.taboverlay.config.platform.EventListener;
import de.codecrafter47.taboverlay.config.platform.Platform;
import de.codecrafter47.taboverlay.config.player.Player;
import de.codecrafter47.taboverlay.config.spectator.SpectatorPassthroughTabOverlayManager;
import de.codecrafter47.taboverlay.libs.bstats.bukkit.Metrics;
import de.codecrafter47.taboverlay.libs.snakeyaml.Yaml;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AdvancedTabOverlay
extends JavaPlugin
implements Listener {
    private PlayerTabViewManager tabViewManager;
    private TabOverlayHandlerFactory tabOverlayHandlerFactory;
    private ConfigTabOverlayManager configTabOverlayManager;
    private SpectatorPassthroughTabOverlayManager spectatorPassthroughTabOverlayManager;
    private List<EventListener> listeners = new ArrayList<EventListener>();
    private EventExecutor tabEventQueue;
    private EventExecutorGroup asyncExecutor;
    private PlayerManager playerManager;
    private DataManager dataManager;
    private DefaultIconManager iconManager;
    private Future<Void> softReloadTask;
    private MainConfig config;
    private Yaml yaml;

    public void onLoad() {
        this.dataManager = new DataManager(this);
    }

    public void onEnable() {
        Metrics metrics = new Metrics((Plugin)this);
        this.getCommand("ato").setExecutor((CommandExecutor)new ATOCommand());
        this.getCommand("ato").setTabCompleter((TabCompleter)Completer.create().any("reload", "info"));
        this.asyncExecutor = new DefaultEventExecutorGroup(4);
        this.tabEventQueue = (Class.forName("io.netty.util.concurrent.DefaultEventExecutor").getModifiers() & 1) != 0 ? new DefaultEventExecutor() : new DefaultEventExecutorGroup(1).next();
        this.playerManager = new PlayerManager(this);
        this.tabViewManager = new PlayerTabViewManager(this, this.getLogger(), (Executor)this.asyncExecutor);
        this.tabOverlayHandlerFactory = new SafeTabOverlayHandlerFactory();
        File dataFolder = this.getDataFolder();
        if (!dataFolder.exists()) {
            try {
                ZipEntry entry;
                ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.getFile()));
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    String entryName = entry.getName();
                    if (entry.isDirectory() || !entryName.startsWith("default/")) continue;
                    entryName = entryName.substring(8);
                    try {
                        File targetFile = new File(dataFolder, entryName);
                        targetFile.getParentFile().mkdirs();
                        if (targetFile.exists()) continue;
                        Files.copy(zipInputStream, targetFile.toPath(), new CopyOption[0]);
                        this.getLogger().info("Extracted " + entryName);
                    }
                    catch (IOException ex) {
                        this.getLogger().log(Level.SEVERE, "Failed to extract file " + entryName, ex);
                    }
                }
                zipInputStream.close();
            }
            catch (IOException ex) {
                this.getLogger().log(Level.SEVERE, "Error extracting files", ex);
            }
        }
        this.iconManager = new DefaultIconManager((ScheduledExecutorService)this.asyncExecutor, (ScheduledExecutorService)this.tabEventQueue, this.getDataFolder().toPath().resolve("icons"), this.getLogger());
        boolean hasPlaceholderAPI = this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
        ConfigTabOverlayManager.Options options = ConfigTabOverlayManager.Options.createBuilderWithDefaults().playerIconDataKey(ATODataKeys.ICON).playerPingDataKey(ATODataKeys.PING).playerInvisibleDataKey(ATODataKeys.HIDDEN).playerCanSeeInvisibleDataKey(MinecraftData.permission("advancedtaboverlay.seehidden")).component(new ComponentSpec("!players_by_world", PlayersByWorldComponentConfiguration.class)).build();
        this.yaml = ConfigTabOverlayManager.constructYamlInstance(options);
        MyPlatform platform = new MyPlatform();
        this.configTabOverlayManager = new ConfigTabOverlayManager(platform, this.playerManager, hasPlaceholderAPI ? new PAPIAwarePlayerPlaceholderResolver() : new PlayerPlaceholderResolver(), Collections.emptySet(), this.yaml, options, this.getLogger(), (ScheduledExecutorService)this.tabEventQueue, this.iconManager);
        this.spectatorPassthroughTabOverlayManager = new SpectatorPassthroughTabOverlayManager(platform, (ScheduledExecutorService)this.tabEventQueue, ATODataKeys.GAMEMODE);
        if (hasPlaceholderAPI) {
            PAPIListener listener = new PAPIListener(() -> this.getServer().getScheduler().runTaskLater((Plugin)this, this::onServerFullyLoaded, 20L));
            this.getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)this);
        } else {
            this.getServer().getScheduler().runTaskLater((Plugin)this, this::onServerFullyLoaded, 20L);
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.dataManager.enable();
        for (org.bukkit.entity.Player player : this.getServer().getOnlinePlayers()) {
            this.addPlayer(player);
        }
    }

    private void loadMainConfig() {
        block6: {
            try {
                File configFile = new File(this.getDataFolder(), "config.yml");
                if (!configFile.exists()) {
                    this.config = new MainConfig();
                    this.config.needWrite = true;
                } else {
                    ErrorHandler.set(new ErrorHandler());
                    this.config = this.yaml.loadAs(new FileInputStream(configFile), MainConfig.class);
                    ErrorHandler errorHandler = ErrorHandler.get();
                    ErrorHandler.set(null);
                    if (!errorHandler.getEntries().isEmpty()) {
                        this.getLogger().log(Level.WARNING, errorHandler.formatErrors(configFile.getName()));
                    }
                }
                if (this.config.needWrite) {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8));
                    this.config.write(writer, this.yaml);
                }
            }
            catch (IOException ex) {
                this.getLogger().log(Level.SEVERE, "Failed to load config.yml: " + ex.getMessage(), ex);
                if (this.config != null) break block6;
                this.config = new MainConfig();
            }
        }
    }

    private void onServerFullyLoaded() {
        ProtocolManager pm = ProtocolLibrary.getProtocolManager();
        ArrayList<PacketListener> incompatibleListeners = new ArrayList<PacketListener>();
        for (PacketListener listener : pm.getPacketListeners()) {
            Set types = listener.getSendingWhitelist().getTypes();
            Set options = listener.getSendingWhitelist().getOptions();
            if ((options.contains(ListenerOptions.ASYNC) || !types.contains(PacketType.Play.Server.PLAYER_INFO) && !types.contains(PacketType.Play.Server.PLAYER_LIST_HEADER_FOOTER)) && !types.contains(PacketType.Play.Server.SCOREBOARD_TEAM)) continue;
            incompatibleListeners.add(listener);
        }
        if (!incompatibleListeners.isEmpty()) {
            this.getLogger().severe("--------------------------------------");
            this.getLogger().severe("INCOMPATIBLE PACKET LISTENERS DETECTED");
            this.getLogger().severe("--------------------------------------");
            for (PacketListener listener : incompatibleListeners) {
                String clazz = listener.getClass().getName();
                String plugin = listener.getPlugin().getName();
                this.getLogger().severe("");
                this.getLogger().severe("> Class: " + clazz);
                this.getLogger().severe("  Plugin: " + plugin);
                this.getLogger().severe("  Intercepts one of PLAYER_INFO, PLAYER_LIST_HEADER_FOOTER or SCOREBOARD_TEAM but does not have the ASYNC option set.");
                this.getLogger().severe("  Please tell the plugin author of " + plugin + " to make the listener thread safe and set ListenerOptions.ASYNC for compatibility with AdvancedTabOverlay.");
                this.getLogger().severe("  AdvancedTabOverlay will try to enable ListenerOptions.ASYNC for this listener to prevent incompatibilities. This might prevent " + plugin + " from working correctly.");
                try {
                    ListeningWhitelist sendingWhitelist = listener.getSendingWhitelist();
                    Field options = ListeningWhitelist.class.getDeclaredField("options");
                    options.setAccessible(true);
                    ((Set)options.get(sendingWhitelist)).add(ListenerOptions.ASYNC);
                }
                catch (Throwable th) {
                    this.getLogger().severe("  Failed to set ListenerOptions.ASYNC: " + th.getMessage());
                }
            }
            ImmutableSet packetListeners = pm.getPacketListeners();
            for (PacketListener listener : packetListeners) {
                pm.removePacketListener(listener);
            }
            for (PacketListener listener : packetListeners) {
                pm.addPacketListener(listener);
            }
        }
        Path tabLists = this.getDataFolder().toPath().resolve("tabLists");
        Files.createDirectories(tabLists, new FileAttribute[0]);
        this.reload();
    }

    public void onDisable() {
        this.asyncExecutor.shutdownGracefully();
        this.tabEventQueue.shutdownGracefully();
        this.tabOverlayHandlerFactory.onDisable();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        org.bukkit.entity.Player bukkitPlayer = event.getPlayer();
        this.addPlayer(bukkitPlayer);
    }

    private void addPlayer(org.bukkit.entity.Player bukkitPlayer) {
        Player player = this.playerManager.onPlayerJoin(bukkitPlayer);
        TabView tabView = this.tabViewManager.get(bukkitPlayer);
        tabView.getTabOverlayProviders().activate(this.tabOverlayHandlerFactory.create(bukkitPlayer));
        this.tabOverlayHandlerFactory.onCreated(tabView, bukkitPlayer);
        for (EventListener listener : this.listeners) {
            listener.onTabViewAdded(tabView, player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDisconnect(PlayerQuitEvent event) {
        org.bukkit.entity.Player player = event.getPlayer();
        this.playerManager.onPlayerDisconnect(player);
        TabView tabView = this.tabViewManager.get(player);
        this.tabViewManager.removeFromPlayer(player);
        for (EventListener listener : this.listeners) {
            listener.onTabViewRemoved(tabView);
        }
        tabView.deactivate();
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        this.scheduleSoftReload();
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        this.scheduleSoftReload();
    }

    public TabView getTabView(org.bukkit.entity.Player player) {
        return this.tabViewManager.get(player);
    }

    public void reload() {
        this.loadMainConfig();
        if (this.config.disableCustomTabListForSpectators) {
            this.spectatorPassthroughTabOverlayManager.enable();
        } else {
            this.spectatorPassthroughTabOverlayManager.disable();
        }
        HashMap<String, CustomPlaceholderConfiguration> customPlaceholders = new HashMap<String, CustomPlaceholderConfiguration>();
        if (this.config.customPlaceholders != null) {
            for (Map.Entry<String, CustomPlaceholderConfiguration> entry : this.config.customPlaceholders.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                customPlaceholders.put(entry.getKey(), entry.getValue());
            }
        }
        this.configTabOverlayManager.setGlobalCustomPlaceholders(customPlaceholders);
        this.configTabOverlayManager.setTimeZone(TimeZone.getTimeZone(this.config.timeZone));
        this.iconManager.clearCache();
        Path tabLists = this.getDataFolder().toPath().resolve("tabLists");
        this.configTabOverlayManager.reloadConfigs((Iterable<Path>)ImmutableSet.of((Object)tabLists));
    }

    private void scheduleSoftReload() {
        if (this.softReloadTask == null) {
            this.softReloadTask = this.getServer().getScheduler().callSyncMethod((Plugin)this, () -> {
                this.softReload();
                return null;
            });
        }
    }

    private void softReload() {
        this.softReloadTask = null;
        this.dataManager.updateHooks();
        this.configTabOverlayManager.refreshConfigs();
    }

    public EventExecutor getTabEventQueue() {
        return this.tabEventQueue;
    }

    public EventExecutorGroup getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public DefaultIconManager getIconManager() {
        return this.iconManager;
    }

    private final class MyPlatform
    implements Platform {
        private MyPlatform() {
        }

        @Override
        public void addEventListener(EventListener listener) {
            AdvancedTabOverlay.this.listeners.add(listener);
        }
    }
}

