/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay;

import de.codecrafter47.taboverlay.DefaultTabOverlayProvider;
import de.codecrafter47.taboverlay.TabOverlayProvider;
import de.codecrafter47.taboverlay.TabView;
import de.codecrafter47.taboverlay.handler.TabOverlayHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TabOverlayProviderSet {
    private static final Comparator<TabOverlayProvider> PRIORITY_COMPARATOR = Comparator.comparingInt(TabOverlayProvider::getPriority).reversed();
    private final TabView tabView;
    private final Executor updateExecutor;
    private final Runnable update = this::update;
    private final AtomicBoolean updateScheduled = new AtomicBoolean(false);
    private final List<TabOverlayProvider> providers;
    @Nullable
    private TabOverlayProvider activeProvider;
    @Nullable
    private TabOverlayHandler tabOverlayHandler;
    private boolean active = true;

    TabOverlayProviderSet(TabView tabView, Executor updateExecutor) {
        this.tabView = tabView;
        this.updateExecutor = updateExecutor;
        this.providers = new ArrayList<TabOverlayProvider>();
    }

    private synchronized void setActiveProvider(@Nonnull TabOverlayProvider provider) {
        if (!this.active) {
            return;
        }
        if (this.activeProvider != null) {
            try {
                this.activeProvider.deactivate(this.tabView);
            }
            catch (Throwable th) {
                this.tabView.getLogger().log(Level.SEVERE, "Failed to deactivate TabOverlayProvider " + provider.getName(), th);
            }
        }
        this.activeProvider = provider;
        try {
            this.activeProvider.activate(this.tabView, this.tabOverlayHandler);
        }
        catch (Throwable th) {
            this.tabView.getLogger().log(Level.SEVERE, "Failed to activate TabOverlayProvider " + provider.getName(), th);
        }
    }

    private synchronized void update() {
        if (this.tabOverlayHandler == null) {
            return;
        }
        this.updateScheduled.set(false);
        for (TabOverlayProvider provider : this.providers) {
            boolean shouldActivate = false;
            try {
                shouldActivate = provider.shouldActivate(this.tabView);
            }
            catch (Throwable th) {
                this.tabView.getLogger().log(Level.SEVERE, "Unexpected exception invoking shouldActivate on TabOverlayProvider " + provider.getName(), th);
            }
            if (!shouldActivate) continue;
            if (provider != this.activeProvider) {
                this.setActiveProvider(provider);
            }
            return;
        }
        this.setActiveProvider(DefaultTabOverlayProvider.getInstance());
    }

    public synchronized void addProviders(Collection<TabOverlayProvider> providers) {
        if (!this.active) {
            return;
        }
        ArrayList<TabOverlayProvider> tabOverlayProviders = new ArrayList<TabOverlayProvider>(providers);
        Set names = tabOverlayProviders.stream().map(TabOverlayProvider::getName).collect(Collectors.toSet());
        for (TabOverlayProvider provider : this.providers) {
            if (!names.contains(provider.getName())) continue;
            throw new IllegalArgumentException("Duplicate provider name " + provider.getName());
        }
        this.providers.addAll(tabOverlayProviders);
        this.providers.sort(PRIORITY_COMPARATOR);
        this.updateExecutor.execute(() -> {
            for (TabOverlayProvider provider : tabOverlayProviders) {
                provider.attach(this.tabView);
            }
            this.update();
        });
    }

    public synchronized void addProvider(TabOverlayProvider provider) {
        if (!this.active) {
            return;
        }
        if (this.providers.stream().anyMatch(p -> p.getName().equals(provider.getName()))) {
            throw new IllegalArgumentException("Duplicate provider name " + provider.getName());
        }
        this.providers.add(provider);
        this.providers.sort(PRIORITY_COMPARATOR);
        this.updateExecutor.execute(() -> {
            provider.attach(this.tabView);
            this.update();
        });
    }

    public synchronized void removeProvider(TabOverlayProvider provider) {
        if (!this.active) {
            return;
        }
        if (this.providers.remove(provider)) {
            this.updateExecutor.execute(() -> {
                this.update();
                provider.detach(this.tabView);
            });
        }
    }

    public synchronized TabOverlayProvider getActiveProvider() {
        return this.activeProvider;
    }

    public synchronized void removeProviders(Class<? extends TabOverlayProvider> providerClass) {
        if (!this.active) {
            return;
        }
        List toRemove = this.providers.stream().filter(p -> providerClass.isAssignableFrom(p.getClass())).collect(Collectors.toList());
        this.providers.removeIf(p -> providerClass.isAssignableFrom(p.getClass()));
        this.updateExecutor.execute(() -> {
            this.update();
            for (TabOverlayProvider provider : toRemove) {
                provider.detach(this.tabView);
            }
        });
    }

    public synchronized void removeProvider(String name) {
        if (!this.active) {
            return;
        }
        for (TabOverlayProvider provider : this.providers) {
            if (!provider.getName().equals(name)) continue;
            this.removeProvider(provider);
            return;
        }
    }

    public void scheduleUpdate() {
        if (!this.active) {
            return;
        }
        if (this.updateScheduled.compareAndSet(false, true)) {
            this.updateExecutor.execute(this.update);
        }
    }

    public synchronized void activate(TabOverlayHandler handler) {
        this.tabOverlayHandler = handler;
        this.scheduleUpdate();
    }

    synchronized void deactivate() {
        this.updateExecutor.execute(() -> {
            TabOverlayProviderSet tabOverlayProviderSet = this;
            synchronized (tabOverlayProviderSet) {
                for (TabOverlayProvider provider : this.providers) {
                    if (provider == DefaultTabOverlayProvider.getInstance()) continue;
                    provider.detach(this.tabView);
                }
                this.providers.clear();
                this.update();
                this.active = false;
            }
        });
    }
}

