/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay;

import de.codecrafter47.taboverlay.ProfileProperty;
import java.io.Serializable;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class Icon
implements Serializable {
    private static final long serialVersionUID = -8251683111229590559L;
    public static final Icon DEFAULT_STEVE = new Icon(null, true, false);
    public static final Icon DEFAULT_ALEX = new Icon(null, false, true);
    private final ProfileProperty textureProperty;
    private final boolean steve;
    private final boolean alex;

    private Icon(ProfileProperty textureProperty, boolean steve, boolean alex) {
        this.textureProperty = textureProperty;
        this.steve = steve;
        this.alex = alex;
    }

    public Icon(@Nonnull @NonNull ProfileProperty textureProperty) {
        this(textureProperty, false, false);
        if (textureProperty == null) {
            throw new NullPointerException("textureProperty is marked non-null but is null");
        }
    }

    public boolean hasTextureProperty() {
        return this.textureProperty != null;
    }

    public ProfileProperty getTextureProperty() {
        return this.textureProperty;
    }

    public boolean isSteve() {
        return this.steve;
    }

    public boolean isAlex() {
        return this.alex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Icon)) {
            return false;
        }
        Icon other = (Icon)o;
        if (this.isSteve() != other.isSteve()) {
            return false;
        }
        if (this.isAlex() != other.isAlex()) {
            return false;
        }
        ProfileProperty this$textureProperty = this.getTextureProperty();
        ProfileProperty other$textureProperty = other.getTextureProperty();
        return !(this$textureProperty == null ? other$textureProperty != null : !((Object)this$textureProperty).equals(other$textureProperty));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSteve() ? 79 : 97);
        result = result * 59 + (this.isAlex() ? 79 : 97);
        ProfileProperty $textureProperty = this.getTextureProperty();
        result = result * 59 + ($textureProperty == null ? 43 : ((Object)$textureProperty).hashCode());
        return result;
    }

    public String toString() {
        return "Icon(textureProperty=" + this.getTextureProperty() + ", steve=" + this.isSteve() + ", alex=" + this.isAlex() + ")";
    }
}

