/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay;

import de.codecrafter47.taboverlay.TabOverlayProvider;
import de.codecrafter47.taboverlay.TabView;
import de.codecrafter47.taboverlay.handler.ContentOperationMode;
import de.codecrafter47.taboverlay.handler.HeaderAndFooterOperationMode;
import de.codecrafter47.taboverlay.handler.TabOverlayHandle;
import de.codecrafter47.taboverlay.handler.TabOverlayHandler;
import javax.annotation.Nonnull;
import lombok.NonNull;

public abstract class AbstractTabOverlayProvider<T1 extends TabOverlayHandle, T2 extends TabOverlayHandle>
extends TabOverlayProvider {
    private final ContentOperationMode<? extends T1> contentMode;
    private final HeaderAndFooterOperationMode<? extends T2> headerAndFooterMode;

    protected AbstractTabOverlayProvider(@Nonnull @NonNull String name, int priority, @Nonnull @NonNull ContentOperationMode<? extends T1> contentMode, @Nonnull @NonNull HeaderAndFooterOperationMode<? extends T2> headerAndFooterMode) {
        super(name, priority);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (contentMode == null) {
            throw new NullPointerException("contentMode is marked non-null but is null");
        }
        if (headerAndFooterMode == null) {
            throw new NullPointerException("headerAndFooterMode is marked non-null but is null");
        }
        this.contentMode = contentMode;
        this.headerAndFooterMode = headerAndFooterMode;
    }

    @Override
    protected final void activate(TabView tabView, TabOverlayHandler tabOverlayHandler) {
        this.activate(tabView, (TabOverlayHandle)tabOverlayHandler.enterContentOperationMode(this.contentMode), (TabOverlayHandle)tabOverlayHandler.enterHeaderAndFooterOperationMode(this.headerAndFooterMode));
    }

    protected abstract void activate(TabView var1, T1 var2, T2 var3);
}

