/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.taboverlay;

import com.google.common.base.Preconditions;
import de.codecrafter47.taboverlay.TabOverlayProvider;
import de.codecrafter47.taboverlay.TabView;
import de.codecrafter47.taboverlay.handler.TabOverlayHandler;
import javax.annotation.Nonnull;
import lombok.NonNull;

public abstract class AbstractPlayerTabOverlayProvider
extends TabOverlayProvider {
    private final TabView tabView;

    public AbstractPlayerTabOverlayProvider(@Nonnull @NonNull TabView tabView, @Nonnull @NonNull String name, int priority) {
        super(name, priority);
        if (tabView == null) {
            throw new NullPointerException("tabView is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.tabView = tabView;
    }

    public final TabView getTabView() {
        return this.tabView;
    }

    @Override
    protected final void attach(TabView tabView) {
        Preconditions.checkState((tabView == this.getTabView() ? 1 : 0) != 0, (Object)"An AbstractPlayerTabOverlayProvider cannot be shared among multiple tab views.");
        this.onAttach();
    }

    @Override
    protected final void detach(TabView tabView) {
        Preconditions.checkState((tabView == this.getTabView() ? 1 : 0) != 0, (Object)"An AbstractPlayerTabOverlayProvider cannot be shared among multiple tab views.");
        this.onDetach();
    }

    @Override
    protected final void activate(TabView tabView, TabOverlayHandler handler) {
        Preconditions.checkState((tabView == this.getTabView() ? 1 : 0) != 0, (Object)"An AbstractPlayerTabOverlayProvider cannot be shared among multiple tab views.");
        this.onActivate(handler);
    }

    @Override
    protected final void deactivate(TabView tabView) {
        Preconditions.checkState((tabView == this.getTabView() ? 1 : 0) != 0, (Object)"An AbstractPlayerTabOverlayProvider cannot be shared among multiple tab views.");
        this.onDeactivate();
    }

    @Override
    protected final boolean shouldActivate(TabView tabView) {
        Preconditions.checkState((tabView == this.getTabView() ? 1 : 0) != 0, (Object)"An AbstractPlayerTabOverlayProvider cannot be shared among multiple tab views.");
        return this.shouldActivate();
    }

    protected abstract void onAttach();

    protected abstract void onActivate(TabOverlayHandler var1);

    protected abstract void onDeactivate();

    protected abstract void onDetach();

    protected abstract boolean shouldActivate();
}

