/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.data.bukkit.vault;

import de.codecrafter47.data.bukkit.vault.VaultDataProvider;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultBalanceProvider
extends VaultDataProvider<Player, Double> {
    private final Plugin plugin;

    public VaultBalanceProvider(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Double apply0(Player player) {
        Economy economy;
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (rsp != null && (economy = (Economy)rsp.getProvider()) != null && economy.isEnabled()) {
            if (!Bukkit.isPrimaryThread() && economy.getName().equals("Gringotts")) {
                try {
                    return (Double)Bukkit.getScheduler().callSyncMethod(this.plugin, () -> economy.getBalance((OfflinePlayer)player)).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to query balance for player " + player.getName(), e);
                }
            } else {
                return economy.getBalance((OfflinePlayer)player);
            }
        }
        return null;
    }
}

