/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.data.bukkit.playerpoints;

import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.PlayerPointsAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerPointsProvider
implements Function<Player, Integer> {
    private final Logger logger;

    public PlayerPointsProvider(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Integer apply(Player player) {
        PlayerPointsAPI playerPoints;
        Plugin plugin = Bukkit.getPluginManager().getPlugin("PlayerPoints");
        if (plugin != null && (playerPoints = ((PlayerPoints)plugin).getAPI()) != null) {
            for (int i = 0; i < 5; ++i) {
                try {
                    return playerPoints.look(player.getUniqueId());
                }
                catch (Throwable th) {
                    if (i != 4) continue;
                    this.logger.log(Level.SEVERE, "Failed to query PlayerPoints for " + player.getName() + ". Attempt 5", th);
                    continue;
                }
            }
        }
        return null;
    }
}

