/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.data.bukkit;

import de.codecrafter47.data.bukkit.AbstractBukkitDataAccess;
import de.codecrafter47.data.bukkit.api.BukkitData;
import de.codecrafter47.data.bukkit.askyblock.ASkyBlockIslandLevelProvider;
import de.codecrafter47.data.bukkit.askyblock.ASkyBlockIslandNameProvider;
import de.codecrafter47.data.bukkit.askyblock.ASkyBlockTeamLeaderProvider;
import de.codecrafter47.data.bukkit.cmi.CMIIsVanishedProvider;
import de.codecrafter47.data.bukkit.essentials.EssentialsIsAFKProvider;
import de.codecrafter47.data.bukkit.essentials.EssentialsIsVanishedProvider;
import de.codecrafter47.data.bukkit.factions.FactionNameProvider;
import de.codecrafter47.data.bukkit.factions.FactionOnlineMembersProvider;
import de.codecrafter47.data.bukkit.factions.FactionRankProvider;
import de.codecrafter47.data.bukkit.factions.FactionWhereProvider;
import de.codecrafter47.data.bukkit.factions.FactionsPlayerPowerProvider;
import de.codecrafter47.data.bukkit.factionsuuid.FactionMembersProvider;
import de.codecrafter47.data.bukkit.factionsuuid.FactionMembersProvider05;
import de.codecrafter47.data.bukkit.factionsuuid.FactionNameProvider05;
import de.codecrafter47.data.bukkit.factionsuuid.FactionOnlineMembersProvider05;
import de.codecrafter47.data.bukkit.factionsuuid.FactionPlayerPowerProvider;
import de.codecrafter47.data.bukkit.factionsuuid.FactionPlayerPowerProvider05;
import de.codecrafter47.data.bukkit.factionsuuid.FactionPowerProvider;
import de.codecrafter47.data.bukkit.factionsuuid.FactionPowerProvider05;
import de.codecrafter47.data.bukkit.factionsuuid.FactionRankProvider05;
import de.codecrafter47.data.bukkit.factionsuuid.FactionWhereProvider05;
import de.codecrafter47.data.bukkit.multiverse.MultiverseWorldAliasProvider;
import de.codecrafter47.data.bukkit.playerpoints.PlayerPointsProvider;
import de.codecrafter47.data.bukkit.protocolvanish.ProtocolVanishIsVanishedProvider;
import de.codecrafter47.data.bukkit.simpleclans.SimpleClansClanColorTagProvider;
import de.codecrafter47.data.bukkit.simpleclans.SimpleClansClanNameProvider;
import de.codecrafter47.data.bukkit.simpleclans.SimpleClansClanTagLabelProvider;
import de.codecrafter47.data.bukkit.simpleclans.SimpleClansClanTagProvider;
import de.codecrafter47.data.bukkit.simpleclans.SimpleClansMembersProvider;
import de.codecrafter47.data.bukkit.simpleclans.SimpleClansOnlineClanMembersProvider;
import de.codecrafter47.data.bukkit.supervanish.SuperVanishIsVanishedProvider;
import de.codecrafter47.data.bukkit.vanishnopacket.VanishNoPacketIsVanishedProvider;
import de.codecrafter47.data.bukkit.vault.VaultBalanceProvider;
import de.codecrafter47.data.bukkit.vault.VaultGroupProvider;
import de.codecrafter47.data.bukkit.vault.VaultGroupRankProvider;
import de.codecrafter47.data.bukkit.vault.VaultGroupWeightProvider;
import de.codecrafter47.data.bukkit.vault.VaultPlayerPrefixProvider;
import de.codecrafter47.data.bukkit.vault.VaultPrefixProvider;
import de.codecrafter47.data.bukkit.vault.VaultPrimaryGroupPrefixProvider;
import de.codecrafter47.data.bukkit.vault.VaultSuffixProvider;
import de.codecrafter47.data.minecraft.api.MinecraftData;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;

public class PlayerDataAccess
extends AbstractBukkitDataAccess<Player> {
    private final Plugin plugin;

    public PlayerDataAccess(Plugin plugin) {
        super(plugin.getLogger(), plugin);
        this.plugin = plugin;
        this.init();
    }

    protected void init() {
        this.addProvider(MinecraftData.Health, (B player) -> player.getHealth());
        this.addProvider(MinecraftData.Level, Player::getLevel);
        this.addProvider(MinecraftData.MaxHealth, (B player) -> player.getMaxHealth());
        this.addProvider(MinecraftData.XP, Player::getExp);
        this.addProvider(MinecraftData.TotalXP, Player::getTotalExperience);
        this.addProvider(MinecraftData.PosX, (B player) -> player.getLocation().getX());
        this.addProvider(MinecraftData.PosY, (B player) -> player.getLocation().getY());
        this.addProvider(MinecraftData.PosZ, (B player) -> player.getLocation().getZ());
        this.addProvider(MinecraftData.Team, (B player) -> {
            Team team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player);
            return team != null ? team.getName() : null;
        });
        this.addProvider(MinecraftData.TeamColor, (B player) -> {
            Team team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player);
            return team != null ? team.getColor().toString() : null;
        });
        this.addProvider(MinecraftData.TeamDisplayName, (B player) -> {
            Team team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player);
            return team != null ? team.getDisplayName() : null;
        });
        this.addProvider(MinecraftData.TeamPrefix, (B player) -> {
            Team team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player);
            return team != null ? team.getPrefix() : null;
        });
        this.addProvider(MinecraftData.TeamSuffix, (B player) -> {
            Team team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player);
            return team != null ? team.getSuffix() : null;
        });
        this.addProvider(MinecraftData.Permission, (B player, K key) -> {
            try {
                return player.hasPermission(key.getParameter());
            }
            catch (Throwable ignored) {
                return null;
            }
        });
        this.addProvider(MinecraftData.DisplayName, Player::getDisplayName);
        this.addProvider(BukkitData.PlayerListName, Player::getPlayerListName);
        this.addProvider(MinecraftData.World, (B player) -> player.getWorld().getName());
        this.addProvider(BukkitData.BukkitPlayerMetadataVanished, (B player) -> {
            if (player.hasMetadata("vanished") && !player.getMetadata("vanished").isEmpty()) {
                return ((MetadataValue)player.getMetadata("vanished").get(0)).asBoolean();
            }
            return false;
        });
        if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
            this.addProvider(MinecraftData.Economy_Balance, new VaultBalanceProvider(this.plugin));
            this.addProvider(MinecraftData.Permissions_PermissionGroup, new VaultGroupProvider());
            this.addProvider(MinecraftData.Permissions_PermissionGroupWeight, new VaultGroupWeightProvider());
            this.addProvider(MinecraftData.Permissions_PermissionGroupRank, new VaultGroupRankProvider());
            this.addProvider(MinecraftData.Permissions_Prefix, new VaultPrefixProvider());
            this.addProvider(MinecraftData.Permissions_Suffix, new VaultSuffixProvider());
            this.addProvider(MinecraftData.Permissions_PrimaryGroupPrefix, new VaultPrimaryGroupPrefixProvider());
            this.addProvider(MinecraftData.Permissions_PlayerPrefix, new VaultPlayerPrefixProvider());
        }
        if (Bukkit.getPluginManager().getPlugin("VanishNoPacket") != null) {
            this.addProvider(BukkitData.VanishNoPacket_IsVanished, new VanishNoPacketIsVanishedProvider());
        }
        if (Bukkit.getPluginManager().getPlugin("PlayerPoints") != null) {
            this.addProvider(BukkitData.PlayerPoints_Points, new PlayerPointsProvider(this.logger));
        }
        if (Bukkit.getPluginManager().getPlugin("Factions") != null) {
            if (PlayerDataAccess.classExists("com.massivecraft.factions.FPlayer")) {
                if (PlayerDataAccess.classExists("com.massivecraft.factions.perms.Role")) {
                    this.addProvider(BukkitData.Factions_FactionName, new FactionNameProvider05());
                    this.addProvider(BukkitData.Factions_FactionMembers, new FactionMembersProvider05());
                    this.addProvider(BukkitData.Factions_FactionPower, new FactionPowerProvider05());
                    this.addProvider(BukkitData.Factions_FactionsRank, new FactionRankProvider05());
                    this.addProvider(BukkitData.Factions_FactionsWhere, new FactionWhereProvider05());
                    this.addProvider(BukkitData.Factions_OnlineFactionMembers, new FactionOnlineMembersProvider05());
                    this.addProvider(BukkitData.Factions_PlayerPower, new FactionPlayerPowerProvider05());
                } else {
                    this.addProvider(BukkitData.Factions_FactionName, new de.codecrafter47.data.bukkit.factionsuuid.FactionNameProvider());
                    this.addProvider(BukkitData.Factions_FactionMembers, new FactionMembersProvider());
                    this.addProvider(BukkitData.Factions_FactionPower, new FactionPowerProvider());
                    this.addProvider(BukkitData.Factions_FactionsRank, new de.codecrafter47.data.bukkit.factionsuuid.FactionRankProvider());
                    this.addProvider(BukkitData.Factions_FactionsWhere, new de.codecrafter47.data.bukkit.factionsuuid.FactionWhereProvider());
                    this.addProvider(BukkitData.Factions_OnlineFactionMembers, new de.codecrafter47.data.bukkit.factionsuuid.FactionOnlineMembersProvider());
                    this.addProvider(BukkitData.Factions_PlayerPower, new FactionPlayerPowerProvider());
                }
            } else if (PlayerDataAccess.classExists("com.massivecraft.factions.entity.MPlayer")) {
                this.addProvider(BukkitData.Factions_FactionName, new FactionNameProvider());
                this.addProvider(BukkitData.Factions_FactionMembers, new de.codecrafter47.data.bukkit.factions.FactionMembersProvider());
                this.addProvider(BukkitData.Factions_FactionPower, new de.codecrafter47.data.bukkit.factions.FactionPowerProvider());
                this.addProvider(BukkitData.Factions_FactionsRank, new FactionRankProvider());
                this.addProvider(BukkitData.Factions_FactionsWhere, new FactionWhereProvider());
                this.addProvider(BukkitData.Factions_OnlineFactionMembers, new FactionOnlineMembersProvider());
                this.addProvider(BukkitData.Factions_PlayerPower, new FactionsPlayerPowerProvider());
            } else {
                this.logger.warning("Unable to recognize your Factions version. Factions support is disabled. Please contact the plugin developer to request support for your Factions version (" + Bukkit.getPluginManager().getPlugin("Factions").getDescription().getVersion() + ").");
            }
        }
        if (Bukkit.getPluginManager().getPlugin("SuperVanish") != null || Bukkit.getPluginManager().getPlugin("PremiumVanish") != null) {
            this.addProvider(BukkitData.SuperVanish_IsVanished, new SuperVanishIsVanishedProvider());
        }
        if (Bukkit.getPluginManager().getPlugin("SimpleClans") != null) {
            this.addProvider(BukkitData.SimpleClans_ClanName, new SimpleClansClanNameProvider());
            this.addProvider(BukkitData.SimpleClans_ClanMembers, new SimpleClansMembersProvider());
            this.addProvider(BukkitData.SimpleClans_OnlineClanMembers, new SimpleClansOnlineClanMembersProvider());
            this.addProvider(BukkitData.SimpleClans_ClanTag, new SimpleClansClanTagProvider());
            this.addProvider(BukkitData.SimpleClans_ClanTagLabel, new SimpleClansClanTagLabelProvider());
            this.addProvider(BukkitData.SimpleClans_ClanColorTag, new SimpleClansClanColorTagProvider());
        }
        if (Bukkit.getPluginManager().getPlugin("Essentials") != null) {
            this.addProvider(BukkitData.Essentials_IsVanished, new EssentialsIsVanishedProvider());
            this.addProvider(BukkitData.Essentials_IsAFK, new EssentialsIsAFKProvider());
        }
        if (Bukkit.getPluginManager().getPlugin("Multiverse-Core") != null) {
            this.addProvider(BukkitData.Multiverse_WorldAlias, new MultiverseWorldAliasProvider());
        }
        if (Bukkit.getPluginManager().getPlugin("ASkyBlock") != null) {
            this.addProvider(BukkitData.ASkyBlock_IslandLevel, new ASkyBlockIslandLevelProvider());
            this.addProvider(BukkitData.ASkyBlock_IslandName, new ASkyBlockIslandNameProvider());
            this.addProvider(BukkitData.ASkyBlock_TeamLeader, new ASkyBlockTeamLeaderProvider());
        }
        if (Bukkit.getPluginManager().getPlugin("CMI") != null && PlayerDataAccess.isMethodPresent("com.Zrips.CMI.Containers.CMIUser", "isVanished", new Class[0])) {
            this.addProvider(BukkitData.CMI_IsVanished, new CMIIsVanishedProvider());
        }
        if (Bukkit.getPluginManager().isPluginEnabled("ProtocolVanish")) {
            this.addProvider(BukkitData.ProtocolVanish_IsVanished, new ProtocolVanishIsVanishedProvider());
        }
    }

    private static boolean classExists(String name) {
        try {
            Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    private static boolean isMethodPresent(String className, String methodName, Class<?> ... parameters) {
        try {
            Class.forName(className).getMethod(methodName, parameters);
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException ignored) {
            return false;
        }
    }
}

