/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter47.data.bukkit;

import de.codecrafter47.data.api.AbstractDataAccess;
import de.codecrafter47.data.api.DataKey;
import java.util.ConcurrentModificationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class AbstractBukkitDataAccess<B>
extends AbstractDataAccess<B> {
    protected final Logger logger;
    protected final Plugin plugin;

    public AbstractBukkitDataAccess(Logger logger, Plugin plugin) {
        this.logger = logger;
        this.plugin = plugin;
    }

    @Override
    public <V> V get(DataKey<V> key, B context) {
        try {
            return super.get(key, context);
        }
        catch (Throwable th) {
            if (!Bukkit.isPrimaryThread() && this.isAsyncOpError(th)) {
                try {
                    return Bukkit.getScheduler().callSyncMethod(this.plugin, () -> this.get(key, context)).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    this.logger.log(Level.SEVERE, "Unexpected exception", e);
                }
            }
            this.logger.log(Level.SEVERE, "Unexpected exception", th);
            return null;
        }
    }

    private boolean isAsyncOpError(Throwable th) {
        StackTraceElement[] st;
        return th instanceof ConcurrentModificationException || (st = th.getStackTrace()).length > 0 && st[0].getClassName().equals("org.spigotmc.AsyncCatcher") || th.getCause() != null && this.isAsyncOpError(th.getCause());
    }
}

